#include <config.h>
#include <errno.h>
#include "defines.h"
#include "rcsid.h"
RCSID("$Id: strerror.c,v 1.1 1997/09/29 22:01:13 marekm Exp $")

#include <stdio.h>

extern int sys_nerr;
extern char *sys_errlist[];

char *
strerror(err)
	int err;
{
	static char unknown[80];

	if (err >= 0 && err < sys_nerr)
		return sys_errlist[err];

	snprintf(unknown, sizeof unknown, "Unknown error %d", err);
	errno = EINVAL;
	return unknown;
}
