.\" For license terms, see the file COPYING in this directory.
.TH fetchmail LOCAL
.SH NAME
fetchmail \- fetch mail from a POP or IMAP server

.SH SYNOPSIS
\fBfetchmail\fR [\fIoptions\fR] [\fImailserver...\fR]

.SH DESCRIPTION
.I fetchmail
is a mail-retrieval and forwarding utility; it fetches
mail from remote mailservers and forwards it to your local (client)
machine's delivery system.  You can then handle the retrieved mail
using normal mail user agents such as \fIelm\fR(1) or \fIMail\fR(1).
The \fBfetchmail\fR utility can be run in a daemon mode to repeatedly
poll one or more systems at a specified interval.
.PP
The
.I fetchmail
program can gather mail from servers supporting any of the common
mail-retrieval protocols: POP2 (as specified in RFC 937), POP3 (RFC
1939), IMAP2bis (as implemented by the 4.4BSD imapd program), and
IMAP4 (as specified by RFC 1730).  It can use (but does not require)
the LAST facility removed from later POP3 versions.
.PP
While
.I fetchmail
is primarily intended to be used over on-demand TCP/IP links (such as
SLIP or PPP connections), it may also be useful as a message transfer
agent for sites which refuse for security reasons to permit
(sender-initiated) SMTP transactions with sendmail.
.PP
As each message is retrieved \fIfetchmail\fR normally delivers it via SMTP to
port 25 on the machine it is running on (localhost), just as though it
were being passed in over a normal TCP/IP link.  The mail will then be
delivered locally via your system's MDA (Mail Delivery Agent, usually
\fIsendmail\fR(8) but your system may use a different one such
as \fIsmail\fR, \fImmdf\fR, or \fIqmail\fR).  All the delivery-control
mechanisms (such as \fI.forward\fR files) normally available through
your system MDA will therefore work.
.PP
The behavior of
.I fetchmail
is controlled by command-line options and a run control file,
\fI~/.fetchmailrc\fR, the syntax of which we describe below.  Command-line
options override
.I ~/.fetchmailrc
declarations.
.PP
Each server name that you specify following the options on the
command line will be queried.  If you don't specify any servers
on the command line, each server in your 
.I ~/.fetchmailrc
file will be queried.
.PP
To facilitate the use of
.I fetchmail
In scripts, pipelines, etc., it returns an appropriate exit code upon 
termination -- see EXIT CODES below.

.SH OPTIONS
The following options modify the behavior of \fIfetchmail\fR.  It is
seldom necessary to specify any of these once you have a
working \fI.fetchmailrc\fR file set up.
.PP
Some special options are not covered here, but are documented insttead
in sections on AUTHENTICATION and DAEMON MODE which follows.
.SS General Options
.TP
.B \-V, --version
Displays the version information for your copy of 
.I fetchmail.
No mail fetch is performed.
Instead, for each server specified, all option information
that would be computed if
.I fetchmail.
were connecting to that server is displayed.  Any non-printables in
passwords or other string names are shown as backslashed C-like
escape sequences.  This option is useful for verifying that your
options are set the way you want them.
.TP
.B \-c, --check
Return a status code to indicate whether there is mail waiting,
without actually fetching or deleting mail (see EXIT CODES below).
This option doesn't play well with queries to multiple sites, and
is ignored in daemon mode.  It's also prone to false positives if
you leave read but undeleted mail in your server mailbox.
.TP
.B \-s, --silent
Silent mode.  Suppresses all progress/status messages that are normally
echoed to standard error during a fetch.  The --verbose option
overrides this.
.TP
.B \-v, --verbose
Verbose mode.  All control messages passed between 
.I fetchmail
and the mailserver are echoed to stderr.  Overrides --silent.
.TP
.B \-a, --all
Retrieve both old (seen) and new messages from the mailserver.  The
default is to fetch only messages the server has not marked seen.
Note that POP2 retrieval behaves as though --all is always on (see
RETRIEVAL FAILURE MODES below).
.TP
.B \-k, --keep
Keep retrieved messages on the remote mailserver.  Normally, messages 
are deleted from the folder on the mailserver after they have been retrieved.
Specifying the 
.B keep 
option causes retrieved messages to remain in your folder on the mailserver.
.TP
.B \-K, --kill
Delete retrieved messages from the remote mailserver.  This
option forces retrieved mail to be deleted.  It may be useful if
you have specified a default of \fBnokill\fR in your \fI.fetchmailrc\fR.
.TP
.B \-F, --flush
POP3/IMAP only.  Delete old (previously retrieved) messages from the mailserver
before retrieving new messages.
.SS Protocol and Query Options
.TP
.B \-p, \--protocol proto
Specify the protocol to used when communicating with the remote 
mailserver.  If no protocol is specified,
.I fetchmail
will try each of the supported protocols in turn, terminating after
any successful attempt.
.I proto 
may be one of the following:
.RS
.IP IMAP
IMAP2bis, a compatible subset of IMAP4.
.IP POP2
Post Office Protocol 2
.IP POP3
Post Office Protocol 3
.IP APOP
Use POP3 with MD5 authentication.
.IP RPOP
Use POP3 with RPOP authentication.
.IP KPOP
Use POP3 with Kerberos authentication on port 1109.
.RE
.TP
.B \-P, --port
The  option permits you to specify a TCP/IP port to connect on. 
This option will seldom be necessary as all the supported protocols have
well-established default port numbers.
.TP
.B \-r folder, --remote folder
Causes a specified non-default mail folder on the mailserver to be retrieved.
The syntax of the folder name is server dependent, as is the default
behavior when no folder is specified.  This option is not available
under POP3.
.SS Delivery Control Options
.TP
.B \-S host, --smtphost host
Specify a host to forward mail to (other than localhost).
.TP
.B \-m, \--mda
You can force mail to be passed to an MDA directly (rather than
forwarded to port 25) with the -mda or -m option.  If \fIfetchmail\fR
is running as root, it sets its userid to that of the target user
while delivering mail through an MDA.  Some possible MDAs are
"/usr/sbin/sendmail -oem", "/usr/lib/sendmail -oem",
"/usr/bin/formail", and "/usr/bin/deliver".  Local delivery addresses
will be inserted into the MDA command wherever you place a %s.  Do
\fInot\fR use an MDA like
"sendmail -oem -t" that dispatches on the contents of To/Cc/Bcc, it
will create mail loops and bring the just wrath of many postmasters
down upon your head.
.SS Resource Limit Control Options
.TP
.B \-l, --limit
Takes a maximum octet size argument.  Messages larger than this size
will not be fetched, not be marked seen, and will be left on the
server (in foreground sessions, the progress messages will note that
they are "oversized").  The --all option overrides this one.  This
option is intended for those needing to strictly control fetch time
in interactive mode.  It may not be used with daemon mode,
as users would never receive a notification that messages were waiting.
.TP
.B -b, --batchlimit
Specify the maximum number of messages that will be shipped to an SMTP
listener before the connection is deliberately torn down and rebuilt
(defaults to 0, meaning no limit).  While \fBsendmail\fR(8) normally
initiates delivery of a message immediately after receiving the
message terminator, some SMTP listeners are not so prompt.  MTAs like
\fIqmail\fR(8) and \fIsmail\fR(8) will wait till the delivery socket is
shut down to deliver.  This may produce annoying delays when
.IR fetchmail (8)
is processing very large batches.  Setting the batch limit to some
nonzero size will prevent these delays.
.TP
.B -B, --fetchlimit
Limit the number of messages accepted from a given server in a single
poll.  By default there is no limit. 
.SS Authentication Options
.TP
.B \-u name, --username name
Specifies the user identification to be used when logging in to the mailserver.
The appropriate user identification is both server and user-dependent.  
The default is your login name on the client machine that is running 
.I fetchmail.
See USER AUTHENTICATION below for a complete description.
.TP
.B \-I specification, --interface specification
Require that a specific interface device be up and have a specific local
IP address (or range) before polling.  Frequently
.I fetchmail
is used over a transient point-to-point TCP/IP link established directly
to a mailserver via SLIP or PPP.  That is a relatively secure channel.
But when other TCP/IP routes to the mailserver exist (e.g. when the link
is connected to an alternate ISP), your username and password may be
vulnerable to snooping (especially when daemon mode automatically polls
for mail, shipping a clear password over the net at predictable
intervals).  The --interface option may be used to prevent this.  When
the specified link is not up or is not connected to a matching IP
address, polling will be skipped.  The format is:
.sp
	interface/iii.iii.iii.iii/mmm.mmm.mmm.mmm
.sp
The field before the first slash is the interface name (i.e. sl0, ppp0
etc.).  The field before the second slash is the acceptable IP address.
The field after the second slash is a mask which specifies a range of
IP addresses to accept.  If no mask is present 255.255.255.255 is
assumed (i.e. an exact match).  This option is currently only supported
under Linux.
.TP
.B \-M interface, --monitor interface
Daemon mode can cause transient links which are automatically taken down
after a period of inactivity (e.g. PPP links) to remain up
indefinitely.  This option identifies a system TCP/IP interface to be
monitored for activity.  After each poll interval, if the link is up and
no other activity has occurred on the link then the poll will be
skipped.  This option is currently only supported under Linux.
.TP
.B \-A, --auth
This option permits you to specify an authentication type (see USER
AUTHENTICATION below for details).  The possible values are
\&`\fBpassword\fR' and `\fBkerberos\fR'.  This option is provided
primarily for developers; choosing KPOP protocol automatically selects
Kerberos authentication, and all other alternatives use ordinary
password authentication (though APOP uses a generated one-time
key as the password).
.SS Miscellaneous Options
.TP
.B \-f pathname, --fetchmailrc pathname
Specify a non-default name for the 
.I .fetchmailrc
run control file.
.TP
.B \-i pathname, --idfile pathname
Specify an alternate name for the .fetchids file used to save POP3
UIDs. 
.TP
.B \-n, --norewrite
Normally,
.I fetchmail
edits RFC-822 address headers (To, From, Cc, Bcc, and Reply-To) in
fetched mail so that any mail IDs local to the server are expanded to
full addresses (@ and the mailserver hostname are appended).  This enables 
replies on the client to get addressed correctly (otherwise your
mailer might think they should be addressed to local users on the
client machine!).  This option disables the rewrite.  (This option is
provided to pacify people who are paranoid about having an MTA edit
mail headers and want to know they can prevent it, but it is generally
not a good idea to actually turn off rewrite.)
.TP
.B -E, --envelope
This option changes the header 
.I fetchmail
assumes will carry a copy of the mail's envelope address.  Normally
this is `X-Envelope-To' but as this header is not standard, practice
varies. See the discussion of multidrop address handling below.

.SH USER AUTHENTICATION
Normal user authentication in 
.I fetchmail
is very much like the authentication mechanism of 
.I ftp(1).
The correct user-id and password depend upon the underlying security
system at the mailserver.  
.PP
If the mailserver is a Unix machine on which you have an ordinary user 
account, your regular login name and password are used with 
.I fetchmail.
If you use the same login name on both the server and the client machines,
you needn't worry about specifying a user-id with the 
.B \-u
option \-\- 
the default behavior is to use your login name on the client machine as the 
user-id on the server machine.  If you use a different login name
on the server machine, specify that login name with the
.B \-u
option.  e.g. if your login name is 'jsmith' on a machine named 'mailgrunt',
you would start 
.I fetchmail 
as follows:
.IP
fetchmail -u jsmith mailgrunt
.PP
The default behavior of 
.I fetchmail
is to prompt you for your mailserver password before the connection is
established.  This is the safest way to use 
.I fetchmail
and ensures that your password will not be compromised.  You may also specify
your password in your
.I ~/.fetchmailrc
file.  This is convenient when using 
.I fetchmail
in daemon mode or with scripts.
.PP
If you do not specify a password, and
.I fetchmail
cannot extract one from your
.I .fetchmailrc
file, it will look for a 
.I .netrc
file in your home directory before requesting one interactively; if an
entry matching the mailserver is found in that file, the password will
be used.  See the
.IR ftp (1)
man page for details of the syntax of the
.I .netrc
file.  (This feature may allow you to avoid duplicating password
information in more than one file.)
.PP
On mailservers that do not provide ordinary user accounts, your user-id and 
password are usually assigned by the server administrator when you apply for 
a mailbox on the server.  Contact your server administrator if you don't know 
the correct user-id and password for your mailbox account.
.PP
Early versions of POP3 (RFC1081, RFC1225) supported a crude form of
independent authentication using the
.I rhosts
file on the mailserver side.  Under this RPOP variant, a fixed
per-user ID equivalent to a password was sent in clear over a link to
a reserved port, with the command RPOP rather than PASS to alert the
server that it should do special checking.  RPOP is supported
by
.I fetchmail
(you can specify `protocol RPOP' to have the program send `RPOP'
rather than `PASS') but its use is strongly discouraged.  This
facility was vulnerable to spoofing and was withdrawn in RFC1460.
.PP
RFC1460 introduced APOP authentication.  In this variant of POP3,
you register an APOP password on your server host (the program
to do this with on the server is probably called \fIpopauth\fR(8)).  You
put the same password in your 
.I .fetchmailrc
file.  Each time 
.I fetchmail
logs in, it sends a cryptographically secure hash of your password and
the server greeting time to the server, which can verify it by
checking its authorization database. 
.PP
If your \fIfetchmail\fR was built with Kerberos support and you specify 
Kerberos authentication (either with --auth or the \fI.fetchmailrc\fR
option \fBauthenticate kerberos\fR) it will try to get a Kerberos
ticket from the mailserver at the start of each query. 

.SH DAEMON MODE
The 
.B --daemon
or
.B -d 
option runs 
.I fetchmail
in daemon mode.  You must specify a numeric argument which is a
polling interval in seconds.
.PP
In daemon mode, 
.I fetchmail
puts itself in background and runs forever, querying each specified
host and then sleeping for the given polling interval.
.PP
Simply invoking
.IP
fetchmail -d 900
.PP
will, therefore, poll all the hosts described in your 
.I ~/.fetchmailrc
file (except those explicitly excluded with the `skip' verb) once
every fifteen minutes.
.PP
Only one daemon process is permitted per user; in daemon mode,
.I fetchmail
makes a per-user lockfile to guarantee this.  The option
.B --quit
will kill a running daemon process.  Otherwise, calling fetchmail with
a daemon in the background sends a wakeup signal to the daemon,
forcing it to poll mailservers immediately.
.PP
The 
.B -t
or
.B --timeout
option allows you to set a server-nonresponse timeout in seconds.  If
a mailserver does not send a greeting message or respond to commands for
the given number of seconds, \fIfetchmail\fR will hang up on it.
Without such a timeout \fIfetchmail\fR might hang up indefinitely
trying to fetch mail from a down host.  This would be particularly
annoying for a \fIfetchmail\fR running in background.
.PP
The
.B -L
or
.B --logfile
option allows you to redirect status messages emitted while in daemon
mode into a specified logfile (follow the option with the logfile name).
The logfile is opened for append, so previous messages aren't deleted.
This is primarily useful for debugging configurations.
.PP
The
.B --syslog
option allows you to redirect status and error messages emitted while in
daemon mode to the
.IR syslog (3)
system daemon if available.
Messages are logged with an id of \fBfetchmail\fR, the facility \fBLOG_MAIL\fR,
and priorities \fBLOG_ERR\fR, \fBLOG_ALERT\fR or \fBLOG_INFO\fR.
This option is intended for logging status and error messages which
indicate the status of the daemon and the results while fetching mail
from the server(s).
Error messages for command line options and parsing the \fI.fetchmailrc\fR
file are still written to stderr, or the specified log file if the
.B -L
or
.B --logfile
option was used.
.PP
The \fI/etc/syslog.conf\fR file might contain the following to log
all messages from \fIfetchmail\fR to a single file:
.PP
.RS
!fetchmail
.br
*.*               /var/log/fetchmail
.RE
.PP
The 
.B \-N
or --nodetach option suppresses detachment of the daemon process
from its control terminal.  This is primarily useful for debugging.
.PP
Note that while running in daemon mode, transient errors (such as DNS
failures or sendmail delivery refusals) may force the fetchall
option on for the duration of the next polling cycle.
This is a robustness feature.  It means that if a message is fetched
(and thus marked seen by the mailserver) but not delivered locally
due to some transient error, it will be re-fetched during the next
poll cycle.

.SH RETRIEVAL FAILURE MODES
The protocols \fIfetchmail\fR uses to talk to mailservers are next to
bulletproof.  In normal operation forwarding to port 25, no message is
ever deleted (or even marked for deletion) on the host until the SMTP
listener on the client has acknowledged to \fIfetchmail\fR that the
message has been accepted for delivery.  When forwarding to an MDA,
however, there is more possibility of error (because there's no way
for fetchmail to get a reliable positive acknowledgement from the MDA).
.PP
The normal mode of \fIfetchmail\fR is to try to download only `new'
messages, leaving untouched (and undeleted) messages you have already
read directly on the server (or fetched with a previous \fIfetchmail
--keep\fR).  But you may find that messages you've already read on the
server are being fetched (and deleted) even when you don't specify
--all.  There are several reasons this can happen.
.PP
One could be that you're using POP2.  The POP2 protocol includes no
representation of `new' or `old' state in messages, so \fIfetchmail\fR
must treat all messages as new all the time.  But POP2 is obsolete, so
this is unlikely.
.PP
Under POP3, blame RFC1725.  That version of the POP3 protocol
specification removed the LAST command, and some POP servers follow it
(you can verify this by invoking \fIfetchmail -v\fR to the mailserver
and watching the response to LAST early in the query).  The
\fIfetchmail\fR code tries to compensate by using POP3's UID feature,
storing the identifiers of messages seen in each session until the
next session, in the \fI.fetchids\fR file.  But this doesn't track
messages seen with other clients, or read directly with a mailer on
the host but not deleted afterward.  A better solution would be to
switch to IMAP.
.PP
Another potential POP3 problem might be servers that insert messages
in the middle of mailboxes (some VMS implementations of mail are
rumored to do this).  The \fIfetchmail\fR code assumes that new
messages are appended to the end of the mailbox; when this is not true
it may treat some old messages as new and vice versa.  The only 
real fix for this problem is to  switch to IMAP.
.PP
The IMAP code uses the presence or absence of the server flag \eSeen
to decide whether or not a message is new.  Under Unix, it counts on
your IMAP server to notice the BSD-style Status flags set by mail user
agents and set the \eSeen flag from them when appropriate.  All Unix
IMAP servers we know of do this, though it's not specified by the IMAP
RFCs.  If you ever trip over a server that doesn't, the symptom will
be that messages you have already read on your host will look new to
the server.  In this (unlikely) case, only messages you fetched with
\fIfetchmail --keep\fR will be both undeleted and marked old.

.SH SPAM FILTERING
Newer versions of
.I sendmail
allow administrators to set up `spam filters' that block unsolicited email
from specified domains.  A MAIL FROM line that triggers this feature
will elicit an SMTP response with an error code of 571.  The
.I fetchmail
code recognizes this error and discards the message.  This is the
.I only
circumstance under which fetchmail ever discards mail.

.SH THE RUN CONTROL FILE
The preferred way to set up fetchmail (and the only way if you want to
avoid specifying passwords each time it runs) is to write a
\&\fI.fetchmailrc\fR file in your home directory.  When there is a
conflict between the command-line arguments and the arguments in this
file, the command-line arguments take precedence.
.PP
To protect the security of your passwords, your \fI~/.fetchmailrc\fR
may not have more than 600 (u=rw,g=,o=) permissions;
.I fetchmail
will complain and exit otherwise.
.PP
You may read the \fI.fetchmailrc\fR file as a list of commands to 
be executed when 
.I fetchmail
is called with no arguments.
.PP
Comments begin with a '#' and extend through the end of the line.
Otherwise the file consists of a series of server entries or global
option statements in a free-format, token-oriented syntax.
.PP
There are four kinds of tokens: grammar keywords, numbers
(i.e. decimal digit sequences), unquoted strings, and quoted strings.
A quoted string is bounded by double quotes and may contain
whitespace (and quoted digits are treated as a string).  An unquoted
string is any whitespace-delimited token that is neither numeric, string
quoted nor contains the special characters `,', `;', `:', or `='.
.PP
Any amount of whitespace separates tokens in server entries, but is
otherwise ignored. You may use standard C-style escapes (\en, \et,
\eb, octal, and hex) to embed non-printable characters or string
delimiters in strings.
.PP
Each server entry consists of one of the keywords `poll' or `skip',
followed by a server name, followed by server options, followed by any
number of user descriptions.
.PP
The `poll' verb tells fetchmail to query this host when it is run with
no arguments.  The `skip' verb tells
.I fetchmail 
not to poll this host unless it is explicitly named on the command
line.  (The `skip' verb allows you to experiment with test entries
safely, or easily disable entries for hosts that are temporarily down.)
.PP
Legal server options are:

    protocol (or proto)
    port
    authenticate (or auth)
    timeout
    envelope
    aka
    interface
    monitor
    dns
    no dns

Legal user options are

    username (or user)
    is
    to
    password (or pass)
    remotefolder (or remote)
    smtphost (or smtp)
    mda
    preconnect
    keep
    flush
    fetchall
    rewrite
    no keep
    no flush
    no fetchall
    no rewrite
    limit
    fetchlimit
    syslog
.PP
All options correspond to the obvious command-line arguments except
the following: `aka', `is', `to', `dns'/`no dns', `password',
`preconnect', `localdomains', and `stripcr'.
.PP
The `is' or `to' keywords associate the following local (client)
name(s) (or server-name to client-name mappings separated by =) with
the mailserver user name in the entry.  If an is/to list has `*' as
its last name, unrecognized names are simply passed through.
.PP
A single local name can be used to support redirecting your mail when
your username on the client machine is different from your name on the
mailserver.  When there is only a single local name, mail is forwarded
to that local username regardless of the message's Received, To, Cc,
and Bcc headers.  In this case 
.I fetchmail
never does DNS lookups.
.PP
When there is more than one local name (or name mapping) the
\fIfetchmail\fR code does look at the Received, To, Cc, and Bcc
headers of retrieved mail (this is `multidrop mode').  It looks for
addresses with hostname parts that match your `aka' or `localdomains'
options, and usually also for hostname parts which DNS tells it are
aliases of the mailserver.  See the discussion of `dns',
`localdomains', and `aka' for details on how matching addresses are
handled.  If \fIfetchmail\fR cannot match any mailserver usernames or
localdomain addresses, the default recipient is the calling user.
.PP
The `dns' option (normally on) controls the way addresses from
multidrop mailboxes are checked.  On, it enables logic to check each
host address that doesn't match an `aka' or `localdomains' declaration
by looking it up with DNS.  When a mailserver username is recognized
attached to a matching hostname part, its local mapping is added to
the list of local recipients.
.PP
The `aka' option is for use with multidrop mailboxes.  It allows you
to pre-declare a list of DNS aliases for a server.  This is an
optimization hack that allows you to trade space for speed.  When
.IR fetchmail ,
while processing a multidrop mailbox, grovels through message headers
looking for names of the mailserver, pre-declaring common ones can
save it from having to do DNS lookups.
.PP
The `localdomains' option allows you to declare a list of domains
which fetchmail should consider local.  When fetchmail is parsing
address lines in multidrop modes, and a trailing segment of a host
name matches a declared local doman, that address is passed through
to the listener or MDA unaltered (local-name mappings are \fInot\fR
applied).
.PP
The \fBpassword\fR option requires a string argument, which is the password
to be used with the entry's server.
.PP
The `preconnect' keyword allows you to specify a shell command to be
executed just before each time
.I fetchmail
establishes a mailserver connection.  This may be useful if you are 
attempting to set up secure POP connections with the aid of
.IR ssh (1).
.PP
The `stripcr' option controls whether carriage returns are stripped
out of retrieved mail before it is forwarded.  It is normally not
necessary to set this, because it defaults to `on' (CR stripping
enabled) when there is an MDA declared but `off' (CR stripping
disabled) when forwarding is via SMTP.
.PP
Legal protocol identifiers are

    auto (or AUTO)
    pop2 (or POP2)
    pop3 (or POP3)
    imap (or IMAP)
    apop (or APOP)
    kpop (or KPOP)

.PP
Legal authentication types are `password' or `kerberos'.  The former
specifies authentication by normal transmission of a password (the
password may be plaintext or subject to protocol-specific encryption
as in APOP); the second tells \fIfetchmail\fR to try to get a Kerberos
ticket at the start of each query instead, and send an arbitrary
string as the password.
.PP
Specifying `kpop' sets POP3 protocol over port 1109 with Kerberos
authentication.  These defaults may be overridden by later options.
.PP
You can use the noise keywords `and', `with',
`has', `wants', and `options' anywhere in an entry to make
it resemble English.  They're ignored, but but can make entries much
easier to read at a glance.  The punctuation characters ':', ';' and
',' are also ignored.
.PP
The words `here' and `there' have useful English-like
significance.  Normally `user eric is esr' would mean that 
mail for the remote user `eric' is to be delivered to `esr',
but you can make this clearer by saying `user eric there is esr here',
or reverse it by saying `user esr here is eric there'
.PP
For backward compatibility, the word `server' is a synonym for `poll'.
.PP
There is currently just one global option statement; `set logfile = '
followed by a string sets the same global specified by --logfile.  A
command-line --logfile option will override this.
.PP
Basic format is:

.nf
  poll SERVERNAME protocol PROTOCOL username NAME password PASSWORD 
.fi
.PP
Example:

.nf
  poll pop.provider.net protocol pop3 username jsmith password secret1
.fi
.PP
Or, using some abbreviations:

.nf
  poll pop.provider.net proto pop3 user jsmith password secret1
.fi
.PP
Multiple servers may be listed:

.nf
  poll pop.provider.net proto pop3 user jsmith pass secret1
  poll other.provider.net proto pop2 user John.Smith pass My^Hat
.fi

Here's a version of those two with more whitespace and some noise words: 

.nf
  poll pop.provider.net proto pop3
      user jsmith, with password secret1, is jsmith here;
  poll other.provider.net proto pop2:
      user John.Smith, with password My^Hat, is John.Smith here;
.fi

This version is much easier to read and doesn't cost significantly
more (parsing is done only once, at startup time).

.PP
If you need to include whitespace in a parameter string, enclose the
string in double quotes.  Thus:

.nf
  poll mail.provider.net with proto pop3:
        user jsmith there has password "u can't krak this"
                    is jws here and wants mda "/bin/mail"
.fi

You may have an initial server description headed by the keyword
`defaults' instead of `poll' followed by a name.  Such a record
is interpreted as defaults for all queries to use. It may be overwritten
by individual server descriptions.  So, you could write:

.nf
  defaults proto pop3
        user jsmith
  poll pop.provider.net
        pass secret1
  poll mail.provider.net
        user jjsmith there has password secret2
.fi

It's possible to specify more than one user per server (this is only
likely to be useful when running fetchmail in daemon mode as root).
The `user' keyword leads off a user description, and every user
description except optionally the first one must include it.  (If the
first description lacks the `user' keyword, the name of the
invoking user is used.) Here's a contrived example:

.nf
  poll pop.provider.net proto pop3 port 3111
        pass gumshoe
        user jsmith with pass secret1 is smith here
        user jones with pass secret2 is jjones here
.fi

This says that the user invoking \fIfetchmail\fR has the same username
on pop.provider.net, and password `gumshoe' there.
It also associates the local username `smith' with the pop.provider.net
username `jsmith' and the local username `jjones' with the pop.provider.net
username `jones'.
.PP
This example is contrived because, in practice, you are very unlikely
to be specifying multiple users per server unless running it as root
(thus the `pass gumshoe' would try to fetch root's mail on
pop-provider.net, which is probably not what you want).
In any case, we strongly recommend always having an explicit
\&`user' clause when specifying multiple users per mailserver.
.PP
Here's what a simple retrieval configuration for a multi-drop mailbox
looks like:

.nf
  poll pop.provider.net:
        user maildrop with pass secret1 to golux hurkle=happy snark here
.fi

This says that the mailbox of account `maildrop' on the server is a
multi-drop box, and that messages in it should be parsed for the
server user names `golux', `hurkle', and `snark'.  It further
specifies that `golux' and `snark' have the same name on the
client as on the server, but mail for server user `hurkle' should be
delivered to client user `happy'.
.PP
Here's an example of another kind of multidrop connection:

.nf
  poll pop.provider.net localdomains loonytoons.org:
        user maildrop with pass secret1 to esr * here
.fi

This also says that the mailbox of account `maildrop' on the server is
a multi-drop box.  It tells fetchmail that any address in the
loonytoons.org domain (including subdomain addresses like
`joe@daffy.loonytoons.org') should be passed through to the local SMTP
listener without modification.  Be careful of mail loops if you do this!

.SH THE USE AND ABUSE OF MULTIDROP MAILBOXES
Use the multiple-local-recipients feature with caution -- it can bite.

.SS Header vs. Envelope addresses 
The fundamental problem is that by having your mailserver toss several
peoples' mail in a box, you may have thrown away potentially vital
information about who each piece of mail was actually addressed to
(the `envelope address', as opposed to the addresses in the RFC822
To/Cc/Bcc headers).  This `envelope address' is the address you need
in order to reroute mail properly.
.PP
Sometimes 
.I fetchmail
can deduce the envelope address.  If the mailserver MTA is
.I sendmail
and the item of mail had just one recipient, the MTA will have written
a `for' clause that gives the envelope addressee into its Received
header. But this doesn't work reliably for other MTAs, nor if there is more
than one recipient.
.PP
Alternatively, some SMTP listeners and/or mail servers insert a header
in each message containing a copy of the envelope addresses.  This
header (when it exists) is often `X-Envelope-To'.  Fetchmail's
assumption about this can be changed with the -E or `envelope' option.
.PP
Sometimes, unfortunately, neither of these methods works.  When they
both fail, fetchmail must fall back on the contents of To/Cc/Bcc
headers to try to determine recipient addressees -- and these are not
reliable.  In particular, mailing-list software often ships mail with
the list broadcast address in the To header.
.PP
When
.I fetchmail
cannot deduce a recipient address that is local, and the intended
recipient address was anyone other than fetchmail's invoking user,
mail will get lost.  This is what makes the multidrop feature risky.

.SS Good Ways To Use Multidrop Mailboxes
Multiple local names can be used to administer a mailing list from the
client side of a \fIfetchmail\fR collection.  Suppose your name is
\&`esr', and you want to both pick up your own mail and maintain a mailing
list called (say) "fetchmail-friends", and you want to keep the alias
list on your client machine.
.PP
On your server, you can alias \&`fetchmail-friends' to `esr'; then, in
your \fI.fetchmailrc\fR, declare \&`to esr fetchmail-friends here'.
Then, when mail including `fetchmail-friends' as a local address
gets fetched, the list name will be appended to the list of
recipients your SMTP listener sees.  Therefore it will undergo alias
expansion locally.  Be sure to include `esr' in the local alias
expansion of fetchmail-friends, or you'll never see mail sent only to
the list.  Also be sure that your listener has the "me-too" option set
(sendmail's -oXm command-line option or OXm declaration) so your name
isn't removed from alias expansions in messages you send.
.PP
This trick is not without its problems, however.  You'll begin to see
this when a message comes in that is addressed only to a mailing list
you do \fInot\fR have declared as a local name.  Each such message
will feature an `X-Fetchmail-Warning' header which is generated
because fetchmail cannot find a valid local name in the recipient
addresses.  Such messages default (as was described above) to being
sent to the local user running
.IR fetchmail ,
but the program has no way to know that that's actually the right thing.

.SS Bad Ways To Abuse Multidrop Mailboxes
Multidrop mailboxes and 
.I fetchmail
serving multiple users in daemon mode do not mix.  The problem, again, is
mail from mailing lists, which typically does not have an individual
recipient address on it.   Unless 
.I fetchmail
can deduce an envelope address, such mail will only go to the account
running fetchmail (probably root).

.SS Speeding Up Multidrop Checking
Normally, when multiple user are declared 
.I fetchmail
extracts recipient addresses as described above and checks each host
part with DNS to see if it's an alias of the mailserver.  If so, the
name mappings described in the to ... here declaration are done and
the mail locally delivered.
.PP
This is the safest but also slowest method.  To speed it up,
pre-declare mailserver aliases with `aka'; these are checked before
DNS lookups are done.  If you're certain your aka list contains
.B all
DNS aliases of the mailserver (and all MX names pointing at it) 
you can declare `no dns' to suppress DNS lookups entirely and
\fIonly\fR match against the aka list.

.SH EXIT CODES
To facilitate the use of 
.I fetchmail
in shell scripts, an exit code is returned to give an indication
of what occurred during a given connection.
.PP
The exit codes returned by 
.I fetchmail
are as follows:
.IP 0
One or more messages were successfully retrieved.
.IP 1
There was no mail awaiting retrieval.
.IP 2
An error was encountered when attempting to open a socket for the POP 
connection.  If you don't know what a socket is, don't worry about it --
just treat this as an 'unrecoverable error'.
.IP 3
The user authentication step failed.  This usually means that a bad 
user-id, password, or APOP id was specified.
.IP 4
Some sort of fatal protocol error was detected.
.IP 5
There was a syntax error in the arguments to 
.I fetchmail.
.IP 6
The run control file had bad permissions.
.IP 7
There was an error condition reported by the server (POP3 only).
.IP 8
Exclusion error.  This means 
.I fetchmail
either found another copy of itself already running, or failed in such
a way that it isn't sure whether another copy is running.
.IP 9
The 
.I fetchmail.
run failed while trying to do an SMTP port open or transaction.
.IP 10
Internal error.  You should see a message on standard error with
details.
.PP
When
.I fetchmail
queries more than one host, the returned status is that of the last
host queried.

.SH AUTHOR
Eric S. Raymond <esr@snark.thyrsus.com>.  

.SH BACKWARD COMPATIBILITY
This program is descended from and replaces 
.IR popclient , 
by Carl Harris <ceharris@mal.com>; the internals are quite different, 
but some of its interface design is directly traceable to that
ancestral program.  Some effort has been made to preserve compatibility.
.PP
If called through a link named `popclient', \fIfetchmail\fR will look
in ~/.poprc for its run control file.  As long as the file does not
use the removed `localfolder' option or `limit' (which now takes a
maximum byte size rather than a line count), this will often work.
(The new run control file syntax also has to be a little stricter
about the order of options than the old, in order to support multiple
user desriptions per server; thus you may have to rearrange things a
bit.)

.SH FILES
.TP 5
~/.fetchmailrc
default run control file
.TP 5
~/.fetchids
default location of file associating hosts with last message IDs seen
(used only with newer RFC1725-compliant POP3 servers supporting the
UIDL command).
.TP 5
~/.netrc your FTP run control file, which (if present) will be
searched for passwords as a last resort before prompting for one
interactively.
.TP 5
~/.fetchmail
lock file to help prevent concurrent runs (non-root mode).
.TP 5
/var/run/fetchmail.pid
lock file to help prevent concurrent runs (root mode).

.SH ENVIRONMENT
For correct initialization, 
.I fetchmail
requires either that both the USER and HOME environment variables are
correctly set, or that \fBgetpwuid\fR(3) be able to retrieve a password
entry from your user ID.

.SH BUGS AND KNOWN PROBLEMS
Use of any of the supported protocols other than APOP or KPOP requires
that the program send unencrypted passwords over the TCP/IP connection
to the mailserver.  This creates a risk that name/password pairs
might be snaffled with a packet sniffer or more sophisticated
monitoring software.  Under Linux, the --interface option can be used
to restrict polling to availability of a specific interface device with
a specific local IP address, but snooping is still possible if (a)
either host has a network device that can be opened in promiscuous mode,
or (b) the intervening network link can be tapped.
.PP
Send comments, bug reports, gripes, and the like to Eric S. Raymond
<esr@thyrsus.com>.

.SH SEE ALSO
elm(1), mail(1), sendmail(8), popd(8), imapd(8)
.SH APPLICABLE STANDARDS
.TP 5
SMTP/ESMTP:
RFC 821, RFC 1869, RFC 1652, RFC 1870 
.TP 5
mail:
RFC 822
.TP 5
POP2:
RFC 937
.TP 5
POP3:
RFC 1081, RFC 1225, RFC 1460, RFC 1725, RFC 1939
.TP 5
APOP:
RFC 1460, RFC 1725, RFC 1939
.TP 5
RPOP:
RFC 1081, RFC 1225
.TP 5
IMAP2/IMAP2BIS:
RFC 1176, RFC 1732
.TP 5
IMAP4:
RFC 1730, RFC 1731, RFC 1732, RFC 2060