------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              T R E E P R S                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                Generated by xtreeprs revision 1.28 using                 --
--                         sinfo.ads revision 1.296                          --
--                        treeprs.adt revision 1.16                          --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------


--  This package contains the declaration of the string used by the Tree_Print
--  package. It must be updated whenever the arrangements of the field names
--  in package Sinfo is changed. The utility program XTREEPRS is used to
--  do this update correctly using the template treeprs.adt as input.

with Sinfo; use Sinfo;

package Treeprs is

   --------------------------------
   -- String Data for Node Print --
   --------------------------------

   --  String data for print out. The Pchars array is a long string with the
   --  the entry for each node type consisting of a single blank, followed by
   --  a series of entries, one for each Op or Flag field used for the node.
   --  Each entry has a single character which identifies the field, followed
   --  by the synonym name. The starting location for a given node type is
   --  found from the corresponding entry in the Pchars_Pos_Array.

   --  The following characters identify the field. These are characters
   --  which  could never occur in a field name, so they also mark the
   --  end of the previous name.

   subtype Fchar is Character range '#' .. '9';

   F_Field1     : constant Fchar := '#'; -- Character'Val (16#23#)
   F_Field2     : constant Fchar := '$'; -- Character'Val (16#24#)
   F_Field3     : constant Fchar := '%'; -- Character'Val (16#25#)
   F_Field4     : constant Fchar := '&'; -- Character'Val (16#26#)
   F_Field5     : constant Fchar := '''; -- Character'Val (16#27#)
   F_Flag1      : constant Fchar := '('; -- Character'Val (16#28#)
   F_Flag2      : constant Fchar := ')'; -- Character'Val (16#29#)
   F_Flag3      : constant Fchar := '*'; -- Character'Val (16#2A#)
   F_Flag4      : constant Fchar := '+'; -- Character'Val (16#2B#)
   F_Flag5      : constant Fchar := ','; -- Character'Val (16#2C#)
   F_Flag6      : constant Fchar := '-'; -- Character'Val (16#2D#)
   F_Flag7      : constant Fchar := '.'; -- Character'Val (16#2E#)
   F_Flag8      : constant Fchar := '/'; -- Character'Val (16#2F#)
   F_Flag9      : constant Fchar := '0'; -- Character'Val (16#30#)
   F_Flag10     : constant Fchar := '1'; -- Character'Val (16#31#)
   F_Flag11     : constant Fchar := '2'; -- Character'Val (16#32#)
   F_Flag12     : constant Fchar := '3'; -- Character'Val (16#33#)
   F_Flag13     : constant Fchar := '4'; -- Character'Val (16#34#)
   F_Flag14     : constant Fchar := '5'; -- Character'Val (16#35#)
   F_Flag15     : constant Fchar := '6'; -- Character'Val (16#36#)
   F_Flag16     : constant Fchar := '7'; -- Character'Val (16#37#)
   F_Flag17     : constant Fchar := '8'; -- Character'Val (16#38#)
   F_Flag18     : constant Fchar := '9'; -- Character'Val (16#39#)

   --  Note this table does not include entity field and flags whose access
   --  functions are in Einfo (these are handled by the Print_Entity_Info
   --  procedure in Treepr, which uses the routines in Einfo to get the
   --  proper symbolic information). In addition, the following fields are
   --  handled by Treepr, and do not appear in the Pchars array:

   --    Analyzed
   --    Cannot_Be_Constant
   --    Chars
   --    Comes_From_Source
   --    Error_Posted
   --    Etype
   --    Is_Controlling_Actual
   --    Is_Overloaded
   --    Is_Static_Expression
   --    Left_Opnd
   --    Must_Check_Expr
   --    Must_Not_Freeze
   --    No_Overflow_Expr
   --    Paren_Count
   --    Raises_Constraint_Error
   --    Right_Opnd

   Pchars : constant String :=
      --  Unused_At_Start
      "" &
      --  At_Clause
      "#Identifier%Expression" &
      --  Component_Clause
      "#Component_Name$Position%First_Bit&Last_Bit" &
      --  Enumeration_Representation_Clause
      "#Identifier&Array_Aggregate" &
      --  Mod_Clause
      "%Expression&Pragmas_Before" &
      --  Record_Representation_Clause
      "#Identifier$Mod_Clause%Component_Clauses" &
      --  Attribute_Definition_Clause
      "$Name%Expression" &
      --  Empty
      "" &
      --  Error
      "" &
      --  Pragma
      "$Pragma_Argument_Associations%Debug_Statement" &
      --  Pragma_Argument_Association
      "%Expression" &
      --  Defining_Character_Literal
      "$Next_Entity%Scope&Homonym" &
      --  Defining_Identifier
      "$Next_Entity%Scope&Homonym" &
      --  Defining_Operator_Symbol
      "$Next_Entity%Scope&Homonym" &
      --  Interpretation
      "$Next_Interp&Entity" &
      --  Expanded_Name
      "%Prefix$Selector_Name&Entity4Redundant_Use2Has_Private_View" &
      --  Identifier
      "&Entity$Original_Discriminant4Redundant_Use2Has_Private_View" &
      --  Character_Literal
      "$Char_Literal_Value&Entity2Has_Private_View" &
      --  Operator_Symbol
      "%Strval&Entity2Has_Private_View" &
      --  Op_Add
      "" &
      --  Op_And
      "+Do_Length_Check" &
      --  Op_Concat
      "" &
      --  Op_Divide
      "5Treat_Fixed_As_Integer4Do_Division_Check9Rounded_Result" &
      --  Op_Eq
      "" &
      --  Op_Expon
      "" &
      --  Op_Ge
      "" &
      --  Op_Gt
      "" &
      --  Op_Le
      "" &
      --  Op_Lt
      "" &
      --  Op_Mod
      "5Treat_Fixed_As_Integer4Do_Division_Check" &
      --  Op_Multiply
      "5Treat_Fixed_As_Integer9Rounded_Result" &
      --  Op_Ne
      "" &
      --  Op_Or
      "+Do_Length_Check" &
      --  Op_Rem
      "5Treat_Fixed_As_Integer4Do_Division_Check" &
      --  Op_Subtract
      "" &
      --  Op_Xor
      "+Do_Length_Check" &
      --  Op_Rotate_Left
      "" &
      --  Op_Rotate_Right
      "" &
      --  Op_Shift_Left
      "" &
      --  Op_Shift_Right
      "" &
      --  Op_Shift_Right_Arithmetic
      "" &
      --  Op_Abs
      "" &
      --  Op_Minus
      "" &
      --  Op_Not
      "" &
      --  Op_Plus
      "" &
      --  Attribute_Reference
      "%Prefix$Attribute_Name#Expressions&Entity2Do_Access_Check8Do_Overflow" &
         "_Check" &
      --  And_Then
      "#Actions" &
      --  Concat_Multiple
      "#Expressions" &
      --  Conditional_Expression
      "#Expressions$Then_Actions%Else_Actions" &
      --  Explicit_Dereference
      "%Prefix2Do_Access_Check" &
      --  Function_Call
      "$Name%Parameter_Associations&First_Named_Actual#Controlling_Argument4" &
         "Do_Tag_Check" &
      --  In
      "" &
      --  Indexed_Component
      "%Prefix#Expressions2Do_Access_Check" &
      --  Integer_Literal
      "%Intval4Print_In_Hex" &
      --  Not_In
      "" &
      --  Null
      "" &
      --  Or_Else
      "#Actions" &
      --  Procedure_Call_Statement
      "$Name%Parameter_Associations&First_Named_Actual#Controlling_Argument4" &
         "Do_Tag_Check" &
      --  Qualified_Expression
      "&Subtype_Mark%Expression" &
      --  Raise_Constraint_Error
      "#Condition" &
      --  Range
      "#Low_Bound$High_Bound" &
      --  Real_Literal
      "%Realval&Corresponding_Integer_Value" &
      --  Selected_Component
      "%Prefix$Selector_Name2Do_Access_Check4Do_Discriminant_Check" &
      --  Type_Conversion
      "&Subtype_Mark%Expression8Do_Overflow_Check4Do_Tag_Check+Do_Length_Che" &
         "ck2Float_Truncate9Rounded_Result5Conversion_OK" &
      --  Unchecked_Type_Conversion
      "&Subtype_Mark%Expression" &
      --  Allocator
      "%Expression#Storage_Pool&Procedure_To_Call8Do_Storage_Check$First_Ity" &
         "pe5Has_Dynamic_Itype" &
      --  Aggregate
      "#Expressions&Component_Associations8Null_Record_Present$First_Itype%A" &
         "ggregate_Bounds5Has_Dynamic_Itype2Expansion_Delayed" &
      --  Expression_Actions
      "#Actions%Expression$First_Itype5Has_Dynamic_Itype" &
      --  Extension_Aggregate
      "%Ancestor_Part#Expressions&Component_Associations8Null_Record_Present" &
         "$First_Itype2Expansion_Delayed5Has_Dynamic_Itype" &
      --  Reference
      "%Prefix$First_Itype5Has_Dynamic_Itype" &
      --  Slice
      "%Prefix&Discrete_Range2Do_Access_Check$First_Itype5Has_Dynamic_Itype" &
      --  String_Literal
      "%Strval$First_Itype5Has_Dynamic_Itype" &
      --  Subtype_Indication
      "&Subtype_Mark%Constraint$First_Itype5Has_Dynamic_Itype/Must_Not_Freez" &
         "e" &
      --  Component_Declaration
      "#Defining_Identifier6Aliased_Present'Subtype_Indication%Expression,Mo" &
         "re_Ids-Prev_Ids$First_Itype5Has_Dynamic_Itype" &
      --  Entry_Declaration
      "#Defining_Identifier&Discrete_Subtype_Definition%Parameter_Specificat" &
         "ions$First_Itype5Has_Dynamic_Itype" &
      --  Entry_Index_Specification
      "#Defining_Identifier&Discrete_Subtype_Definition$First_Itype5Has_Dyna" &
         "mic_Itype" &
      --  Formal_Object_Declaration
      "#Defining_Identifier6In_Present8Out_Present&Subtype_Mark%Expression,M" &
         "ore_Ids-Prev_Ids$First_Itype5Has_Dynamic_Itype" &
      --  Formal_Type_Declaration
      "#Defining_Identifier%Formal_Type_Definition&Discriminant_Specificatio" &
         "ns$First_Itype5Has_Dynamic_Itype4Unknown_Discriminants_Present" &
      --  Freeze_Entity
      "&Entity%TSS_Elist#Actions$First_Itype'First_Subtype_Link5Has_Dynamic_" &
         "Itype" &
      --  Full_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications%Type_Definition$Firs" &
         "t_Itype5Has_Dynamic_Itype" &
      --  Incomplete_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications4Unknown_Discriminant" &
         "s_Present$First_Itype5Has_Dynamic_Itype" &
      --  Implicit_Types
      "$First_Itype5Has_Dynamic_Itype" &
      --  Loop_Parameter_Specification
      "#Defining_Identifier6Reverse_Present&Discrete_Subtype_Definition$Firs" &
         "t_Itype5Has_Dynamic_Itype" &
      --  Object_Declaration
      "#Defining_Identifier6Aliased_Present8Constant_Present&Object_Definiti" &
         "on%Expression,More_Ids-Prev_Ids$First_Itype'Object_Definition_Ityp" &
         "es5Has_Dynamic_Itype.No_Default_Init" &
      --  Private_Extension_Declaration
      "#Defining_Identifier$First_Itype5Has_Dynamic_Itype&Discriminant_Speci" &
         "fications4Unknown_Discriminants_Present+Abstract_Present'Subtype_I" &
         "ndication" &
      --  Private_Type_Declaration
      "#Defining_Identifier$First_Itype5Has_Dynamic_Itype&Discriminant_Speci" &
         "fications4Unknown_Discriminants_Present+Abstract_Present6Tagged_Pr" &
         "esent8Limited_Present" &
      --  Subtype_Declaration
      "#Defining_Identifier'Subtype_Indication$First_Itype&Generic_Parent_Ty" &
         "pe5Has_Dynamic_Itype" &
      --  Protected_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications$First_Itype5Has_Dyna" &
         "mic_Itype%Protected_Definition'Corresponding_Body" &
      --  Accept_Statement
      "#Entry_Direct_Name'Entry_Index%Parameter_Specifications&Handled_State" &
         "ment_Sequence$First_Itype5Has_Dynamic_Itype" &
      --  Function_Specification
      "#Defining_Unit_Name%Parameter_Specifications&Subtype_Mark'Generic_Par" &
         "ent$First_Itype5Has_Dynamic_Itype" &
      --  Procedure_Specification
      "#Defining_Unit_Name%Parameter_Specifications'Generic_Parent$First_Ity" &
         "pe5Has_Dynamic_Itype" &
      --  Access_Function_Definition
      "6Protected_Present$First_Itype5Has_Dynamic_Itype%Parameter_Specificat" &
         "ions&Subtype_Mark" &
      --  Access_Procedure_Definition
      "6Protected_Present$First_Itype5Has_Dynamic_Itype%Parameter_Specificat" &
         "ions" &
      --  Task_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications$First_Itype5Has_Dyna" &
         "mic_Itype%Task_Definition'Corresponding_Body" &
      --  Package_Body_Stub
      "#Defining_Identifier&Library_Unit'Corresponding_Body" &
      --  Protected_Body_Stub
      "#Defining_Identifier&Library_Unit'Corresponding_Body" &
      --  Subprogram_Body_Stub
      "#Specification&Library_Unit'Corresponding_Body" &
      --  Task_Body_Stub
      "#Defining_Identifier&Library_Unit'Corresponding_Body" &
      --  Function_Instantiation
      "#Defining_Unit_Name$Name%Generic_Associations&Parent_Spec" &
      --  Package_Instantiation
      "#Defining_Unit_Name$Name&Parent_Spec%Generic_Associations" &
      --  Procedure_Instantiation
      "#Defining_Unit_Name$Name&Parent_Spec%Generic_Associations" &
      --  Package_Body
      "#Defining_Unit_Name%Declarations&Handled_Statement_Sequence'Correspon" &
         "ding_Spec" &
      --  Subprogram_Body
      "#Specification%Declarations&Handled_Statement_Sequence6Bad_Is_Detecte" &
         "d'Corresponding_Spec+Acts_As_Spec8Do_Storage_Check,Is_Task_Master$" &
         "Activation_Chain_Entity-Has_Priority_Pragma.Is_Protected_Subprogra" &
         "m_Body" &
      --  Implicit_Label_Declaration
      "#Defining_Identifier$Label" &
      --  Package_Declaration
      "#Specification'Corresponding_Body&Parent_Spec$Activation_Chain_Entity" &
      --  Single_Task_Declaration
      "#Defining_Identifier%Task_Definition" &
      --  Subprogram_Declaration
      "#Specification'Corresponding_Body&Parent_Spec" &
      --  Task_Body
      "#Defining_Identifier%Declarations&Handled_Statement_Sequence,Is_Task_" &
         "Master$Activation_Chain_Entity'Corresponding_Spec" &
      --  Use_Package_Clause
      "$Names%Next_Use_Clause" &
      --  Generic_Package_Declaration
      "#Specification'Corresponding_Body%Generic_Formal_Declarations&Parent_" &
         "Spec$Activation_Chain_Entity" &
      --  Generic_Subprogram_Declaration
      "#Specification'Corresponding_Body%Generic_Formal_Declarations&Parent_" &
         "Spec" &
      --  Constrained_Array_Definition
      "$Discrete_Subtype_Definitions6Aliased_Present'Subtype_Indication" &
      --  Unconstrained_Array_Definition
      "$Subtype_Marks6Aliased_Present'Subtype_Indication" &
      --  Exception_Renaming_Declaration
      "#Defining_Identifier$Name" &
      --  Object_Renaming_Declaration
      "#Defining_Identifier&Subtype_Mark$Name" &
      --  Package_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Subprogram_Renaming_Declaration
      "#Specification$Name&Parent_Spec'Corresponding_Spec" &
      --  Generic_Function_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Generic_Package_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Generic_Procedure_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Abort_Statement
      "$Names" &
      --  Assignment_Statement
      "$Name%Expression4Do_Tag_Check+Do_Length_Check,Forwards_OK-Backwards_O" &
         "K.No_Ctrl_Actions" &
      --  Asynchronous_Select
      "#Triggering_Alternative$Abortable_Part" &
      --  Block_Statement
      "#Identifier%Declarations&Handled_Statement_Sequence,Is_Task_Master$Ac" &
         "tivation_Chain_Entity6Has_Created_Identifier-Is_Task_Allocation_Bl" &
         "ock.Is_Asynchronous_Call_Block" &
      --  Case_Statement
      "%Expression&Alternatives" &
      --  Code_Statement
      "%Expression" &
      --  Conditional_Entry_Call
      "#Entry_Call_Alternative&Else_Statements" &
      --  Delay_Relative_Statement
      "%Expression" &
      --  Delay_Until_Statement
      "%Expression" &
      --  Entry_Call_Statement
      "$Name%Parameter_Associations&First_Named_Actual" &
      --  Exit_Statement
      "$Name#Condition" &
      --  Free_Statement
      "%Expression#Storage_Pool&Procedure_To_Call" &
      --  Goto_Statement
      "$Name" &
      --  If_Statement
      "#Condition$Then_Statements%Elsif_Parts&Else_Statements" &
      --  Loop_Statement
      "#Identifier$Iteration_Scheme%Statements6Has_Created_Identifier" &
      --  Null_Statement
      "" &
      --  Raise_Statement
      "$Name" &
      --  Requeue_Statement
      "$Name6Abort_Present" &
      --  Return_Statement
      "%Expression#Storage_Pool&Procedure_To_Call4Do_Tag_Check$Return_Type,B" &
         "y_Ref" &
      --  Selective_Accept
      "#Select_Alternatives&Else_Statements" &
      --  Timed_Entry_Call
      "#Entry_Call_Alternative&Delay_Alternative" &
      --  Abortable_Part
      "%Statements" &
      --  Abstract_Subprogram_Declaration
      "#Specification" &
      --  Accept_Alternative
      "$Accept_Statement#Condition%Statements&Pragmas_Before" &
      --  Access_Definition
      "&Subtype_Mark" &
      --  Access_To_Object_Definition
      "6All_Present'Subtype_Indication8Constant_Present" &
      --  Case_Statement_Alternative
      "&Discrete_Choices%Statements" &
      --  Compilation_Unit
      "&Library_Unit#Context_Items6Private_Present$Unit'Pragmas_After8Has_No" &
         "_Elab_Code4Body_Required+Acts_As_Spec.Elaborate_Body_Present%First" &
         "_Inlined_Subprogram" &
      --  Component_Association
      "#Choices%Expression" &
      --  Component_List
      "%Component_Items&Variant_Part4Null_Present" &
      --  Derived_Type_Definition
      "+Abstract_Present'Subtype_Indication%Record_Extension_Part" &
      --  Decimal_Fixed_Point_Definition
      "%Delta_Expression$Digits_Expression&Real_Range_Specification" &
      --  Defining_Program_Unit_Name
      "$Name#Defining_Identifier" &
      --  Delay_Alternative
      "$Delay_Statement#Condition%Statements&Pragmas_Before" &
      --  Delta_Constraint
      "%Delta_Expression&Range_Constraint" &
      --  Designator
      "$Name#Identifier" &
      --  Digits_Constraint
      "$Digits_Expression&Range_Constraint" &
      --  Discriminant_Association
      "#Selector_Names%Expression" &
      --  Discriminant_Specification
      "#Defining_Identifier$Discriminant_Type%Expression,More_Ids-Prev_Ids" &
      --  Elsif_Part
      "#Condition$Then_Statements%Condition_Actions" &
      --  Enumeration_Type_Definition
      "#Literals" &
      --  Entry_Body
      "#Defining_Identifier'Entry_Body_Formal_Part%Declarations&Handled_Stat" &
         "ement_Sequence$Activation_Chain_Entity" &
      --  Entry_Body_Formal_Part
      "&Entry_Index_Specification%Parameter_Specifications#Condition" &
      --  Entry_Call_Alternative
      "#Entry_Call_Statement%Statements&Pragmas_Before" &
      --  Exception_Declaration
      "#Defining_Identifier%Expression,More_Ids-Prev_Ids" &
      --  Exception_Handler
      "$Choice_Parameter&Exception_Choices%Statements" &
      --  Floating_Point_Definition
      "$Digits_Expression&Real_Range_Specification" &
      --  Formal_Decimal_Fixed_Point_Definition
      "" &
      --  Formal_Derived_Type_Definition
      "&Subtype_Mark6Private_Present+Abstract_Present" &
      --  Formal_Discrete_Type_Definition
      "" &
      --  Formal_Floating_Point_Definition
      "" &
      --  Formal_Modular_Type_Definition
      "" &
      --  Formal_Ordinary_Fixed_Point_Definition
      "" &
      --  Formal_Package_Declaration
      "#Defining_Identifier$Name%Generic_Associations6Box_Present" &
      --  Formal_Private_Type_Definition
      "+Abstract_Present6Tagged_Present8Limited_Present" &
      --  Formal_Signed_Integer_Type_Definition
      "" &
      --  Formal_Subprogram_Declaration
      "#Specification$Default_Name6Box_Present" &
      --  Generic_Association
      "$Selector_Name#Explicit_Generic_Actual_Parameter" &
      --  Handled_Sequence_Of_Statements
      "%Statements&Exception_Handlers#Identifier'Cleanup_Call$First_Real_Sta" &
         "tement" &
      --  Index_Or_Discriminant_Constraint
      "#Constraints" &
      --  Iteration_Scheme
      "#Condition%Condition_Actions&Loop_Parameter_Specification" &
      --  Label
      "#Identifier" &
      --  Modular_Type_Definition
      "%Expression" &
      --  Number_Declaration
      "#Defining_Identifier%Expression,More_Ids-Prev_Ids" &
      --  Ordinary_Fixed_Point_Definition
      "%Delta_Expression&Real_Range_Specification" &
      --  Others_Choice
      "#Others_Discrete_Choices" &
      --  Package_Specification
      "#Defining_Unit_Name$Visible_Declarations&Private_Declarations'Generic" &
         "_Parent" &
      --  Parameter_Association
      "$Selector_Name%Explicit_Actual_Parameter&Next_Named_Actual" &
      --  Parameter_Specification
      "#Defining_Identifier6In_Present8Out_Present$Parameter_Type%Expression" &
         "4Do_Accessibility_Check,More_Ids-Prev_Ids'Default_Expression" &
      --  Protected_Body
      "#Defining_Identifier%Declarations'Corresponding_Spec" &
      --  Protected_Definition
      "$Visible_Declarations&Private_Declarations-Has_Priority_Pragma" &
      --  Range_Constraint
      "&Range_Expression" &
      --  Real_Range_Specification
      "#Low_Bound$High_Bound" &
      --  Record_Definition
      "+Abstract_Present6Tagged_Present8Limited_Present#Component_List4Null_" &
         "Present" &
      --  Signed_Integer_Type_Definition
      "#Low_Bound$High_Bound" &
      --  Single_Protected_Declaration
      "#Defining_Identifier%Protected_Definition" &
      --  Subunit
      "$Name#Proper_Body%Corresponding_Stub" &
      --  Task_Definition
      "$Visible_Declarations&Private_Declarations-Has_Priority_Pragma,Has_St" &
         "orage_Size_Pragma.Has_Task_Info_Pragma" &
      --  Terminate_Alternative
      "#Condition&Pragmas_Before'Pragmas_After" &
      --  Triggering_Alternative
      "#Triggering_Statement%Statements&Pragmas_Before" &
      --  Use_Type_Clause
      "$Subtype_Marks%Next_Use_Clause" &
      --  Variant
      "&Discrete_Choices#Component_List$Enclosing_Variant" &
      --  Variant_Part
      "$Name#Variants" &
      --  With_Clause
      "$Name&Library_Unit'Corresponding_Spec,First_Name-Last_Name4Context_In" &
         "stalled+Elaborate_Present6Elaborate_All_Present8Implicit_With" &
      --  Unused_At_End
      "";

   type Pchar_Pos_Array is array (Node_Kind) of Positive;
   Pchar_Pos : constant Pchar_Pos_Array := Pchar_Pos_Array'(
      N_Unused_At_Start                        => 1,
      N_At_Clause                              => 1,
      N_Component_Clause                       => 23,
      N_Enumeration_Representation_Clause      => 66,
      N_Mod_Clause                             => 93,
      N_Record_Representation_Clause           => 119,
      N_Attribute_Definition_Clause            => 159,
      N_Empty                                  => 175,
      N_Error                                  => 175,
      N_Pragma                                 => 175,
      N_Pragma_Argument_Association            => 220,
      N_Defining_Character_Literal             => 231,
      N_Defining_Identifier                    => 257,
      N_Defining_Operator_Symbol               => 283,
      N_Interpretation                         => 309,
      N_Expanded_Name                          => 328,
      N_Identifier                             => 387,
      N_Character_Literal                      => 447,
      N_Operator_Symbol                        => 490,
      N_Op_Add                                 => 521,
      N_Op_And                                 => 521,
      N_Op_Concat                              => 537,
      N_Op_Divide                              => 537,
      N_Op_Eq                                  => 593,
      N_Op_Expon                               => 593,
      N_Op_Ge                                  => 593,
      N_Op_Gt                                  => 593,
      N_Op_Le                                  => 593,
      N_Op_Lt                                  => 593,
      N_Op_Mod                                 => 593,
      N_Op_Multiply                            => 634,
      N_Op_Ne                                  => 672,
      N_Op_Or                                  => 672,
      N_Op_Rem                                 => 688,
      N_Op_Subtract                            => 729,
      N_Op_Xor                                 => 729,
      N_Op_Rotate_Left                         => 745,
      N_Op_Rotate_Right                        => 745,
      N_Op_Shift_Left                          => 745,
      N_Op_Shift_Right                         => 745,
      N_Op_Shift_Right_Arithmetic              => 745,
      N_Op_Abs                                 => 745,
      N_Op_Minus                               => 745,
      N_Op_Not                                 => 745,
      N_Op_Plus                                => 745,
      N_Attribute_Reference                    => 745,
      N_And_Then                               => 820,
      N_Concat_Multiple                        => 828,
      N_Conditional_Expression                 => 840,
      N_Explicit_Dereference                   => 878,
      N_Function_Call                          => 901,
      N_In                                     => 982,
      N_Indexed_Component                      => 982,
      N_Integer_Literal                        => 1017,
      N_Not_In                                 => 1037,
      N_Null                                   => 1037,
      N_Or_Else                                => 1037,
      N_Procedure_Call_Statement               => 1045,
      N_Qualified_Expression                   => 1126,
      N_Raise_Constraint_Error                 => 1150,
      N_Range                                  => 1160,
      N_Real_Literal                           => 1181,
      N_Selected_Component                     => 1217,
      N_Type_Conversion                        => 1276,
      N_Unchecked_Type_Conversion              => 1391,
      N_Allocator                              => 1415,
      N_Aggregate                              => 1504,
      N_Expression_Actions                     => 1624,
      N_Extension_Aggregate                    => 1673,
      N_Reference                              => 1790,
      N_Slice                                  => 1827,
      N_String_Literal                         => 1895,
      N_Subtype_Indication                     => 1932,
      N_Component_Declaration                  => 2002,
      N_Entry_Declaration                      => 2116,
      N_Entry_Index_Specification              => 2219,
      N_Formal_Object_Declaration              => 2297,
      N_Formal_Type_Declaration                => 2412,
      N_Freeze_Entity                          => 2543,
      N_Full_Type_Declaration                  => 2617,
      N_Incomplete_Type_Declaration            => 2711,
      N_Implicit_Types                         => 2819,
      N_Loop_Parameter_Specification           => 2849,
      N_Object_Declaration                     => 2943,
      N_Private_Extension_Declaration          => 3114,
      N_Private_Type_Declaration               => 3258,
      N_Subtype_Declaration                    => 3414,
      N_Protected_Type_Declaration             => 3503,
      N_Accept_Statement                       => 3621,
      N_Function_Specification                 => 3733,
      N_Procedure_Specification                => 3835,
      N_Access_Function_Definition             => 3924,
      N_Access_Procedure_Definition            => 4010,
      N_Task_Type_Declaration                  => 4083,
      N_Package_Body_Stub                      => 4196,
      N_Protected_Body_Stub                    => 4248,
      N_Subprogram_Body_Stub                   => 4300,
      N_Task_Body_Stub                         => 4346,
      N_Function_Instantiation                 => 4398,
      N_Package_Instantiation                  => 4455,
      N_Procedure_Instantiation                => 4512,
      N_Package_Body                           => 4569,
      N_Subprogram_Body                        => 4647,
      N_Implicit_Label_Declaration             => 4854,
      N_Package_Declaration                    => 4880,
      N_Single_Task_Declaration                => 4949,
      N_Subprogram_Declaration                 => 4985,
      N_Task_Body                              => 5030,
      N_Use_Package_Clause                     => 5148,
      N_Generic_Package_Declaration            => 5170,
      N_Generic_Subprogram_Declaration         => 5267,
      N_Constrained_Array_Definition           => 5340,
      N_Unconstrained_Array_Definition         => 5404,
      N_Exception_Renaming_Declaration         => 5453,
      N_Object_Renaming_Declaration            => 5478,
      N_Package_Renaming_Declaration           => 5516,
      N_Subprogram_Renaming_Declaration        => 5552,
      N_Generic_Function_Renaming_Declaration  => 5602,
      N_Generic_Package_Renaming_Declaration   => 5638,
      N_Generic_Procedure_Renaming_Declaration => 5674,
      N_Abort_Statement                        => 5710,
      N_Assignment_Statement                   => 5716,
      N_Asynchronous_Select                    => 5802,
      N_Block_Statement                        => 5840,
      N_Case_Statement                         => 6005,
      N_Code_Statement                         => 6029,
      N_Conditional_Entry_Call                 => 6040,
      N_Delay_Relative_Statement               => 6079,
      N_Delay_Until_Statement                  => 6090,
      N_Entry_Call_Statement                   => 6101,
      N_Exit_Statement                         => 6148,
      N_Free_Statement                         => 6163,
      N_Goto_Statement                         => 6205,
      N_If_Statement                           => 6210,
      N_Loop_Statement                         => 6264,
      N_Null_Statement                         => 6326,
      N_Raise_Statement                        => 6326,
      N_Requeue_Statement                      => 6331,
      N_Return_Statement                       => 6350,
      N_Selective_Accept                       => 6424,
      N_Timed_Entry_Call                       => 6460,
      N_Abortable_Part                         => 6501,
      N_Abstract_Subprogram_Declaration        => 6512,
      N_Accept_Alternative                     => 6526,
      N_Access_Definition                      => 6579,
      N_Access_To_Object_Definition            => 6592,
      N_Case_Statement_Alternative             => 6640,
      N_Compilation_Unit                       => 6668,
      N_Component_Association                  => 6822,
      N_Component_List                         => 6841,
      N_Derived_Type_Definition                => 6883,
      N_Decimal_Fixed_Point_Definition         => 6941,
      N_Defining_Program_Unit_Name             => 7001,
      N_Delay_Alternative                      => 7026,
      N_Delta_Constraint                       => 7078,
      N_Designator                             => 7112,
      N_Digits_Constraint                      => 7128,
      N_Discriminant_Association               => 7163,
      N_Discriminant_Specification             => 7189,
      N_Elsif_Part                             => 7256,
      N_Enumeration_Type_Definition            => 7300,
      N_Entry_Body                             => 7309,
      N_Entry_Body_Formal_Part                 => 7416,
      N_Entry_Call_Alternative                 => 7477,
      N_Exception_Declaration                  => 7524,
      N_Exception_Handler                      => 7573,
      N_Floating_Point_Definition              => 7619,
      N_Formal_Decimal_Fixed_Point_Definition  => 7662,
      N_Formal_Derived_Type_Definition         => 7662,
      N_Formal_Discrete_Type_Definition        => 7708,
      N_Formal_Floating_Point_Definition       => 7708,
      N_Formal_Modular_Type_Definition         => 7708,
      N_Formal_Ordinary_Fixed_Point_Definition => 7708,
      N_Formal_Package_Declaration             => 7708,
      N_Formal_Private_Type_Definition         => 7766,
      N_Formal_Signed_Integer_Type_Definition  => 7814,
      N_Formal_Subprogram_Declaration          => 7814,
      N_Generic_Association                    => 7853,
      N_Handled_Sequence_Of_Statements         => 7901,
      N_Index_Or_Discriminant_Constraint       => 7976,
      N_Iteration_Scheme                       => 7988,
      N_Label                                  => 8045,
      N_Modular_Type_Definition                => 8056,
      N_Number_Declaration                     => 8067,
      N_Ordinary_Fixed_Point_Definition        => 8116,
      N_Others_Choice                          => 8158,
      N_Package_Specification                  => 8182,
      N_Parameter_Association                  => 8258,
      N_Parameter_Specification                => 8316,
      N_Protected_Body                         => 8445,
      N_Protected_Definition                   => 8497,
      N_Range_Constraint                       => 8559,
      N_Real_Range_Specification               => 8576,
      N_Record_Definition                      => 8597,
      N_Signed_Integer_Type_Definition         => 8673,
      N_Single_Protected_Declaration           => 8694,
      N_Subunit                                => 8735,
      N_Task_Definition                        => 8771,
      N_Terminate_Alternative                  => 8878,
      N_Triggering_Alternative                 => 8917,
      N_Use_Type_Clause                        => 8964,
      N_Variant                                => 8994,
      N_Variant_Part                           => 9044,
      N_With_Clause                            => 9058,
      N_Unused_At_End                          => 9188);

end Treeprs;
