/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                              A - U I N T P                               */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.17 $                             */
/*                                                                          */
/*    Copyright (C) 1992, 1993, 1994, 1995 Free Software Foundation, Inc.   */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, */
/* MA 02111-1307, USA.                                                      */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). */
/*                                                                          */
/****************************************************************************/

/* This file corresponds to the Ada package specification Uintp. It was
   created manually from the files uintp.ads and uintp.adb  */

/* Support for universal integer arithmetic */

struct Uint_Entry
{
  Pos Length;
  Int Loc;
};

/* See if a Uint is within the range of an integer.  */
#define UI_Is_In_Int_Range  uintp__ui_is_in_int_range
extern Boolean Ui_Is_In_Int_Range PROTO((Uint));

/* Obtain Int value from Uint input. This will abort if the result is
   out of range.  */
#define UI_To_Int uintp__ui_to_int
extern Int UI_To_Int	PROTO((Uint));

#ifdef TREE_CODE   /* Don't lose if tree.h not included.  */
/* Similarly, but return a GCC INTEGER_CST.  Overflow is tested by the
   constant-folding used to build the node.  TYPE is the GCC type of the
   resulting node.  */
extern tree UI_To_gnu		PROTO((Uint, tree));
#endif

/* Universal integers are represented by the Uint type which is an index into
   the Uints_Ptr table containing Uint_Entry values.  A Uint_Entry contains an
   index and length for getting the "digits" of the universal integer from the
   Udigits_Ptr table.

   For efficiency, this method is used only for integer values larger than the
   constant Uint_Bias.  If a Uint is less than this constant, then it contains
   the integer value itself.  The origin of the Uints_Ptr table is adjusted so
   that a Uint value of Uint_Bias indexes the first element.  */

#define Uints_Ptr (uintp__uints__table - Uint_First_Entry)
extern struct Uint_Entry *uintp__uints__table;

#define Udigits_Ptr uintp__udigits__table
extern int *uintp__udigits__table;
