------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                       A D A . E X C E P T I O N S                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.12 $                             --
--                                                                          --
-- This specification is adapted from the Ada Reference Manual for use with --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------

with System.Standard_Library;

package Ada.Exceptions is

   type Exception_Id is private;
   Null_Id : constant Exception_Id;
   function Exception_Name (X : Exception_Id) return String;

   type Exception_Occurrence is limited private;
   type Exception_Occurrence_Access is access all Exception_Occurrence;

   Null_Occurrence : constant Exception_Occurrence;

   procedure Raise_Exception (E : in Exception_Id; Message : in String := "");
   function  Exception_Message    (X : Exception_Occurrence) return String;
   procedure Reraise_Occurrence   (X : Exception_Occurrence);

   function Exception_Identity (X : Exception_Occurrence) return Exception_Id;
   function Exception_Name     (X : Exception_Occurrence) return String;
   --  Same as Exception_Name (Exception_Identity (X))

   function Exception_Information (X : Exception_Occurrence) return String;

   procedure Save_Occurrence
     (Target :    out Exception_Occurrence;
      Source : in     Exception_Occurrence);

   function Save_Occurrence
     (Source : in Exception_Occurrence)
      return Exception_Occurrence_Access;

private
   package SSL renames System.Standard_Library;

   type Exception_Id is access all SSL.Exception_Data;
   Null_Id : constant Exception_Id := null;

   subtype Nat is Natural range 0 .. SSL.Exception_Message_Buffer'Last;
   --  ??? replace Nat by Natural when limited types with discriminants
   --  are implemented properly

   --  Exception_Occurrence is defined as a limited record so that when a
   --  default instance is allocated, the default discriminant value is used
   --  to determine the length (given that even the full view is limited, we
   --  do not need to allocate the maximum length).

   type Exception_Occurrence
     (Max_Length : Nat := SSL.Exception_Msg_Max)
   is limited record
      Id         : Exception_Id;
      Msg_Length : Natural;
      Msg        : String (1 .. Max_Length);
   end record;

   --  Note: the following definition of Null_Occurrence is not legal Ada. In
   --  fact, given the clear requirement to make Exception_Occurrence a limited
   --  record (see above note), there is no way to complete Null_Occurrence in
   --  a legal way. There is a special kludge in the compiler to permit this
   --  particular bit of illegal Ada!

   Null_Occurrence : constant Exception_Occurrence := (
     Max_Length => 0,
     Id         => Null_Id,
     Msg_Length => 0,
     Msg        => "");

   procedure Set_Exception_Occurrence (Occ : Exception_Occurrence_Access);
   pragma Export (C, Set_Exception_Occurrence, "__set_except_occ");
   --  Procedure called directly by gigi to copy in the exception occurrence
   --  the exception message kept in the task-Specific data.

end Ada.Exceptions;
