#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/mtio.h>

#include "ftape-ioctl.h"

#if 0
ulong bsm[BAD_SECTOR_MAP_SIZE/4];

eof_mark_union fs_log[MAX_FAILED_SECTORS];


struct mtqic80info qinfo;
#endif

struct mtblksz blockquery;

int main( int argc, char *argv[] )
{
int tapedesc;                        
ulong *bsm_loc;
int i;                             
unsigned short cmap;
char *tapedev;

  tapedev = getenv ("TAPE");
  if (tapedev == NULL) {
    tapedev = DEFTAPE;
  }
  tapedesc = open ( tapedev, O_RDWR );
  if (tapedesc == -1) {
    perror("Can't open tapedev");
    exit( 1 );
  }             
  if ( ioctl( tapedesc, MTIOC_ZFTAPE_GETBLKSZ, &blockquery ) < 0 ) {
    perror("Can't get blocksize of current volume");
    exit(1);
  }
  printf("The blocksize of the current volume is %d bytes!\n", blockquery.mt_blksz );


#if 0
  qinfo.bad_sector_map = (unsigned char *)bsm;
  qinfo.failed_sector_log = fs_log;
  if ( ioctl( tapedesc, MTIOCQIC80RDHEADER ) < 0 ) {
    perror("Can't read header segments.");
    exit(1);
  }
  if ( ioctl( tapedesc, MTIOCGETQIC80INFO, &qinfo ) >= 0 ) {
    for( i=0; i < 4200; i++ ) {
      if ( bsm[i] ) {
        printf("bsm[%d] = %08lx\n",i,bsm[i]);
      }
    }
    for( i=0; i < qinfo.nr_of_failed_sectors; i++ ) {
      printf("fs_log[%d] = %08lx\n",i,fs_log[i].entry);
    }                                        
    printf("nr_of_failed_sectors: %d\n",qinfo.nr_of_failed_sectors);
    printf("compression map location: %d\n", qinfo.compression_map_location);
    printf("tape label: %s\n",qinfo.tape_label);
    printf("first_data_segment: %d\n",qinfo.first_data_segment);
    printf("last_data_segment: %d\n",qinfo.last_data_segment);
  }
  memcpy(qinfo.tape_label,"Dummy Dummy Dummy Dummy Dummy Dummy Dummy         ", 44);
  if ( ioctl( tapedesc, MTIOCSETQIC80INFO, &qinfo ) < 0 ) {
    perror("Can't set data.");
    exit(1);
  }
  if ( ioctl( tapedesc, MTIOCQIC80WRHEADER ) < 0 ) {
    perror("Can't read header segments.");
    exit(1);
  }
  if ( ioctl( tapedesc, MTIOCGETQIC80INFO, &qinfo ) >= 0 ) {
    for( i=0; i < 4200; i++ ) {
      if ( bsm[i] ) {
        printf("bsm[%d] = %08lx\n",i,bsm[i]);
      }
    }
    for( i=0; i < qinfo.nr_of_failed_sectors; i++ ) {
      printf("fs_log[%d] = %08lx\n",i,fs_log[i].entry);
    }                                        
    printf("nr_of_failed_sectors: %d\n",qinfo.nr_of_failed_sectors);
    printf("compression map location: %d\n", qinfo.compression_map_location);
    printf("tape label: %s\n",qinfo.tape_label);
    printf("first_data_segment: %d\n",qinfo.first_data_segment);
    printf("last_data_segment: %d\n",qinfo.last_data_segment);
  }
#endif

}                                         



