#ifndef _QIC80_COMPRESS_H
#define _QIC80_COMPRESS_H
/*
 *
 *      Copyright (c) 1994, 1995  Claus-Justus Heine (cH)
 *
 * This file implements a generic interface between the ftape-driver and a
 * compression-algorithm. The compression-algorithm currently used is a
 * LZ77. I use the implementation lzrw3 by Ross N. Williams
 * (Renaissance Software). The compression program itself is in the file
 * lzrw3.c and compress.h in the subdirectory "compress".
 * To adopt another compression algorithm the functions 
 * ftape_compress_info(), ftape_compress() and ftape_uncompress()
 * must be changed appropriately. See ftape-compress.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 claus
 *
 1.4
 1995/11/15 19:54:06
 Exp
 *
 */

#include "compress/compress.h"

/*
 *
 * CMPR_WRK_MEM_SIZE gives the size of the compression wrk_mem
 * needed  if !defined(DYN_ALLOC). Else it may be set to 0 
 *
 */
/* 
 *  I got these out of lzrw3.c
 */
#define U(X)            ((unsigned long) X)
#define SIZE_P_BYTE     (U(sizeof(byte *)))
#define ALIGNMENT_FUDGE (U(16))

#define CMPR_WRK_MEM_SIZE ( U(4096)*(SIZE_P_BYTE) + ALIGNMENT_FUDGE )

/*
 * the maximum number of bytes the size of the "compressed" data
 * can exceed the uncompressed data. As it is quite useless to
 * compress data twice it is sometimes the case that it is more
 * efficient to copy a block of data but to feed it to the
 * "compression" algorithm. In this case there are some flag bytes
 * or the like proceding the "compressed" data.
 * THAT MUST NOT BE THE CASE for the algorithm we use for this 
 * driver. Instead, the high bit 15 of compressed_size:
 *
 * compressed_size = ftape_compress()
 *
 * must be set in such a case.
 *
 * Nevertheless, it might also be
 * as for lzrw3 that there is an "intermediate" overrun that
 * exceeds the amount of the compressed data that is actually
 * produced. During the algorithm we need in the worst case
 * MAX_CMP_GROUP bytes more than the input-size.
 *
 */
#define MAX_CMP_GROUP (2+16*2) /* from lzrw3.c */

#define CMPR_OVERRUN      MAX_CMP_GROUP /* during compression */

/****************************************************/

#define     CMPR_BUFFER_SIZE (MAX_BLOCK_SIZE + CMPR_OVERRUN)

/*
 *   QIC-80 lets us use at most 29k-12 (or something around that)
 *   for an uncompressed cluster
 */
#define MAX_BLOCK_SIZE     (28*1024)
#define DEFAULT_BLOCK_SIZE (10*1024) /* gnu tar */

/*
 *  to support 1100 feet tapes, we need 15036 entries in the
 *  compression map. Sigh.
 *
 */                       
#define MAP_205_FEET    2800
#define MAP_307_5_FEET  4200 /* normal tapes */
/*
I've got to figure that out ...
#define MAP_400_FEET    7400
#define MAP_425_FEET    7400
*/
#define MAP_770_FEET   13500
#define MAP_1100_FEET  15036

#define COMPRESSION_MAP_SIZE (sizeof(unsigned long)*MAP_1100_FEET)


/*
 *  globals
 */        

extern int ftape_total_data_amount;
extern int ftape_data_pos;
extern int ftape_uncmpr_pos;
extern int ftape_seg_data_pos;   
extern int ftape_block_size;
extern int ftape_use_compression;
extern int ftape_compression_map_changed;
extern int ftape_compression_map_location;
extern int ftape_compression_map_length;
extern int ftape_first_user_segment;

#ifdef DYN_ALLOC

extern byte *ftape_compression_wrk_mem;
extern byte *ftape_compression_buffer;
extern unsigned long *ftape_compression_map;
extern int ftape_cmpr_wrk_mem_size;

#else

extern byte ftape_compression_wrk_mem [ CMPR_WRK_MEM_SIZE ];
extern byte ftape_compression_buffer [ CMPR_BUFFER_SIZE ];
extern unsigned long ftape_compression_map [ COMPRESSION_MAP_SIZE/4 ];

#endif /* DYN_ALLOC */

/*
 *  exported functions
 *
 */

extern void ftape_reset_cmpr_locals( void );
extern int  ftape_compress_info( void );
extern int  ftape_compress_write ( int *write_cnt, 
                                   int *req_len, 
                                   const char *buff,
                                   int buf_pos_write, 
                                   int this_seg_size, 
                                   char *deblock_buffer );
extern int  ftape_compress_read  ( int *read_cnt,  
                                   int *to_do,   
                                   char *buff,
                                   int buf_pos_read,
                                   int buf_len_read,
                                   char *deblock_buffer,
                                   unsigned short block_size );
extern int  ftape_compress_seek( int new_data_pos, unsigned start_seg, unsigned end_seg, unsigned block_size );
extern int  ftape_extract_compression_map( byte *address, unsigned location );
extern int  ftape_update_compression_segments( unsigned segment, byte* buffer );
extern void qic80_decode_compression_header( byte * buffer, int segment );


#endif /* _FTAPE_COMPRESS_H */
