#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/***************************************************************************
 *
 * Function:     snprintf
 *
 * Description:
 *    Print the format output to the string
 *
 * Entry:
 *    pszOutput  - Pointer to the output string buffer
 *    len	 - length of string.
 *    pszFormat  - Pointer to the format string buffer
 *    args       - Various arguments to be used in formatting the output
 *
 * Returns:
 *    The number of characters written to the output string.
 */

int snprintf (char *pszString, int len, const char *pszFormat, ...)
    {
    va_list vaArgs;
    int     nAnswer;
    FILE    fdString;
    FUNC_ENTRY ("sprintf");
/*
 *  Construct the output string file
 */
    fdString._flag = _IOWRT;
    fdString._ptr  =
    fdString._base = pszString;
    fdString._cnt  = len;
    fdString._file = STRING_FILE; /* Magic value for string files */
/*
 *  Generate the output string.
 */
    va_start (vaArgs, pszFormat);
    nAnswer = _doprnt (pszFormat, vaArgs, &fdString);
    va_end (vaArgs);
/*
 *  Terminate the output string with a NUL character.
 */
    putc ('\0', &fdString);
/*
 *  Return the number of characters written to the output file.
 */
    FUNC_EXIT ("sprintf");
    return (nAnswer);
    }
