------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 8                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Atree;    use Atree;
with Einfo;    use Einfo;
with Itypes;   use Itypes;
with Nlists;   use Nlists;
with Nmake;    use Nmake;
with Sinfo;    use Sinfo;

package body Exp_Ch8 is

   ------------------------------------------
   -- Expand_N_Object_Renaming_Declaration --
   ------------------------------------------

   --  Expression_Actions appearing in the Name field must be split as in
   --  Object declarations (see Expand_N_Object_Declaration for details)

   procedure Expand_N_Object_Renaming_Declaration (N : Node_Id) is
      Loc : constant Source_Ptr := Sloc (N);
      Nam : Node_Id := Name (N);

   begin
      if Nkind (Nam) = N_Expression_Actions then
         Insert_List_Before (N, Actions (Nam));

         if Present (First_Itype (Nam)) then
            declare
               Inode : constant Node_Id := Make_Implicit_Types (Loc);

            begin
               Transfer_Itypes (From => Nam, To => Inode);
               Insert_Before (N, Inode);
            end;
         end if;

         Nam := Expression (Nam);
         Set_Name (N, Nam);
         Set_Renamed_Object (Defining_Identifier (N), Nam);
      end if;

   end Expand_N_Object_Renaming_Declaration;

end Exp_Ch8;
