------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                ADA.TEXT_IO.WIDE_TEXT_IO.ENUMERATION_AUX                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains theroutines for Ada.Text_IO.Wide_Text_IO.
--  Enumeration_IO that are shared among separate instantiations.

private package Ada.Text_IO.Wide_Text_IO.Enumeration_Aux is

   procedure Get_Enum_Lit
     (File   : File_Type;
      Buf    : out Wide_String;
      Buflen : out Natural);
   --  Reads an enumeration literal value from the file, folds to upper case,
   --  and stores the result in Buf, setting Buflen to the number of stored
   --  characters (Buf has a lower bound of 1). If more than Buflen characters
   --  are present in the literal, Data_Error is raised.

   procedure Scan_Enum_Lit
     (From  : Wide_String;
      Start : out Natural;
      Stop  : out Natural);
   --  Scans an enumeration literal at the start of From, skipping any leading
   --  spaces. Sets Start to the first character, Stop to the last character.
   --  Raises End_Error if no enumeration literal is found.

   procedure Put
     (File  : File_Type;
      Item  : Wide_String;
      Width : Field;
      Set   : Type_Set);
   --  Outputs the enumeration literal image stored in Item to the given File,
   --  using the given Width and Set parameters (Item is always in upper case).

   procedure Puts
     (To    : out Wide_String;
      Item  : in Wide_String;
      Set   : Type_Set);
   --  Stores the enumeration literal image stored in Item to the string To,
   --  padding with trailing spaces if necessary to fill To. Set is used to

end Ada.Text_IO.Wide_Text_IO.Enumeration_Aux;
