#!/bin/sh

umask 022

source Version.mk

#if [ -e /etc/ld.so.cache ] ; then
#	echo Deleting old /etc/ld.so.cache
#	rm -f /etc/ld.so.cache
#fi

if [ ! -e /etc/ld.so.conf ] ; then
	echo Creating new /etc/ld.so.conf
	for dir in /usr/local/lib /usr/X11R6/lib /usr/X386/lib /usr/openwin/lib /lib/elf ; do
		if [ -d $dir ] ; then
			echo $dir >> /etc/ld.so.conf
		fi
	done
fi

echo Installing ld.so
install -c ld-so/ld.so /lib/ld.so.$VERSION
ln -f /lib/ld.so.$VERSION /lib/ld.so

echo Installing libldso.a
if [ -d /usr/i486-linuxaout/lib ] ; then
	install -c -m 644 ld-so/libldso.a /usr/i486-linuxaout/lib
else
	install -c -m 644 ld-so/libldso.a /usr/lib
fi

echo installing ld-linux.so
install -c d-link/ld-linux.so /lib/ld-linux.so.$VERSION
ln -f /lib/ld-linux.so.$VERSION /lib/ld-linux.so.$VMAJOR
if [ -d /lib/elf ] ; then
	ln -sf ../ld-linux.so.$VERSION /lib/elf/ld-linux.so.$VERSION
	ln -sf ld-linux.so.$VERSION /lib/elf/ld-linux.so.$VMAJOR
fi

echo installing libdl.so
install -c d-link/libdl/libdl.so /lib/libdl.so.$VERSION
ln -sf libdl.so.$VERSION /lib/libdl.so.$VMAJOR
ln -sf libdl.so.$VMAJOR /lib/libdl.so

echo Installing ldd
install -c util/ldd /usr/bin

echo Installing and running ldconfig
if [ -d /sbin ] ; then
	install -c util/ldconfig /sbin
	/sbin/ldconfig
else
	install -c util/ldconfig /etc
	/etc/ldconfig
fi

echo Installing manual pages
install -c -m 644 man/ldd.1 /usr/man/man1
install -c -m 644 man/ldconfig.8 man/ld.so.8 /usr/man/man8

echo Installation complete
