------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 S Y S T E M . T A S K I N G _ L I B R A R Y              --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.1 $                             --
--                                                                          --
--       Copyright (c) 1991,1992,1993,1994, FSU, All Rights Reserved        --
--                                                                          --
-- GNARL is free software; you can redistribute it  and/or modify it  under --
-- terms  of  the  GNU  Library General Public License  as published by the --
-- Free Software  Foundation;  either version 2, or (at  your  option)  any --
-- later  version.  GNARL is distributed  in the hope that  it will be use- --
-- ful, but but WITHOUT ANY WARRANTY;  without even the implied warranty of --
-- MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
-- eral Library Public License  for more details.  You should have received --
-- a  copy of the GNU Library General Public License along with GNARL;  see --
-- file COPYING.LIB.  If not,  write to the  Free Software Foundation,  675 --
-- Mass Ave, Cambridge, MA 02139, USA.                                      --
--                                                                          --
------------------------------------------------------------------------------

with System.Tasking;
with System.Tasking.Protected_Objects;
with Unchecked_Conversion;

package body System.Tasking_Library is

   procedure Service_Cancelled_Call
     (Block : in out System.Tasking.Communication_Block)
   is
      Dummy : Boolean;
      function From_Address is new Unchecked_Conversion
        (Address, Service_Pointer);
      Service : Service_Pointer :=
        From_Address (System.Tasking.Get_Service_Info (Block));
   begin
      if System.Tasking.Get_Cancelled (Block) then
         Service.Entry_Service_Proc (Service.Compiler_Object, Dummy);
         System.Tasking.Protected_Objects.Unlock (Service.Protection_Object);
      end if;
   end Service_Cancelled_Call;

end System.Tasking_Library;
