/* 
   Unix SMB/Netbios implementation.
   Version 1.8.
   Copyright (C) Andrew Tridgell 1994
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This program reports current SMB connections
 */

#include "includes.h"
#include "smb.h"

struct connect_record crec;

int main(int argc, char *argv[])
{
  FILE *f;
  pstring fname;
  int uid;

  strcpy(fname,LOCKDIR);
  trim_string(fname,"","/");
  strcat(fname,"/STATUS..LCK");

  /* if we're running suid then don't allow them to specify the lock 
     file */
  if (argc > 1)
    {
      if (getuid() == geteuid())
	strcpy(fname,argv[1]);
      else
	printf("ignoring filename %s as process is suid\n",argv[1]);
    }
  

  f = fopen(fname,"r");
  if (!f)
    {
      printf("Couldn't open status file %s\n",fname);
      printf("Perhaps you don't have status=yes in [globals] ?\n");
      printf("or maybe you need to give this program the name of your status file\n");
      return(0);
    }

  if (getuid() != 0)
    setuid(0);

  uid = getuid();

  printf("\nSamba version %s\n",VERSION);
  if (uid != 0)
    {
      printf("This program needs to be run as root (or suid root) to run correctly\n");
      printf("when not running as root it may report some connections that are gone\n\n");
    }

  printf("Service      uid   gid   pid   machine\n");
  printf("--------------------------------------\n");

  while (!feof(f))
    {
      if (fread(&crec,sizeof(crec),1,f) != 1)
	break;
      if (crec.magic == 0x280267 && (uid!=0 || process_exists(crec.pid)))
	printf("%-10.10s %5d %5d %5d   %s (%s) %s",
	       crec.name,crec.uid,crec.gid,crec.pid,
	       crec.machine,crec.addr,asctime(LocalTime(&crec.start,0)));
    }

  printf("\n");

  fclose(f);
  return (0);
}

