/*
 * screendump.c - aeb - 940302 - Run as root
 * Possible use: look at the error messages on a VT where X runs.
 *
 * Something similar (but with suppression of trailing spaces) is done
 * by "setterm -dump", but that has un-Unix-like output conventions.
 */
#include <sys/types.h>
#include <linux/termios.h>
#include <stdio.h>

extern char *malloc();

main(int argc, char *argv[]) {
    char *screenbuf;
    struct winsize win;
    int cons, fd, i;
    char consnam[20];

    if (argc > 2) {
	fprintf(stderr, "usage: screendump [n]\n");
	exit(1);
    }
    cons = (argc == 2) ? atoi(argv[1]) : 0;
    sprintf(consnam, "/dev/tty%d", cons);
    if((fd = open(consnam, 0)) < 0)
      fd = 0;

    if (ioctl(fd,TIOCGWINSZ,&win)) {
	perror("TIOCGWINSZ");
	exit(1);
    }
    screenbuf = malloc(2 + win.ws_row * win.ws_col);
    if (!screenbuf) {
	fprintf(stderr, "Out of memory.\n");
	exit(1);
    }

    screenbuf[0] = 0;
    screenbuf[1] = cons;
    
    if (ioctl(0,TIOCLINUX,screenbuf)) {
	perror("TIOCLINUX");
	exit(1);
    }
    for(i=0; i<win.ws_row; i++) {
	write(1,screenbuf+2+i*win.ws_col,win.ws_col);
	write(1,"\n",1);
    }
    exit(0);
}
