/* This file is part of the Project Athena Zephyr Notification System.
 * It contains the grid for the windowgram interpreter character munging.
 *
 *	Created by:	Mark W Eichin
 *
 *	$Source: /mit/zephyr/src/zwgc/compile.dir/RCS/comp_grid.c,v $
 *	$Author: eichin $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <zephyr/mit-copyright.h>

#ifndef lint
static char rcsid_comp_grid_c[] = "$Header: comp_grid.c,v 2.0 88/06/11 00:03:43 eichin Rel $";
#endif lint

#include "comp_types.h"

char _dtype_[1 + 256] = {
	0,

	/*  nul	 soh	 stx	 etx	 eot	 enq	 ack	 bel */
	ZNL,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,

	/*  bs	  ht	  nl	  vt	  np	  cr	  so	  si  */
	ZSP,	ZSP,	ZNL,	ZNL,	ZNL,	ZNL,	ZSP,	ZSP,

	/*  dle	 dc1	 dc2	 dc3	 dc4	 nak	 syn	 etb */
	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,

	/*  can	 em	  sub	 esc	 fs	  gs	  rs	  us  */
	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,	ZSP,

	/*  sp	   !	   "	   #	   $	   %	   &	   '  */
	ZSP,	ZSYM,	ZSYM,	ZMAG,	ZMAG,	ZSYM,	ZSYM,	ZSEP,

	/*   (	   )	   *	   +	   ,	   -	   .	   /  */
	ZLFT,	ZRT,	ZSEP,	ZSYM,	ZSEP,	ZSYM,	ZSYM,	ZSYM,

	/*   0	   1	   2	   3	   4	   5	   6	   7  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   8	   9	   :	   ;	   <	   =	   >	   ?  */
	ZSYM,	ZSYM,	ZSEP,	ZSEP,	ZLFT,	ZSYM,	ZRT,	ZSYM,

	/*   @	   A	   B	   C	   D	   E	   F	   G  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   H	   I	   J	   K	   L	   M	   N	   O  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   P	   Q	   R	   S	   T	   U	   V	   W  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   X	   Y	   Z	   [	   \	   ]	   ^	   _  */
	ZSYM,	ZSYM,	ZSYM,	ZLFT,	ZSYM,	ZRT,	ZSYM,	ZSYM,

	/*   `	   A	   b	   c	   d	   e	   f	   g  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   h	   i	   j	   k	   l	   m	   n	   o  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   p	   q	   r	   s	   t	   u	   v	   w  */
	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,	ZSYM,

	/*   x	   y	   z	   {	   |	   }	   ~	  DEL */
	ZSYM,	ZSYM,	ZSYM,	ZLFT,	ZSYM,	ZRT,	ZSYM,	ZSP,

      };

