/*---------------------------------------------------------------------------
 *
 *	lib_doupdate.c
 *
 *	The routine doupdate() and its dependents
 *
 *	last edit-date: [Thu Jun 17 12:13:14 1993]
 *
 *	-hm	add support for HP terminals (ceol_standout_glitch)
 *	-hm	conversion from termcap -> terminfo
 *	-hm	optimization debugging
 *	-hm	zeyd's ncurses 0.7 update
 *	-hm	eat_newline_glitch bugfix
 *	-hm	hpux lint'ing
 *
 *---------------------------------------------------------------------------*/
 
/* This work is copyrighted. See COPYRIGHT.OLD & COPYRIGHT.NEW for   *
*  details. If they are missing then this copy is in violation of    *
*  the copyright conditions.                                        */

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include "curses.h"
#include "curses.priv.h"
#include "terminfo.h"

extern int _isendwin;
extern void init_acs();

static void ClrUpdate( WINDOW *scr );
static void TransformLine( int lineno );
static void NoIDcTransformLine( int lineno );
static void IDcTransformLine( int lineno );
static void ClearScreen( void );
static void InsStr( chtype *line, int count );
static void DelChar( int count );

static inline void PutAttrChar(chtype ch)
{
	if (curscr->_attrs != (ch & (chtype)A_ATTRIBUTES)) {
		curscr->_attrs = ch & (chtype)A_ATTRIBUTES;
		vidputs(curscr->_attrs, _outc);
	}
	putc(ch & A_CHARTEXT, SP->_ofp);
}

static inline void PutChar(chtype ch)
{
	if (!auto_right_margin || SP->_cursrow <= lines-1 || SP->_curscol <= columns-1) {   
		PutAttrChar(ch); 
		SP->_curscol++; 
		if (SP->_curscol >= columns) {
			if (auto_right_margin) {	 
				SP->_curscol = 0;	   
				SP->_cursrow++;		
			} else {
			 	SP->_curscol--;
			}
		}
	}
}	

static inline void GoTo(int row, int col)
{
	mvcur(SP->_cursrow, SP->_curscol, row, col); 
	SP->_cursrow = row; 
	SP->_curscol = col; 
}

int _outc(char ch)
{
	putc(ch, SP->_ofp);
	return OK;
}

int doupdate(void)
{
int	i;
sigaction_t act, oact;
	
#ifdef TRACE
	if (_tracing)
		_tracef("doupdate() called");
#endif

	act.sa_handler = SIG_IGN;
	sigemptyset(&act.sa_mask);
	act.sa_flags = 0;
	sigaction(SIGTSTP, &act, &oact);

	if (_isendwin == 1) {
		reset_prog_mode();
		/* is this necassery? */
		if (enter_alt_charset_mode)
			init_acs();  
		curscr->_clear = TRUE;
		_isendwin = 0;
	}

	if (curscr->_clear) {		/* force refresh ? */
		ClrUpdate(curscr);		/* yes, clear all & update */
		curscr->_clear = FALSE;	/* reset flag */
		GoTo(curscr->_cury, curscr->_curx);
	} else {
		if (newscr->_clear) {
			ClrUpdate(newscr);
			newscr->_clear = FALSE;
		}

#ifdef TRACE
		if (_tracing)
			_tracef("updating screen");
#endif
		for (i = 0; i < lines ; i++) {
			if(newscr->_firstchar[i] != _NOCHANGE)
				TransformLine(i);
		}

		for (i = 0; i < lines; i++) {
			newscr->_firstchar[i] = _NOCHANGE;
			newscr->_lastchar[i] = _NOCHANGE;
		}

		curscr->_curx = newscr->_curx;
		curscr->_cury = newscr->_cury;

		GoTo(curscr->_cury, curscr->_curx);
	}
	fflush(SP->_ofp);

	sigaction(SIGTSTP, &oact, NULL);

	return OK;
}

static int move_right_cost = -1;

static int countc(char c)
{
	return(move_right_cost++);
}

/*
**	ClrUpdate(scr)
**
**	Update by clearing and redrawing the entire screen.
**
*/

static void ClrUpdate(WINDOW *scr)
{
int	i, j;
int	lastNonBlank;
	
#ifdef DBG1
	debug("ClrUpdate() called");
#endif

	ClearScreen();

	if ((move_right_cost == -1) && parm_right_cursor) {
		move_right_cost = 0;
		tputs(tparm(parm_right_cursor, 10), 1, countc);
	}

	for (i = 0; i < lines; i++) {
		lastNonBlank = columns - 1;
		
		while (scr->_line[i][lastNonBlank] == ' ' )
			lastNonBlank--;

		if (i == lines &&  lastNonBlank == columns - 1) /* lines */
			lastNonBlank--;

#ifdef DBG
		debug("ClrUpd: ln=%d, last=%d", i, lastNonBlank);
#endif
		for (j = 0; j <= lastNonBlank; j++) {
			if (parm_right_cursor) {
				static int inspace = 0;
#ifdef DBG
				debug("ClrUpd: c=[%c]", (char) (scr->_line[i][j] & A_CHARTEXT));
#endif
				if ((scr->_line[i][j]) == ' ') {
					inspace++;
					continue;
				} else if(inspace) {
					if (inspace < move_right_cost) {
						for (; inspace > 0; inspace--)
							PutAttrChar(scr->_line[i][j-1]);
					} else {
						tputs(tparm(parm_right_cursor, inspace), 1, _outc);
					}
					inspace = 0;
				}
			}
			PutAttrChar(scr->_line[i][j]);
		}
		if ((!auto_right_margin) || (lastNonBlank < columns - 1) ||
		    (auto_right_margin && eat_newline_glitch && lastNonBlank == columns-1))
		{
			SP->_cursrow = i;
			SP->_curscol = lastNonBlank < 0 ? 0 : lastNonBlank;
			GoTo(i + 1, 0);
		}
	}

	if (scr != curscr) {
		for (i = 0; i < LINES ; i++)
			for (j = 0; j < COLS; j++)
				curscr->_line[i][j] = scr->_line[i][j];
	}
}

/*
**	TransformLine(lineno)
**
**	Call either IDcTransformLine or NoIDcTransformLine to do the
**	update, depending upon availability of insert/delete character.
*/

static void TransformLine(int lineno)
{

#ifdef DBG1
	debug("TransformLine(%d) called",lineno);
#endif

	if ( (insert_character  ||  (enter_insert_mode  &&  exit_insert_mode))
		 &&  delete_character)
		IDcTransformLine(lineno);
	else
		NoIDcTransformLine(lineno);
}



/*
**	NoIDcTransformLine(lineno)
**
**	Transform the given line in curscr to the one in newscr, without
**	using Insert/Delete Character.
**
**		firstChar = position of first different character in line
**		lastChar = position of last different character in line
**
**		overwrite all characters between firstChar and lastChar.
**
*/

static void NoIDcTransformLine(int lineno)
{
int	firstChar, lastChar;
chtype	*newLine = newscr->_line[lineno];
chtype	*oldLine = curscr->_line[lineno];
int	k;
int	attrchanged = 0;
	
#ifdef TRACE
	if (_tracing)
		_tracef("NoIDcTransformLine(%d) called", lineno);
#endif

#ifdef DBG1
	debug("NoIDcTransformLine(%d) called", lineno);
#endif

	firstChar = 0;
	while (firstChar < columns &&  newLine[firstChar] == oldLine[firstChar]) {
		if(ceol_standout_glitch) {
			if((newLine[firstChar] & (chtype)A_ATTRIBUTES) != (oldLine[firstChar] & (chtype)A_ATTRIBUTES))
			attrchanged = 1;
		}			
		firstChar++;
	}

	if (firstChar >= columns)
		return;

	if(ceol_standout_glitch && attrchanged) {
		firstChar = 0;
		lastChar = columns - 1;
		GoTo(lineno, firstChar);
		if(clr_eol)
			tputs(clr_eol, 1, _outc);		
	} else {
		lastChar = columns - 1;
		while (lastChar > firstChar  &&  newLine[lastChar] == oldLine[lastChar])
			lastChar--;
		GoTo(lineno, firstChar);
	}			

	for (k = firstChar; k <= lastChar; k++) {
		PutChar(newLine[k]);
		oldLine[k] = newLine[k];
	}
}

/*
**	IDcTransformLine(lineno)
**
**	Transform the given line in curscr to the one in newscr, using
**	Insert/Delete Character.
**
**		firstChar = position of first different character in line
**		oLastChar = position of last different character in old line
**		nLastChar = position of last different character in new line
**
**		move to firstChar
**		overwrite chars up to min(oLastChar, nLastChar)
**		if oLastChar < nLastChar
**			insert newLine[oLastChar+1..nLastChar]
**		else
**			delete oLastChar - nLastChar spaces
*/

static void IDcTransformLine(int lineno)
{
int	firstChar, oLastChar, nLastChar;
chtype	*newLine = newscr->_line[lineno];
chtype	*oldLine = curscr->_line[lineno];
int	k, n;
int	attrchanged = 0;
	
#ifdef TRACE
	if (_tracing)
		_tracef("IDcTransformLine(%d) called", lineno);
#endif

#ifdef DBG1
	debug("IDcTransformLine(%d) called", lineno);
#endif

	if(ceol_standout_glitch && clr_eol) {
		firstChar = 0;
		while(firstChar < columns) {
			if((newLine[firstChar] & (chtype)A_ATTRIBUTES) != (oldLine[firstChar] & (chtype)A_ATTRIBUTES))
				attrchanged = 1;
			firstChar++;			
		}
	}
	
	firstChar = 0;
	
	if (attrchanged) {
		GoTo(lineno, firstChar);
		tputs(clr_eol, 1, _outc);		
		for( k = 0 ; k <= (columns-1) ; k++ )
			PutChar(newLine[k]);
	} else {
		while (firstChar < columns  &&
				newLine[firstChar] == oldLine[firstChar])
			firstChar++;
		
		if (firstChar >= columns)
			return;

		oLastChar = columns - 1;
		while (oLastChar > firstChar  &&  oldLine[oLastChar] == ' ')
			oLastChar--;
	
		nLastChar = columns - 1;
		while (nLastChar > firstChar  &&  newLine[nLastChar] == ' ')
			nLastChar--;

		if((nLastChar == firstChar) && clr_eol) {
			GoTo(lineno, firstChar);
			tputs(clr_eol,1,_outc);
			if(newLine[firstChar] != ' ' )
				PutChar(newLine[firstChar]);
		} else if( newLine[nLastChar] != oldLine[oLastChar] ) {
			n = max( nLastChar , oLastChar );

			GoTo(lineno, firstChar);

			for( k=firstChar ; k <= n ; k++ )
				PutChar(newLine[k]);
		} else {
			while (newLine[nLastChar] == oldLine[oLastChar]) {
				nLastChar--;
				oLastChar--;
			}
	
			n = min(oLastChar, nLastChar);

			GoTo(lineno, firstChar);
	
			for (k=firstChar; k <= n; k++)
				PutChar(newLine[k]);

			if (oLastChar < nLastChar)
				InsStr(&newLine[k], nLastChar - oLastChar);

			else if (oLastChar > nLastChar )
				DelChar(oLastChar - nLastChar);
		}
	}
	for (k = firstChar; k < columns; k++)
		oldLine[k] = newLine[k];
}

/*
**	ClearScreen()
**
**	Clear the physical screen and put cursor at home
**
*/

static void ClearScreen()
{

#ifdef DBG1
	debug("ClearScreen() called");
#endif

	if (clear_screen) {
		tputs(clear_screen, 1, _outc);
		SP->_cursrow = SP->_curscol = 0;
	} else if (clr_eos) {
		SP->_cursrow = SP->_curscol = -1;
		GoTo(0,0);

		tputs(clr_eos, 1, _outc);
	} else if (clr_eol) {
		SP->_cursrow = SP->_curscol = -1;

		while (SP->_cursrow < lines) {
			GoTo(SP->_cursrow, 0);
			tputs(clr_eol, 1, _outc);
		}
		GoTo(0,0);
	}
}


/*
**	InsStr(line, count)
**
**	Insert the count characters pointed to by line.
**
*/

static void InsStr(chtype *line, int count)
{
#ifdef TRACE
	if (_tracing)
		_tracef("InsStr(%x,%d) called", line, count);
#endif

	if (enter_insert_mode  &&  exit_insert_mode) {
		tputs(enter_insert_mode, 1, _outc);
		while (count) {
			PutChar(*line);
			line++;
			count--;
		}
		tputs(exit_insert_mode, 1, _outc);
	} else if (parm_ich) {
		tputs(tparm(parm_ich, count), 1, _outc);
		while (count) {
			PutChar(*line);
			line++;
			count--;
		}
	} else {
		while (count) {
			tputs(insert_character, 1, _outc);
			PutChar(*line);
			line++;
			count--;
		}
	}
}

/*
**	DelChar(count)
**
**	Delete count characters at current position
**
*/

static void DelChar(int count)
{
#ifdef TRACE
	if (_tracing)
		_tracef("DelChar(%d) called", count);
#endif
#ifdef DBG1
	debug("DelChar(%d) called", count);
#endif

	if (parm_dch) {
		tputs(tparm(parm_dch, count), 1, _outc);
	} else {
		while (count--)
			tputs(delete_character, 1, _outc);
	}
}

/* EOF */
