/* Written by Chris Metcalf.  You'll have to ask him what he wants as the
 * copyright.
 */

#include <stdio.h>
#include <sys/stat.h>
#include <errno.h>

int
main(int argc, char **argv)
{
	int i, errs, hold;
	struct stat s;

	if (argc < 3) {
		fprintf(stderr, "syntax: cpacl source dest ...\n");
		exit(1);
	}
	if (stat(argv[1], &s)) {
		perror(argv[1]);
		exit(1);
	}
	errs = 0;
	for (i = 2; i < argc; ++i) {
		hold = 0;
		if (chown(argv[i], s.st_uid, s.st_gid)) {
			hold = errno;
			chown(argv[i], -1, s.st_gid);
			chown(argv[i], s.st_uid, -1);
		}
		if (chmod(argv[i], s.st_mode))
			hold = errno;
		if (hold) {
			++errs;
			errno = hold;
			perror(argv[i]);
		}
	}
	return errs;
}

