/* 
   Unix SMB/Netbios implementation.
   Version 1.8.
   Copyright (C) Andrew Tridgell 1992,1993,1994
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Adding for Japanese language by <fujita@ainix.isac.co.jp> 1994.9.5
*/
#ifndef _KANJI_H_
#define _KANJI_H_

#define is_shift_jis(c) \
    ((0x80 <= ((unsigned char) (c)) && ((unsigned char) (c)) <= 0x9f) \
     || (0xe0 <= ((unsigned char) (c)) && ((unsigned char) (c)) <= 0xef))
#define is_kana(c) ((0xa0 <= ((unsigned char) (c)) && ((unsigned char) (c)) <= 0xdf))
#define euc_kana (0x8e)
#define is_euc_kana(c) (((unsigned char) (c)) == euc_kana)
#define is_euc(c)  (0xa0 < ((unsigned char) (c)) && ((unsigned char) (c)) < 0xff)

#define SJIS_CODE (0)
#define EUC_CODE (1)

#ifndef _KANJI_C_
#define strchr sj_strchr
#define strrchr sj_strrchr
#define strstr sj_strstr
#endif /* _KANJI_C_ */

char *sj_strstr (const char *s1, const char *s2);
char *sj_strchr (const char *s, int c);
char *sj_strrchr (const char *s, int c);
char *sj_to_euc (const char *from);
char *euc_to_sj (const char *to);

#endif /* _KANJI_H_ */
