------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             G E T _ T A R G                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--             Copyright (c) 1992,1993, NYU, All Rights Reserved            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms  of the GNU  General  Public  License  as  published  by the  Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  GNAT is distributed  in the hope  that it will be useful,  but --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License  for  more details.  You should have received  a copy of the GNU --
-- General Public License along with GNAT;  see file COPYING. If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Get_Targ is
--  This package provides an Import to the C functions which provide
--  values related to types on the target system.  It is only needed for
--  the elaboration of ttypes.

   function Get_Bits_Per_Unit return Pos;
   pragma Import (C, Get_Bits_Per_Unit, "get_bits_per_unit");
   
   function Get_Bits_Per_Word return Pos;
   pragma Import (C, Get_Bits_Per_Word, "get_bits_per_word");

   function Get_Char_Size return Pos;
   pragma Import (C, Get_Char_Size, "get_target_char_size");

   function Get_Short_Size return Pos;
   pragma Import (C, Get_Short_Size, "get_target_short_size");

   function Get_Int_Size return Pos;
   pragma Import (C, Get_Int_Size, "get_target_int_size");

   function Get_Long_Size return Pos;
   pragma Import (C, Get_Long_Size, "get_target_long_size");

   function Get_Long_Long_Size return Pos;
   pragma Import (C, Get_Long_Long_Size, "get_target_long_long_size");

   function Get_Float_Size return Pos;
   pragma Import (C, Get_Float_Size, "get_target_float_size");

   function Get_Double_Size return Pos;
   pragma Import (C, Get_Double_Size, "get_target_double_size");

   function Get_Long_Double_Size return Pos;
   pragma Import (C, Get_Long_Double_Size, "get_target_long_double_size");

   function Get_Pointer_Size return Pos;
   pragma Import (C, Get_Pointer_Size, "get_target_ponter_size");

   function Width_From_Size  (Size : Pos) return Pos;
   function Digits_From_Size (Size : Pos) return Pos;
   --  Calculate values for 'Width or 'Digits from 'Size

end Get_Targ;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Tue May 10 16:06:50 1994;  author: porter
--  Initial revision
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
