/* Main program for the Midnight Commander
   Copyright (C) 1994 Miguel de Icaza
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "profile.h"
#include "util.h"

static char rcsid [] = "$Id: auto.c,v 1.2 1994/10/13 04:27:22 miguel Exp $";

#ifdef __linux__
void do_exec_mount (char *sec, char *first_arg)
{
    int pid, status;
    extern char *profile_name;
    char mount_prog [200];
    
    GetPrivateProfileString (sec, first_arg, "",
			     &mount_prog, sizeof (mount_prog), profile_name);
    if (!mount_prog [0])
	return;

    open_error_pipe ();
    if ((pid = fork ())){ 
	if (pid == -1)
	    return;
	wait (&status);
	if (status){
	    /* Now try with the -t ro flag */
	    if ((pid = fork ())){
		if (pid == -1)
		    return;
		wait (&status);
	    } else {
		close (0); close (1); 
		execl (mount_prog,mount_prog,"-t","ro", first_arg, (char *)0);
	    }
	}
    } else {
	close (0); close (1);
	execl (mount_prog, mount_prog, first_arg, (char *) 0);
    }
    close_error_pipe (1, NULL);
}

void try_auto_mount (char *dir)
{
    do_exec_mount ("auto-mount", dir);
}

void try_auto_umount (char *dir)
{
    do_exec_mount ("auto-umount", dir);
}

#else
void try_auto_mount (char *s)
{
    /* nothing */
}

void try_auto_umount (char *s)
{
    /* nothing */
}

#endif
