.TH DVGT 1
.SH NAME
dvgt \- view a TeX DVI file on a variety of common VDUs
.SH SYNOPSIS
.B dvgt
[
.I options
]
.IR file [.dvi]
.br
.SH DESCRIPTION
The program
.B dvgt
takes a DVI file
.IR file [.dvi]
produced by TeX (or by some other processor such as GFtoDVI)
and displays it on a variety of commonly available VDUs.
The DVI file may be specified without the
.I .dvi
extension.
.PP
For more information, see the manual 
.I dvgt.tex
in the TEXINPUTS directory.  

.SH OPTIONS
All options have default values. 
System dependent initial defaults are set at compile-time.
Some defaults can be set by environment variables.
The command line options override the environment variables, which in
turn override the compiled initial defaults.
.TP
\fB-H\fP \fIhorizontal_offset\fP
.TP
\fB-V\fP \fIvertical_offset\fP
TeX, by default, considers the top left corner of the printed page as one inch below and one inch to the right of the physical page, and dvgt defaults to this. The two offsets move this corner. Positive dimensions move it downwards and rightwards; negative offsets are allowed.
.TP
\fB-d\fP \fIfile\fP
dvgt will warn you if your document uses a font at a non-existent size. Rather than abort, it will load the PK font specified after \fB-d\fP and continue so you can look for more errors. Paragraphs using this dummy information are likely to have ragged right margins. Using this overrides the enviroment variable DV_DUMMY_PK.
.TP
\fB-e\fP \fIfile\fP
Default TFM file, similar to \fI-d\fP option. Using this overides the environment variable DV_DUMMY_TFM.
.TP
\fB-f\fP \fIfile\fP
dvgt gets all its font information from PK files. These files are kept within the directory specified by this option. Using this overides the environment variables PKFONTS and TEXFONTS.
.TP
\fB-h\fP \fIfile\fP
The ? command reads the help text file specified by this option. Using this overides the environment variable DV_HELP.
.TP
\fB-i\fP
Display the path name of the immediate help file. Typing \fBdvgt\fP by itself displays the immediate help file. Using this overrides the environment variable DV_IMMED_HELP.
.TP
.B \-l
Set landscape mode: exchange x and y dimensions. (This does NOT rotate the page, sorry.) The default is portrait mode.
.TP
\fB-m\fP \fIi\fP
This option allows you to replace the default magnification used in the DVI file with some other value; \fIi\fP is a positive \fIinteger\fP, 1000 times the desired magnification. The given value should be chosen carefully so that the new font sizes still correspond to existing PK files. Unless you know exactly what you are doing you should avoid using \fI-m\fP, especially if your TeX source file uses \magnification \fBand\fP true dimensions.
.TP
\fB-p\fP \fIpostscript_font_prefix\fP
dvgt will search the TFM search paths for TFM metric files with this prefix.  dvgt cannot interpret PostScript, but TFM files for PS fonts will allow dvgt to leave sufficient space for PS font characters, which will then be displayed as filled (Full mode) or outline (Box mode) blocks of that size. Using this overides the environment variable DV_PSPREFIX.
.TP
\fB-r\fP \fIx,y\fP    \fB-r\fP \fIx\fP
dvgt treats the imaginary sheet of paper on which a DVI page will appear as a two dimensional array of tiny dots known as paper pixels. x and y are positive floating point numbers that define the numbers of pixels per inch in the horizonatl and vertical directions, respectively. Their values should match the respective resolutions of the device that will be used to print your document.
If only one value is given, then it is used as the resolution both horizontally and vertically.
.TP
\fB-t\fP \fItfm_directory\fP
This sets the directory where dvgt will look for TFM (TeX Font Metric) files, such as "cmr10.tfm". Using this overides the environment variable TEXFONTS.
.TP
\fB-v\fP \fIstring\fP
This option is used to tell dvgt what type of VDU you are using. The default is to use the value of DV_TERM, if DV_TERM does not describe your VDU you need to override the default value. Typing `dvgt -v vis550 foo' will tell dvgt you're using a VISUAL 550. The current version will accept the following strings (in upper or lower case):

.IP
aed512	AED 512 with 512 by 512 screen
.br
kermit	same as ncsatel
.br
linux	use svga libraries on Linux
.br
ncsatel	NCSA Telnet's Tektronix 4010 emulation
.br
regis	any ReGIS compatible VDU
.br
		synonyms are GIGI, VK100, VT125, VT240
.br
tek4010	same as ncsatel
.br
vis240	VISUAL 240; synonym = VIS241
.br
vis500	VISUAL 500
.br
vis550	VISUAL 550
.br
vis603	VISUAL 603
.br
vis630	VISUAL 630
.br
vt100	any VT100 compatible VDU in 80 column mode
.br
vt102	synonym for VT100
.br
vt100132	any VT100 compatible VDU in 132 column mode
.br
vt200	synonym for VT200
.br
vt220	VT220 using down-loaded chunky graphics
.br
vt640	VT100 with Retro-Graphics
.LP

.TP
\fB-x\fP \fIdimen\fP
.TP
\fB-y\fP \fIdimen\fP

These two options define the width and height of the paper upon which your document will be printed.  Both values are specified as dimensions like those used in TeX, but the units are restricted to BP, CM, IN, MM, PC, PT, PX, or SP.  PX is specific to dvgt, and represents one paper pixel. Every time you select a page, dvgt will use these paper dimensions to check that all printed material falls within the paper edges. The default is system dependent.

.SH "SEE ALSO"
xdvi(1), tex(1), latex(1) 
.SH DIAGNOSTICS
.LP
.SH NOTES
The current version of dvgt does not work with a true Tektronix 4010 terminal
.SH AUTHOR
Original DVItoVDU verison in Modula-2 by Andrew Trevorrow; C conversion by Ian Dall. 

dvgt by Geoffrey Tobin <ecsgrt@luxor.latrobe.edu.au>
