#include <math.h>
#include <OI/oi.H>				/* ScrollBar.C */

	static	GC			draw_gc = 0 ;

int main (int argc, char **argv)
{
		void			mov_crv (OI_ctlr_1d*,void*,OI_scroll_event,long) ;
		void			expose(OI_d_tech*,void*,const XEvent*);
		OI_connection		*conp ;
		OI_app_window		*wp ;
		OI_scroll_bar		*sbp ;
		OI_box			*bp;
	
	if (conp = OI_init(&argc,argv,"ScrollBar")) {
		wp = oi_create_app_window("main",1,1,"ScrollBar") ;
		wp->set_layout(OI_layout_column);
		bp = oi_create_box("curve_box",300,120);
		bp->layout_associated_object(wp,1,1,OI_active);
		sbp = oi_create_scroll_bar("sc_bar",300,OI_horizontal,&mov_crv,(void*)bp);
		sbp->set_span(1000);
		sbp->set_view(100,3);
		sbp->layout_associated_object(wp,1,2,OI_active) ;
		bp->set_expose(expose,sbp) ;
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active) ;
		OI_begin_interaction();
	}
}
void disp_curve(OI_ctlr_1d *sbp, long start_unit, long end_unit)
{
		long		i;
		int		x1,y1,x2,y2;
		OI_box		*bp;
		XGCValues	gcv;
		double		damping;

	bp = (OI_box*)sbp->app_window()->subobject("curve_box");
	if (!draw_gc) {
		gcv.foreground = bp->fg_pixel();
		gcv.background = bp->bkg_pixel();
		draw_gc = XCreateGC(bp->display(),bp->X_window(),GCForeground|GCBackground,&gcv);
	}
	x1 = (int)(bp->size_x()/sbp->view_span()*(start_unit - sbp->handle_loc()));
	damping = (sbp->span() - 0.1*(9*start_unit+1))/(sbp->span() - 1);
	y1 = (int)(damping*sin(double(start_unit)/10.0)*bp->size_y()/2.0 + bp->size_y()/2.0);
	for (i = start_unit + 1 ; i <= end_unit ; i++) {
		x2 = (int)(bp->size_x()/sbp->view_span()*(i - sbp->handle_loc()));
		damping = (sbp->span() - 0.1*(9*i+1))/(sbp->span() - 1);
		y2 = (int)(damping*sin(double(i)/10.0)*bp->size_y()/2.0 + bp->size_y()/2.0);
		XDrawLine(bp->display(),bp->X_window(),draw_gc,x1,y1,x2,y2);
		x1 = x2 ;
		y1 = y2 ;
	}
	return;
}
void disp_full_curve(OI_ctlr_1d *sbp)
{
	OI_box	*bp;

	if (sbp->app_window()) {
		bp = (OI_box*)sbp->app_window()->subobject("curve_box");
		XClearWindow(bp->display(),bp->X_window());
		disp_curve(sbp,sbp->handle_loc(),sbp->handle_loc()+sbp->view_span());
	}
	return;
}
void disp_partial_curve(OI_ctlr_1d *sbp, long num_u)
{
	int	num_pix;
	OI_box	*bp;

	bp = (OI_box*)sbp->app_window()->subobject("curve_box");
	if (num_u > 0) {
		num_pix = (int)(bp->size_x()/sbp->view_span()*num_u);
		XCopyArea(bp->display(),bp->X_window(),bp->X_window(),draw_gc,num_pix,0,bp->size_x()-num_pix,bp->size_y(),0,0);
		XClearArea(bp->display(),bp->X_window(),(int)(bp->size_x() - num_pix),0,num_pix,bp->size_y(),False);
		disp_curve(sbp,sbp->handle_loc() + sbp->view_span() - num_u, sbp->handle_loc() + sbp->view_span());
	}
	else {
		num_pix = (int)(bp->size_x()/sbp->view_span()*(-num_u));
		XCopyArea(bp->display(),bp->X_window(),bp->X_window(),draw_gc,0,0,bp->size_x()-num_pix,bp->size_y(),num_pix,0);
		XClearArea(bp->display(),bp->X_window(),0,0,num_pix,bp->size_y(),False);
		disp_curve(sbp,sbp->handle_loc(),sbp->handle_loc() - num_u);
	}
	return;
}
void expose(OI_d_tech*, void *argp, const XEvent *ep)
{
		OI_scroll_bar   *sbp;
	sbp = (OI_scroll_bar*)argp;
	if ((ep->type == Expose) && (ep->xexpose.count==0))
		disp_full_curve(sbp);
	else if ((ep->type == GraphicsExpose) && (ep->xgraphicsexpose.count==0))
		disp_full_curve(sbp);
}
void mov_crv (OI_ctlr_1d *sbp, void*, OI_scroll_event typ, long n)
{
		switch (typ) {
		 case OI_scroll_unit:
			disp_partial_curve(sbp,n);
			break;
		 case OI_scroll_viewport:
		 case OI_scroll_extreme:
		 case OI_scroll_position:
			disp_full_curve(sbp);
			break;
		}
		return ;
}
