/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	wldtech.H
 *
 *	Description:
 *		OI_wl_d_tech class header
 *		OI_wl_d_tech is the base class for all displayable OI objects
 *		which do NOT have their own private X window.
 *
 *	RCSid = "$Id: wldtech.H,v 4.6.1.1 1993/06/01 22:57:19 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_wldtech_H
#define OI_wldtech_H

#ifndef OI_d_tech_H
#include <OI/d_tech.H>
#endif /* OI_d_tech_H */

/* private control bits */
#define		OI_WL_WIN_DEF		0x1			/* 1 => X_window defined from ancestor */
#define		OI_WL_NEEDS_EXPOSE	0x2			/* 1 => needs expose event for painting */
#define		OI_WL_EXPOSE_ADDED	0x4			/* 1 => expose events have been added to the parent */
#define		OI_WL_DO_RESIZE_EXPOSE	0x8			/* 1 => generate expose events in re_configure() when object is resized */
#define		OI_WL_IGNORE_EVENT_COORDINATES	0x10		/* 1 => ignore the coordinates of an event and always return OI_yes */

	class	OI_wl_d_tech : public OI_d_tech	{		/* windowless display technique */
			unsigned long	ctl_bits ;		/* private control bits */
			OI_number	expect_event;		/* an expected event on this object */
			OI_pointer_array *eventp;		/* pointer to events on object following an unparent */ 
	 protected:
	 public:
		static	OI_class	*clsp ;			/* ptr to class record for this piece of object */

	 private:
			void		chk_paint(const XEvent*, void*);
			void		allow_expose_added()		{ ctl_bits |= OI_WL_EXPOSE_ADDED; }
			void		allow_do_resize_expose()	{ ctl_bits |= OI_WL_DO_RESIZE_EXPOSE; }
			void		clear_window_defined()		{ ctl_bits &= ~OI_WL_WIN_DEF; }
			void		disallow_expose_added()		{ ctl_bits &= ~OI_WL_EXPOSE_ADDED; }
			OI_bool		is_expose_added()		{ return ((ctl_bits&OI_WL_EXPOSE_ADDED) ? OI_YES : OI_NO); }
			OI_bool		is_window_defined()		{ return((ctl_bits&OI_WL_WIN_DEF) != 0 ? OI_YES : OI_NO); }
		virtual	void		post_associate() ;
		virtual	void		pre_unparent() ;
			void		set_window_defined()	{ ctl_bits |= OI_WL_WIN_DEF; }
		virtual	void		xlower() ;
		virtual	void		xmap() ;
		virtual	void		xmapraised() ;
		virtual	void		xraise() ;
		virtual	void		xunmap() ;
	 protected:
					OI_wl_d_tech(OI_class*, const char*) ;
					~OI_wl_d_tech() ;
			void		clear_needs_expose()	{ ctl_bits &= ~OI_WL_NEEDS_EXPOSE; }
		virtual	OI_stat		create() ;
			void		disallow_do_resize_expose()	{ ctl_bits &= ~OI_WL_DO_RESIZE_EXPOSE; }
			OI_bool		needs_expose()	{ return((ctl_bits&OI_WL_NEEDS_EXPOSE) != 0 ? OI_YES : OI_NO); }
		virtual	void		new_connection(class OI_connection*) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		allow_event_coordinates()		{ ctl_bits &= ~OI_WL_IGNORE_EVENT_COORDINATES; }
		virtual	void		circulate(OI_number);
		virtual	void		destroy_x_window() ;
			void		disallow_event_coordinates()		{ ctl_bits |= OI_WL_IGNORE_EVENT_COORDINATES; }
		virtual	OI_number	expected_event();
		virtual	void		expose_reset();
			OI_bool		is_do_resize_expose()		{ return((ctl_bits&OI_WL_DO_RESIZE_EXPOSE) != 0 ? OI_YES : OI_NO); }
			OI_bool		is_event_coordinates()			{ return ((ctl_bits&OI_WL_IGNORE_EVENT_COORDINATES)?OI_no:OI_yes); }
		virtual	void		lift_object(long, long, int, int);			/* remove the object from the display */
			OI_pointer_array *old_events()				{ return (eventp); }
		virtual	void		place_object(long, long, int, int);			/* put the object in a new location */
		virtual	void		set_expected_event(OI_number);
			void		set_old_events(OI_pointer_array *p)	{ eventp = p; }
 		virtual	void		set_stacking_level(OI_number);
		virtual	Window		x_window_id() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		attach_X_window(Window) ;
		virtual	OI_number	decoration_offset_x() ;
		virtual	OI_number	decoration_offset_y() ;
		virtual	OI_number	decoration_size_x() ;
		virtual	OI_number	decoration_size_y() ;
		virtual	OI_bool		has_private_window() ;
		virtual	OI_bool		in_obj(long x, long y, int wid, int ht) ;		/* check if (x,y) relative to object window is in object */
		virtual	OI_bool		in_obj(long x, long y) ;
		virtual	void		repaint(OI_bool=OI_YES) ;
		virtual	OI_stat		set_state(OI_state) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_wldtech_H */
