/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	bind.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface Dynamic Binding header
 *
 *	RCSid = "$Id: bind.H,v 4.1.1.1 1993/06/01 22:52:57 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_bind_H
#define OI_bind_H

#ifndef OI_cb_inf_H
#include <OI/cb_inf.H>
#endif /* OI_cb_inf_H */


 /* structures used to bind objects to user procedures */
		struct OI_binding {	/* binding table entry */
			char	*usr_nam ;	/* name of user object to bind with */
			void	*p ;		/* ptr to user function, argument, or whatever to be bound to object */
		} ;

 /* external functions */
		OI_bool	OI_user_obj(const char*,void**) ;			/* dereference user arg */
		OI_bool	OI_bind_function(OI_d_tech*, const char*,const char*,OI_cb_inf*) ;	/* bind function name to callback */
		OI_bool	OI_bind_arg(OI_d_tech*, const char*,OI_cb_inf*) ;			/* bind argument name to callback */

#endif /* OI_BIND_H */
