/*
 * Copyright (c) 1983 Eric P. Allman
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)conf.h	5.17 (Berkeley) 6/1/90
 */

/*
**  CONF.H -- All user-configurable parameters for sendmail
*/

/*
**  Table sizes, etc....
**	There shouldn't be much need to change these....
*/

# define MAXLINE	1024		/* max line length */
# define MAXNAME	256		/* max length of a name */
# define MAXFIELD	4096		/* max total length of a hdr field */
# define MAXPV		40		/* max # of parms to mailers */
# define MAXHOP		17		/* max value of HopCount */
# define MAXATOM	200		/* max atoms per address */
# define MAXMAILERS	25		/* maximum mailers known to system */
# define MAXRWSETS	40		/* max # of sets of rewriting rules */
# define MAXPRIORITIES	25		/* max values for Precedence: field */
# define MAXTRUST	30		/* maximum number of trusted users */
# define MAXUSERENVIRON	40		/* max # of items in user environ */
# define QUEUESIZE	600		/* max # of jobs per queue run */
# define MAXMXHOSTS	10		/* max # of MX records */

/*
**  Compilation options.
**
**	#define these if they are available; comment them out otherwise.
*/

# define VMUNIX		1	/* running on systems w. 4.2/4.3 networking */
# define DBM		1	/* use DBM library (may require -ldbm) */
/* define only 1 of the various {N,G,S,M}DBM libraries */
# define NDBM		1	/* new DBM library available (requires DBM) */
/*# define GDBM		1	/* gnu DBM library available (requires DBM) */
/*# define SDBM		1	/* Ozan Yigit's PD ndbm (requires DBM) */
/*# define MDBM		1	/* UMaryland's ndbm variant (requires DBM) */
/*# define YP		1	/* enable Yellow Pages code */
/*# define FUZZY	1	/* enable fuzzy matching of local user names */
# define LOG		1	/* enable logging */
# define SMTP		1	/* enable user and server SMTP */
# define QUEUE		1	/* enable queueing */
# define QUEUE_MACVALUE	'$'	/* save the $r and $s macros in queue file */
# define UGLYUUCP	1	/* output ugly UUCP From lines */
# define DAEMON		1	/* include the daemon (requires IPC & SMTP) */
/*# define MAIL11V3	1	/* enable non-standard SMTP mods for DECnet */
#   define SETPROCTITLE	1	/* munge argv to display current status */
# define NAMED_BIND	1	/* use Berkeley Internet Domain Server */
#ifdef sun
# define SIG_TYPE	void	/* SUN's signal() returns void type */
#else
# define SIG_TYPE	int
#endif
# define VSPRINTF	1	/* have vsprintf() in /lib/libc.a */
/*# define SHARE		1	/* Convex share scheduler */
/*# define SYSV		1	/* running on a system 5 system */

/*
** Use query type of ANY if possible (NO_WILDCARD_MX), which will
** find types CNAME, A, and MX, and will cause all existing records
** to be cached by our local server.  If there is (might be) a
** wildcard MX record in the local domain or its parents that are
** searched, we can't use ANY; it would cause fully-qualified names
** to match as names in a local domain.
*/
# define NO_WILDCARD_MX	1

/*
** Change this to the location where sendmail should read its configuration
** file.  Older systems used /usr/lib/sendmail.cf, some newer systems move
** this file to /etc/sendmail.cf.
*/
#define	_PATH_SENDMAILCF	"/etc/sendmail.cf"

/*
** Comment out the following line if freeze files don't work on your platform.
** Freeze files will not work on the Next, nor under AIX 3.1 unless both
** malloc.c and getpwent.c are compiled with the sendmail source.
*/
#if !defined(NeXT) && !defined(_AIX) && !defined(apollo)
# define	_PATH_SENDMAILFC	"/etc/sendmail.fc"
#endif /* !NeXT && !_AIX && !apollo */

/*
** Comment out this line if you don't want sendmail to write a file with
** the daemon's pid.
*/
#define	_PATH_SENDMAILPID   	"/etc/sendmail.pid"

/* The following two definitions added from older implementations -
   particularly for HP Apollo 10.1 - John.Forrest@umist.ac.uk 12/90 */
	/* There are problems on HP Apollo's when updating database files.
	   Essentially, one node will lock out the others if they are opened
	   RW. By default this distribution gets around this by stopping
	   Apollo's from auto-updating. This is not always convenient. An
	   alternative, which some users may prefer, would be to give every
	   machine a unique directory - `node_data/sendmail for instance -
	   and make /usr/lib/mail or whatever symbolic links there. The
	   responsibility for this falls onto the system manager - otherwise
	   sendmail will give lots of messages about being unable to open
	   files. If you want this feature, uncomment the next define. This
	   has no affect on non-Apollo machines. */
	/* 11/3/91 - on a recent occation, this created chaos
	   on our machines when the clocks got out - the pid table
	   on one machine completely filled up with confused 
	   sendmails. I would now advise against its use. jf */
/* #define APOLLO_CAN_UPDATE 1 */

	/* 
	 * A problem has arrisen on Apollo OS/10.1, where sendmail
	 * is sometimes unable to exec mailers with EBADF errno.
	 * This would appear to be related to closing files by
	 * setting their "close on exec" flag, just before the
	 * exec itself. To get around this, defining 
	 * EXPLICIT_CLOSE_ON_EXEC forces explicit calls to close
	 * instead. The effect should be identical - it is difficult
	 * to see why close was not used to start with.
	 */
/* #define EXPLICIT_CLOSE_ON_EXEC 1 */

	/*
	 * There is a bug in doprnt in some machines, including
	 * Apollo 10.1, where %.*s has problems. The bug manifests
	 * itself an extra blank line being added to each set of 
	 * blank lines in the original. To overcome this, we use
	 * an older version of putline in util.c - if DOPRNT_FIX
	 * is defined.
	 */
/* #define DOPRNT_FIX 1 */

/* Beginning of changes aimed at domain.c done by John Forrest, 
   Dept of Computation, UMIST - John.Forrest@umist.ac.uk */

	/*
	 * If you define LOOK_FOR_LONGSYNONYMS, sendmail will try to spot
	 * situations where parent domains have synonyms in BIND. 
	 * For example, with:
	 *	manchester.ac.uk.		CNAME	man.ac.uk.
	 *	computer-science.man.ac.uk	CNAME	cs.man.ac.uk.
	 *
	 * with this option set, given computer-science.manchester.ac.uk
	 * it will produce cs.man.ac.uk. Normally, no such synonym will
	 * be spotted. Note this is primarily intended for use in the UK,
	 * where such synonyms abound. It does take longer to spot a bad
	 * address, so if you don't need the functionality don't use it -
	 * comment out the next line - jf 12/90 */
#define LOOK_FOR_LONGSYNONYMS 1

	/* An extension which allows one of the classes to be nominated
	   as known top domains. If an address ends with one of these to start
	   with, we assume it is fully expanded, and the only point of looking
	   up the name is to find synonyms. Note: this only affects getting
	   the canonical name using BIND. To enable the extension, define
	   TOP_DOMAIN_CLASS to the letter you wish to use. It is suggested
	   that class 't' be used - because this is lower case, no other cf rule
	   set should use this for another reason. However, as a safety
	   measure, the feature is only enabled if there is some data placed
	   in TOP_DOMAIN_CLASS.

	   By default, names are always searched for normally (if
	   NO_WILDCARD_MX) or not really searched for (! NO_WILDCARD_MX).
	   jf 12/90
	*/
#define TOP_DOMAIN_CLASS 't'

	/*
	 * By default, during getcanonname, sendmail accesses BIND
	 * with the DEFNAMES and DNSRCH flags set. This means that
	 * partially defined names will be automatically resolved
	 * by BIND. [Note, if TOP_DOMAIN_CLASS is defined, there is
	 * a dot in the name, and the last element is in the
	 * top domain class, the search will take place with these
	 * bits reset.] If you prefer never to use DNSRCH in this
	 * situation, for some reason, uncomment the next line. The
	 * effect of this is that BIND only knows local and global
	 * names. The bits used are refered to as the "SEARCH bits".
	 * The disadvantage of this is that there are ambiguity
	 * problems if TOP_DOMAIN_CLASS is not kept up to date - there
	 * is a small possibility that what is really a full address
	 * from somewhere else will match a local address. Whether you
	 * feel this is a real possibility is a matter of opinion.
	 *	John Forrest 12/90.
	 */
/* #define DONT_DNSRCH 1 */

	/*
	 * if IGNORE_SELF_MX is defined, getcanonname fails if the
	 * found name has MX's where the best points to the current
	 * node. The reason for this ``trick'' is as follows:
	 *
	 * Host 'somecompany.com', which has a uucp node name of 
	 * 'somecompany' arranges to have an MX record created, 
	 * pointing to the localnmode as the best preference.  
	 * At the same time, they make sure their uucp name is in 
	 * the uucp maps.
	 *
	 * When any internet user sends mail to 
	 * 'user@somecompany.com' it arrives at the localnode. 
	 * Because the best preference MX is local, the TCP mailer 
	 * is not selected.  There is now a lookup of the PATHTABLE 
	 * database.  This contains a record:
	 *
	 * 	somecompany.com		foo!bar!somecompany%s
	 *
	 * which was generated from the uucp maps, using the 
	 * pathalias function.
	 *
	 * The big advantage of this is that whether to use the relay
	 * or not can be determined by ``samecompany'' - it is a
	 * question of changing the MX entry. The disadvantage is
	 * that you have to be able to cope with ALL local synonyms
	 * yourself - via PSEUDONUMS or via the DOMAINTABLE database.
	 * Otherwise, you may find yourself with bouncing mail.
	 * The alternative technique for routing is to use the
	 * MAILERTABLE to indicate different mailers are required
	 * for particular mail. This requires more local intervention,
	 * but doesn't have any of the problems associated with
	 * this option.
	 *
	 * Generally, if you don't relay or you are using non-IDA
	 * .cf files, it is best to leave the option commented out.
	 * Otherwise, it is up to you - it probably depends on
	 * how many nodes you relay to, and how frequently the
	 * information changes.
	    - John.Forrest@umist 11/90. This option selectively
	      enables code added by Paul Pomes. Comment derived 
	      from mail by Neil Rickert. */
/* #define IGNORE_SELF_MX 1 */

/* end of jf domain.c changes */

	/*
	 * There is always a problem of knowing what to do if
	 * the name server returns h_errno==TRY_AGAIN during getcanonname.
	 * By default, it will return FALSE, but if you define
	 * IGNORE_TRYAGAIN, it will return TRUE. Normally if the 
	 * condition still persists, then it will be met again
	 * during getmxrs, and the mail will be requeued. However,
	 * if you use BIND to resolve names, there is always a possibility
	 * that the wrong action will occur. Probably best only to
	 * set this if BIND problems are common.
	 */
/* #define IGNORE_TRYAGAIN 1 */
