/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)useful.h	4.6 (Berkeley) 6/1/90
 */

#ifndef lint
# ifdef _DEFINE
static char useful_h_sccsid[] = "@(#)useful.h	4.6 (Berkeley) 6/1/9";
static char useful_h_rcsid[] = "@(#)$Id: useful.h,v 4.6.0.22 1993/12/02 04:24:22 paul Exp $";
# endif /* _DEFINE */
#endif /* !lint */

#include <sys/types.h>

/* support for bool type.  going from char to int increased BSS by 16 bytes */
typedef int	bool;
#define TRUE	1
#define FALSE	0

#ifndef NULL
# define NULL	0
#endif /* NULL */

/* bit hacking */
#define bitset(bit, word)	(((word) & (bit)) != 0)

/* some simple functions */
#ifndef max
# define max(a, b)	((a) > (b) ? (a) : (b))
# define min(a, b)	((a) < (b) ? (a) : (b))
#endif /* !max */

/* assertions */
#ifndef NASSERT
# define ASSERT(expr, msg, parm)\
	if (!(expr))\
	{\
		fprintf(stderr, "assertion botch: %s:%d: ", __FILE__, __LINE__);\
		fprintf(stderr, msg, parm);\
	}
#else /* !NASSERT */
# define ASSERT(expr, msg, parm)
#endif /* NASSERT */

/* define the types of some common functions */
#ifdef __STDC__
# ifdef SVR4 /* avoid the #pragma int_to_unsigned strlen of SVR4 <string.h> */
#  define strlen __strlen__
# endif /* SVR4 */
# include <string.h>
# ifdef SVR4
#  undef strlen
extern size_t strlen(const char *);
# endif /* SVR4 */
# ifndef __STRICT_BSD__
#  include <unistd.h>
#  include <stdlib.h>
# endif /* !__STRICT_BSD__ */
#else /* !__STDC__ */
extern char	*strcpy(), *strncpy();
extern char	*strcat(), *strncat();
# if !defined(MNEMOSYNE)
extern char	*malloc();
# endif /* !MNEMOSYNE */
extern TIME_TYPE	time();
extern char	*ctime();
extern char	*getenv();
#endif /* __STDC__ */
extern int	errno;

#ifndef SYSV
# if !defined(NeXT) && !defined(_AIX)
extern char	*index(), *rindex();
# endif /* !NeXT && !_AIX */
#else /* SYSV */
# include <fcntl.h>
# ifndef O_SYNC
#  ifdef O_DIRECT
#   define	O_SYNC	O_DIRECT
#  endif /* O_DIRECT */
# endif /* !O_SYNC */
# define	index		strchr
# define	rindex		strrchr
# define	bcopy(h,a,l)	memmove(a,h,l)
# define	bzero(s,n)	memset(s,0,n)
# define	bcmp		memcmp
# define	vfork		fork
# ifndef NOFILE
#  include <sys/param.h>
# endif /* NOFILE */
# ifndef NOFILE			/* not in sys/param.h */
#  ifdef _NFILE			/* we use _NFILE instead */
#   define	getdtablesize() _NFILE
#  else /* !_NFILE */		/* we use a hard-coded value */
#   define	getdtablesize()	50
#  endif /* !_NFILE */					/* Fix002 */
# else /* NOFILE */
#  define	getdtablesize()	NOFILE
# endif /* !NOFILE */
# ifndef SIGCHLD
#  define	SIGCHLD		SIGCLD
# endif /* !SIGCHLD */
# if defined(M_XENIX) && !defined(M_UNIX)
#  include <sys/ndir.h>
#  ifdef SCO
#   include <sys/dirent.h>
#   define direct dirent
#  endif /* SCO */
# else /* !M_XENIX || M_UNIX */
#  if !defined(SVR4BSD)
#   define	direct	dirent
#   ifdef ISC
#    include <sys/dirent.h>
#   else /* !ISC */
#    include <dirent.h>
#   endif /* ISC */
#  endif /* !SVR4BSD */
# endif /* M_XENIX && !M_UNIX */
extern	char	*strchr(),	*strrchr();
# ifndef MAX
#  define	MAX(a,b)	((a)>(b))?(a):(b)
# endif /* !MAX */
#endif /* !SYSV */
