/* X11 STDWIN -- private definitions */

/* Includes */
#include "stdwdefi.h"
#ifdef BOTH_X11_ALFA
#include "only_x11.h"
#endif
#include "stdwin.h"
#include "style.h"              /* For wattr */

/* Includes from X11 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>

/* Additional system includes */
#include <sys/time.h>           /* For struct timeval */

#define IBORDER         1       /* Border width of (most) internal windows */

/* Menu item */
struct item {
        char *text;
        char *sctext;
        short shortcut;
        tbool enabled;
        tbool checked;
};

/* Menu definition */
struct _menu {
        int id;
        char *title;
        int nitems;
        struct item *itemlist;
}; /* == MENU from <stdwin.h> */

/* Window or subwindow essential data */
struct windata {
        Window wid;             /* X Window id */
                                /* The parent is implicit in the use */
        int x, y;               /* Origin w/ respect to parent */
        int width, height;      /* Width and height */
        short border;           /* Border width */
        tbool dirty;            /* Set if update pending */
                                /* Some windows also have an update area */
};

#define NSUBS 7                 /* Number of subwindows */

/* Window struct */
struct _window {
        short tag;              /* Must be first member and must be short! */
        void (*drawproc)();     /* Draw procedure */
        struct {
                int width, height;
        } doc;                  /* Document dimension */
        int careth, caretv;     /* Caret position; (-1, -1) if no caret */

        bool caretshown;        /* Is the caret currently on display? */
        long timer;             /* Deciseconds till next alarm */
        TEXTATTR attr;          /* Text attributes */

        struct windata subw[NSUBS];     /* Subwindows */

        unsigned long fgo, bgo; /* pixel values for all but WA */
        unsigned long fga, bga; /* pixel values for WA */

        GC gc;                  /* Graphics Context for all but WA */
        GC gca;                 /* Graphics Context for WA */

        Region inval;           /* Invalid area in WA window */

        int nmenus;             /* Number of menus */
        MENU **menulist;        /* List of attached menus (incl. global) */
        int curmenu;
        int curitem;

        tbool resized;          /* True if WE_SIZE event pending */

        /* Margins around inner window */
        int lmargin, tmargin, rmargin, bmargin;
}; /* == WINDOW from <stdwin.h> */

/* Shorthands for subwindow array access.
   Order is important! --for wopen() */
#define WO      0
#define MBAR    1
#define VBAR    2
#define HBAR    3
#define WI      4
#define WA      5
#define MWIN    6

#define wo      subw[WO]        /* Outer window (direct child of root)  */
#define mbar    subw[MBAR]      /* Menu bar (child of wo) */
#define vbar    subw[VBAR]      /* Scroll bars (children of wo) */
#define hbar    subw[HBAR]      /* " */
#define wi      subw[WI]        /* Inner window (child of wo) */
#define wa      subw[WA]        /* Application window (child of wi) */
#define mwin    subw[MWIN]      /* Currently visible menu */

/* Button state record */
struct button_state {
        bool down;              /* We think a button is down */
        int button;             /* Which button */
        int mask;               /* Buttons down (1|2|4) */
        int clicks;             /* Click status */
        long time;              /* Time stamp, milliseconds */
        WINDOW *win;            /* The WINDOW where it applies */
        Window w;               /* SubWindow id */
        int isub;               /* Subwindow index */
        int x, y;               /* Current position */
        int xdown, ydown;       /* Position of initial press */
};

/* Private globals */
extern Display *_wd;            /* general.c */
extern Screen *_ws;             /* general.c */
extern XFontStruct *_wf;        /* general.c */
extern XFontStruct *_wmf;       /* general.c */
extern int _wpipe[2];           /* general.c */
extern char *_wprogname;        /* general.c */
extern int _wdebuglevel;        /* errors.c */
extern int _wtracelevel;        /* errors.c */
extern COLOR _w_fgcolor;        /* draw.c */
extern COLOR _w_bgcolor;        /* draw.c */

/* Interned atoms */
extern Atom _wm_protocols;
extern Atom _wm_delete_window;
extern Atom _wm_take_focus;

/* Externals used to communicate hints to wopen() */
extern char *_whostname;
extern char *_wm_command;
extern int _wm_command_len;

/* Function declarations */
extern void wsetcaret _ARGS((WINDOW *win, int h, int v));      /* caret.c */
extern void wnocaret _ARGS((WINDOW *win));                     /* caret.c */
extern void _wshowcaret _ARGS((WINDOW *win));                  /* caret.c */
extern void _whidecaret _ARGS((WINDOW *win));                  /* caret.c */
extern void _winvertcaret _ARGS((WINDOW *win));                /* caret.c */
extern CURSOR *wfetchcursor _ARGS((char* name));               /* cursor.c */
extern void wsetcutbuffer _ARGS((int ibuffer, char* data, int len)); /* cutbuffer.c */
extern char *wgetcutbuffer _ARGS((int ibuffer, int* len_return)); /* cutbuffer.c */
extern void wrotatecutbuffers _ARGS((int n));                  /* cutbuffer.c */
extern void wmessage _ARGS((char* prompt));                    /* dialog.c */
extern int waskync _ARGS((char* prompt, int def));             /* dialog.c */
extern int waskstr _ARGS((char* prompt, char* buf, int len));  /* dialog.c */
extern void _wgcfontswitch _ARGS((void));                      /* draw.c */
extern void wbegindrawing _ARGS((WINDOW *win));                /* draw.c */
extern void wenddrawing _ARGS((WINDOW *win));                  /* draw.c */
extern int wtextwidth _ARGS((char *str, int len));             /* draw.c */
extern int wcharwidth _ARGS((int c));                          /* draw.c */
extern int wlineheight _ARGS((void));                          /* draw.c */
extern int wbaseline _ARGS((void));                            /* draw.c */
extern void wdrawtext _ARGS((int h, int v, char *str, int len)); /* draw.c */
extern void wdrawchar _ARGS((int h, int v, int c));            /* draw.c */
extern void wgetwintextattr _ARGS((WINDOW *win, TEXTATTR *pattr)); /* draw.c */
extern void wsetwintextattr _ARGS((WINDOW *win, TEXTATTR *pattr)); /* draw.c */
extern void wdrawline _ARGS((int h1, int v1, int h2, int v2)); /* draw.c */
extern void wxorline _ARGS((int h1, int v1, int h2, int v2));  /* draw.c */
extern void wdrawbox _ARGS((int left, int top, int right, int bottom)); /* draw.c */
extern void werase _ARGS((int left, int top, int right, int bottom)); /* draw.c */
extern void winvert _ARGS((int left, int top, int right, int bottom)); /* draw.c */
extern void wpaint _ARGS((int left, int top, int right, int bottom)); /* draw.c */
extern void wshade _ARGS((int left, int top, int right, int bottom, int percent)); /* draw.c */
extern void wdrawcircle _ARGS((int h, int v, int radius));     /* draw.c */
extern void wfillcircle _ARGS((int h, int v, int radius));     /* draw.c */
extern void wxorcircle _ARGS((int h, int v, int radius));      /* draw.c */
extern void wdrawelarc _ARGS((int h, int v, int hhalf, int vhalf, int angle1, int angle2)); /* draw.c */
extern void wfillelarc _ARGS((int h, int v, int hhalf, int vhalf, int angle1, int angle2)); /* draw.c */
extern void wxorelarc _ARGS((int h, int v, int hhalf, int vhalf, int angle1, int angle2)); /* draw.c */
extern void wdrawpoly _ARGS((int n, POINT *points));           /* draw.c */
extern void wfillpoly _ARGS((int n, POINT *points));           /* draw.c */
extern void wxorpoly _ARGS((int n, POINT *points));            /* draw.c */
extern void wcliprect _ARGS((int left, int top, int right, int bottom)); /* draw.c */
extern void wnoclip _ARGS((void));                             /* draw.c */
extern void _w_initcolors _ARGS((void));                       /* draw.c */
extern COLOR wgetfgcolor _ARGS((void));                        /* draw.c */
extern COLOR wgetbgcolor _ARGS((void));                        /* draw.c */
extern void wsetfgcolor _ARGS((COLOR color));                  /* draw.c */
extern void wsetbgcolor _ARGS((COLOR color));                  /* draw.c */
extern nonreturning void _wfatal _VARARGS((char* str, ...));   /* error.c */
extern void _werror _VARARGS((char* str, ...));                /* error.c */
extern void _wwarning _VARARGS((char* str, ...));              /* error.c */
extern void _wtrace _VARARGS((int level, char* str, ...));     /* error.c */
extern void _wdebug _VARARGS((int level, char* str, ...));     /* error.c */
extern void _w_deactivate _ARGS((WINDOW *win));                /* event.c */
extern WINDOW *_w_get_last_active _ARGS((void));               /* event.c */
extern WINDOW *wgetactive _ARGS((void));                       /* event.c */
extern void wungetevent _ARGS((EVENT *ep));                    /* event.c */
extern bool wpollevent _ARGS((EVENT *ep));                     /* event.c */
extern void wgetevent _ARGS((EVENT *ep));                      /* event.c */
extern void _winitfonts _ARGS((void));                         /* font.c */
extern void _wfontswitch _ARGS((void));                        /* font.c */
extern void _winvert _ARGS((Drawable d, GC gc, int x, int y, int width, int height)); /* general.c */
extern char *_wgetdefault _ARGS((char *name, char *classname)); /* general.c */
extern int _wgetbool _ARGS((char *name, char *classname, int def)); /* general.c */
extern void _w_ll_event _ARGS((XEvent *e));                    /* llevent.c */
extern void wmenusetdeflocal _ARGS((bool flag));               /* menu.c */
extern void wmenuattach _ARGS((WINDOW *win, MENU *mp));        /* menu.c */
extern void wmenudetach _ARGS((WINDOW *win, MENU *mp));        /* menu.c */
extern void _waddmenus _ARGS((WINDOW *win));                   /* menu.c */
extern void _w_delmenus _ARGS((WINDOW *win));                  /* menu.c */
extern MENU *wmenucreate _ARGS((int id, char *title));         /* menu.c */
extern void wmenudelete _ARGS((MENU *mp));                     /* menu.c */
extern int wmenuadditem _ARGS((MENU *mp, char *text, int shortcut)); /* menu.c */
extern void wmenusetitem _ARGS((MENU *mp, int i, char *text)); /* menu.c */
extern void wmenuenable _ARGS((MENU *mp, int i, bool flag));   /* menu.c */
extern void wmenucheck _ARGS((MENU *mp, int i, bool flag));    /* menu.c */
extern void _wdrawmbar _ARGS((WINDOW *win));                   /* menu.c */
extern void _whitmbar _ARGS((struct button_state *bsp, EVENT *ep)); /* menu.c */
extern void _whitmwin _ARGS((struct button_state *bsp, EVENT *ep)); /* menu.c */
extern bool _w_menukey _ARGS((int c, EVENT *ep));              /* menu.c */
extern void _wkillmenus _ARGS((void));                         /* menu.c */
extern void _wdrawhbar _ARGS((WINDOW *win));                   /* scroll.c */
extern void _wdrawvbar _ARGS((WINDOW *win));                   /* scroll.c */
extern void _whithbar _ARGS((struct button_state *bsp, EVENT *ep)); /* scroll.c */
extern void _whitvbar _ARGS((struct button_state *bsp, EVENT *ep)); /* scroll.c */
extern int wsetselection _ARGS((WINDOW *win, int sel, char *data, int len)); /* selection.c */
extern void wresetselection _ARGS((int sel));                  /* selection.c */
extern char *wgetselection _ARGS((int sel, int *len_return));  /* selection.c */
extern void _w_selectionclear _ARGS((Atom selection));         /* selection.c */
extern int _w_lostselection _ARGS((EVENT *ep));                /* selection.c */
extern void _w_selectionreply _ARGS((Window owner, Window requestor, Atom selection, Atom target, Atom property, Time time)); /* selection.c */
extern void wsettimer _ARGS((WINDOW *win, int deciseconds));   /* timer.c */
extern bool _w_checktimer _ARGS((EVENT *ep, bool mayblock));   /* timer.c */
extern WINDOW *_whichwin _ARGS((Window w));                    /* window.c */
extern WINDOW *_w_somewin _ARGS((void));                       /* window.c */
extern unsigned long _wgetpixel _ARGS((char *resname, char *resclassname, unsigned long defpixel)); /* window.c */
extern unsigned long _w_fetchpixel _ARGS((char *cname, unsigned long defpixel)); /* window.c */
extern Pixmap _w_gray _ARGS((void));                           /* window.c */
extern void _w_setgrayborder _ARGS((WINDOW *win));             /* window.c */
extern GC _wgcreate _ARGS((Window wid, Font fid, unsigned long fg, unsigned long bg)); /* window.c */
extern bool _wcreate1 _ARGS((struct windata *wp, Window parent, int cursor, bool map, unsigned long fg, unsigned long bg, bool nowm)); /* window.c */
extern void _wsaveunder _ARGS((struct windata *wp, Bool flag)); /* window.c */
extern void _wmove _ARGS((struct windata *wp));                /* window.c */
extern void _wmovesubwins _ARGS((WINDOW *win));                /* window.c */
extern void _wsetmasks _ARGS((WINDOW *win));                   /* window.c */
extern bool _w_doresizes _ARGS((EVENT *ep));                   /* window.c */
extern bool _w_doupdates _ARGS((EVENT *ep));                   /* window.c */
extern void wupdate _ARGS((WINDOW *win));                      /* window.c */
extern void wclose _ARGS((WINDOW *win));                       /* window.c */
extern void wsettitle _ARGS((WINDOW *win, char *title));       /* window.c */
extern char *wgettitle _ARGS((WINDOW *win));                   /* window.c */
extern void wseticontitle _ARGS((WINDOW *win, char *title));   /* window.c */
extern char *wgeticontitle _ARGS((WINDOW *win));               /* window.c */
extern void wgetwinsize _ARGS((WINDOW *win, int *pwidth, int *pheight)); /* window.c */
extern void wgetwinpos _ARGS((WINDOW *win, int *ph, int *pv)); /* window.c */
extern void wchange _ARGS((WINDOW *win, int left, int top, int right, int bottom)); /* window.c */
extern void wscroll _ARGS((WINDOW *win, int left, int top, int right, int bottom, int dh, int dv)); /* window.c */
extern void wsetorigin _ARGS((WINDOW *win, int orgh, int orgv)); /* window.c */
extern void wgetorigin _ARGS((WINDOW *win, int *ph, int *pv)); /* window.c */
extern void wsetdocsize _ARGS((WINDOW *win, int width, int height)); /* window.c */
extern void wgetdocsize _ARGS((WINDOW *win, int *pwidth, int *pheight)); /* window.c */
extern void wsetwincursor _ARGS((WINDOW *win, CURSOR *cursor)); /* window.c */
extern void wshow _ARGS((WINDOW *win, int left, int top, int right, int bottom)); /* window.c */
extern void wfleep _ARGS((void));                              /* window.c */
extern void _waddtoall _ARGS((MENU *mp));                      /* window.c */
extern void _wdelfromall _ARGS((MENU *mp));                    /* window.c */
extern WINDOW *_wnexttimer _ARGS((void));                      /* window.c */
extern void _wkillwindows _ARGS((void));                       /* window.c */
extern long wgetxwindowid _ARGS((WINDOW *win));                /* window.c */

/* Function _wcreate has an extra parameter now */
#define _wcreate(wp, parent, cursor, map, fg, bg) \
        _wcreate1(wp, parent, cursor, map, fg, bg, 0)
