/* Extension dependant execution.
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <ncurses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include "user.h"
#include "main.h"
#include "util.h"
#include "dialog.h"
#include "global.h"

void exec_extension (char *data)
{
    char *file_name = tmpnam (0);
    FILE *cmd_file;
    int  expand_prefix_found = 0;
    
    if ((cmd_file = fopen (file_name, "w+")) == NULL){
	message (1, " Error ", " Can't create temporary command file ");
	return;
    }
    for (;*data && *data != '\n'; data++){
	if (expand_prefix_found){
	    fputs (expand_format (*data), cmd_file);
	    expand_prefix_found = 0;
	} else {
	    if (*data == '%')
		expand_prefix_found = 1;
	    else
		fputc (*data, cmd_file);
	}
    }
    fclose (cmd_file);
    chmod (file_name, S_IRWXU);
    execute (file_name);
    unlink (file_name);
}

regex_command (char *filename)
{
    char *extension_file;
    char buffer [200];
    char *data;
    char *p;
    int  col;
    int  file_len = strlen (filename);

    sprintf (buffer, "%s/.nc.ext", home_dir);
    if (exist_file (buffer))
	extension_file = buffer;
    else
	extension_file = EXT;
    
    if ((data = load_file (extension_file)) == NULL)
	return;

    col = 0;
    for (p = data; *p; p++){
	if (*p == '\n'){
	    col = 0;
	    continue;
	}
	col++;
	if (col > 0 && (*p == ' ' || *p == '\t')){
	    *p = 0;
	    if (strcmp (p-(col-1), (filename+file_len-(col-1))) == 0){
		exec_extension (p+1);
		break;
	    }
	    if (p = strchr (p, '\n'))
		p++;
	    else
		break;
	}
    }
    free (data);
}
