/* User Menu implementation
   Copyright (C) 1994 Miguel de Icaza
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ncurses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>

#include "util.h"
#include "global.h"
#include "dialog.h"
#include "color.h"
#include "input.h"
#include "main.h"

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/user.c,v 1.4 1994/05/14 21:35:02 miguel Exp $";

#define MAX_ENTRIES 40
#define MAX_ENTRY_LEN 60

static char *data;
static WINDOW *w;
static char *entries [MAX_ENTRIES];
static int max_cols;
static int selected;
static int menu_lines;

static user_paint_entry (int index, int selected)
{
    if (index == selected)
	wattrset (w, A_BOLD);
    else
	wattrset (w, MENU_ENTRY_COLOR);
    wmove (w, index, 0);
    wprintw (w, " %-*s ", max_cols, extract_line (entries [index], entries [index]+60));
}

extern char *search_string (char *, char *);

execute_menu_command (char *s)
{
    char *commands;
    FILE *cmd_file;
    char *file_name = tmpnam (0);
    char buf [100];
    int  col;
    
    if ((cmd_file = fopen (file_name, "w+")) == NULL){
	message (1, " Error ", " Can't create temporary command file ");
	return;
    }
    commands = search_string (s, "\n");
    
    for (col = 0; *commands; commands++){
	if (col == 0 && (*commands != ' ' && *commands != '\t'))
	    break;
	col++;
	if (*commands == '\n')
	    col = 0;
	fputc (*commands, cmd_file);
    }
    fclose (cmd_file);
    chmod (file_name, S_IRWXU);
    execute (file_name);
    unlink (cmd_file);
}

static paint_user_menu ()
{
    int i;
    
    for (i = 0; i < menu_lines; i++)
	user_paint_entry (i, selected);
    wrefresh (w);
}

void menu_input_loop (int top)
{
    int c;
    int i;
    
    while ((c = getch ()) != '\e'){
	switch (c){
	case XCTRL('c'):
	    return;
	    
	case '\n':
	    execute_menu_command (entries [selected]);
	    return;

	case XCTRL('p'):
	case KEY_UP:
	    user_paint_entry (selected, -1);
	    selected--;
	    if (selected < 0)
		selected = top-1;
	    break;

	case XCTRL('n'):
	case KEY_DOWN:
	    user_paint_entry (selected, -1);
	    selected++;
	    if (selected == top)
		selected = 0;
	    break;

	default:
	    c = tolower (c);
	    if (c >= 'a' && c <= 'z'){
		for (i = 0; i < top; i++)
		    if (tolower (*entries [i]) == c){
			execute_menu_command (entries [i]);
			return;
		    }
	    }
	}
	user_paint_entry (selected, selected);
	wrefresh (w);
    }
}

void user_menu_cmd ()
{
    char buffer [100];
    char *menu, *p;
    int  col, i;

    if (exist_file ("./nc.menu"))
	menu = "./nc.menu";
    else {
	sprintf (buffer, "%s/.nc.menu", home_dir);
	if (exist_file (buffer))
	    menu = buffer;
	else
	    menu = MENU;
    }
    if ((data = load_file (menu)) == NULL)
	return;

    max_cols = 0;
    for (i = 0; i < MAX_ENTRIES; i++)
	entries [i] = 0;
    
    for (menu_lines = col = 0, p = data; (menu_lines < LINES - 6) && *p; p++){
	if (col == 0 && (*p >= 'A' && *p <= 'Z'))
	    entries [menu_lines] = p;
	if (menu_lines == MAX_ENTRIES)
	    break;
	if (*p == '\t')
	    *p = ' ';
	col++;
	if (*p == '\n'){
	    if (entries [menu_lines])
		menu_lines++;
	    max_cols = max (max_cols, col);
	    col = 0;
	}
    }
    max_cols = min (max (max_cols, col), MAX_ENTRY_LEN);
    
    create_dialog (max_cols+2, menu_lines, " Menu ", "", 0);
    w = get_top_text ();
    selected = 0;

    paint_user_menu ();
    menu_input_loop (menu_lines);
    done_dialog ();
    refresh_screen ();
    free (data);
}
