/* -*- Mode:Text -*- */
#ifndef lint
static char Rcs_Id[] =
    "$Id: good.c,v 1.28 91/07/15 19:26:49 geoff Exp $";
#endif

/*
 * good.c - see if a word or its root word
 * is in the dictionary.
 *
 * Pace Willisson, 1983
 *
 * Copyright 1987, 1988, 1989, by Geoff Kuenning, Manhattan Beach, CA
 * Permission for non-profit use is hereby granted.
 * All other rights reserved.
 * See "version.h" for a more complete copyright notice.
 */

/*
 * $Log:	good.c,v $
 * Revision 1.28  91/07/15  19:26:49  geoff
 * Provide the "canonical" parameter to all strtoichar calls.
 * 
 * Revision 1.27  91/07/11  19:52:04  geoff
 * Remove the include of stdio.h, since ispell.h now does this.
 * 
 * Revision 1.26  91/07/05  20:31:55  geoff
 * Fix some more lint complaints.
 * 
 * Revision 1.25  90/12/31  00:59:10  geoff
 * Reformat to follow a consistent convention throughout ispell
 * 
 * Revision 1.24  90/04/26  22:44:00  geoff
 * Add the canonicalize parameter to the calls to ichartosstr.
 * 
 * Revision 1.23  89/06/09  15:52:43  geoff
 * Add support for the internal "character" type, ichar_t.
 * 
 * Revision 1.22  89/04/28  01:08:24  geoff
 * Change Header to Id;  nobody cares about my pathnames.
 * 
 * Revision 1.21  89/04/27  23:30:59  geoff
 * In cap_ok, call setfindlast just before findlastchar, since dent changes
 * on every pass through the loop.
 * 
 * Revision 1.20  89/04/03  01:54:56  geoff
 * Add support for string characters, and fix some lint complaints.
 * 
 * Revision 1.19  88/12/26  02:25:27  geoff
 * Add a copyright notice.
 * 
 * Revision 1.18  88/02/20  23:11:00  geoff
 * Major changes to support the new capitalization handling methods.
 * 
 * Revision 1.17  87/09/30  23:29:46  geoff
 * Changes to support the "suggestion" mode, also rationalize certain
 * buffer sizes.  Includes major rewrite of parts of cap_ok.
 * 
 * Revision 1.16  87/09/24  23:24:13  geoff
 * Don't accidentally accept illegal capitalizations in cap_ok just
 * because the tail is self-consistent.  (Israel Pinkas).
 * 
 * Revision 1.15  87/07/20  23:21:31  geoff
 * Strip out the old hardwired code and add support for table-driving.
 * 
 * Revision 1.14  87/06/13  15:12:45  geoff
 * Another s_ending fix, this time to check for a vowel before the Y
 * in converting @Y to @IES.
 * 
 * Revision 1.13  87/04/24  20:32:11  geoff
 * Don't return prematurely in d_ending if just removing "D" fails.
 * 
 * Revision 1.12  87/04/19  22:51:14  geoff
 * Add extensive code to handle capitalization.
 * 
 * Revision 1.11  87/03/31  17:15:40  geoff
 * Integrate Joe Orost's strlen removal and reg decls into the main branch
 * 
 * Revision 1.10  87/03/31  16:40:25  geoff
 * Add a declaration of index().
 * 
 * Revision 1.9  87/03/22  23:56:12  geoff
 * Fix minor bugs found by Dave Mason
 * 
 * Revision 1.8  87/03/09  22:05:58  geoff
 * Major edit to overhaul the logic to make sure it conforms to the
 * specifications in the comments and the README file.
 * 
 * Revision 1.7  87/03/08  20:30:06  geoff
 * Add a third argument to all lookup calls.  Fix the s_ending stuff
 * one more time, so that it handles X/J/Z flags correctly.
 * 
 * 
 * Revision 1.6  87/03/01  00:56:21  geoff
 * Don't call treelookup, since lookup now calls it.  Also, the hash
 * table now contains real pointers instead of indices cast to pointer
 * types.
 * 
 * Revision 1.5  87/02/28  14:57:32  geoff
 * Add support for the -c flag and for dents returned by treelookup.
 * 
 * Revision 1.4  87/02/28  01:05:30  geoff
 * Fix s_ending to properly allow ES only after S, X, Z, and H.
 * 
 * Revision 1.3  87/02/26  00:39:12  geoff
 * Integrate McQueer's enhancements into the main branch
 * 
 * Revision 1.2  87/01/17  13:11:29  geoff
 * Add RCS ID keywords
 * 
 */

#include <ctype.h>
#include "config.h"
#include "ispell.h"

extern struct dent *	lookup ();
#ifdef CAPITALIZATION
extern long		whatcap ();
#endif
extern char *		index ();
extern char *		strcpy ();

static ichar_t *	orig_word;

#ifdef CAPITALIZATION
good (w, ignoreflagbits, allhits)
    ichar_t *		w;		/* Word to look up */
    int			ignoreflagbits;	/* NZ to ignore affix flags in dict */
    int			allhits;	/* NZ to ignore case, get every hit */
#else
/* ARGSUSED */
good (w, ignoreflagbits, dummy)
    ichar_t *		w;		/* Word to look up */
    int			ignoreflagbits;	/* NZ to ignore affix flags in dict */
    int			dummy;
#define allhits	0	/* Never actually need more than one hit */
#endif
    {
    ichar_t		nword[INPUTWORDLEN + MAXAFFIXLEN];
    register ichar_t *	p;
    register ichar_t *	q;
    register		n;
    register struct dent * dp;

    /*
    ** Make an uppercase copy of the word we are checking.
    */
    for (p = w, q = nword;  *p;  )
	*q++ = mytoupper (*p++);
    *q = 0;
    n = q - nword;

    numhits = 0;

    if (cflag)
	{
	(void) printf ("%s", ichartosstr (w, 0));
	orig_word = w;
	}
    else if ((dp = lookup (nword, 1)) != NULL)
	{
	hits[0].dictent = dp;
	hits[0].prefix = NULL;
	hits[0].suffix = NULL;
#ifdef CAPITALIZATION
	if (allhits  ||  cap_ok (w, &hits[0], n))
	    numhits = 1;
#else
	numhits = 1;
#endif
	}
    if (numhits  &&  !allhits)
	return 1;

    /* try stripping off affixes */

#if 0
    numchars = icharlen (nword);
    if (numchars < 4)
	{
	if (cflag)
	    (void) putchar ('\n');
	return numhits  ||  (numchars == 1);
	}
#endif

    chk_aff (w, nword, n, ignoreflagbits, allhits);

    if (cflag)
	(void) putchar ('\n');

#ifdef CAPITALIZATION
    if (numhits)
	return allhits  ||  cap_ok (w, &hits[0], n);
    else
	return 0;
#else
    return numhits;
#endif
    }

#ifdef CAPITALIZATION
cap_ok (word, hit, len)
    register ichar_t *		word;
    register struct success *	hit;
    int				len;
    {
    register ichar_t *		dword;
    register ichar_t *		w;
    register struct dent *	dent;
    ichar_t			dentword[INPUTWORDLEN + MAXAFFIXLEN];
    int				preadd;
    int				prestrip;
    int				sufadd;
    ichar_t *			limit;
    long			thiscap;
    long			dentcap;

    thiscap = whatcap (word);
    /*
    ** All caps is always legal, regardless of affixes.
    */
    if (thiscap == ALLCAPS)
	return 1;
    else if (thiscap == FOLLOWCASE)
	{
	/* Set up some constants for the while(1) loop below */
	if (hit->prefix)
	    {
	    preadd = hit->prefix->affl;
	    prestrip = hit->prefix->stripl;
	    }
	else
	    preadd = prestrip = 0;
	sufadd = hit->suffix ? hit->suffix->affl : 0;
	}
    /*
    ** Search the variants for one that matches what we have.  Note
    ** that thiscap can't be ALLCAPS, since we already returned
    ** for that case.
    */
    dent = hit->dictent;
    while (1)
	{
	dentcap = captype (dent->flagfield);
	if (dentcap != thiscap)
	    {
	    if (dentcap == ANYCASE  &&  thiscap == CAPITALIZED
	     &&  entryhasaffixes (dent, hit))
		return 1;
	    }
	else				/* captypes match */
	    {
	    if (thiscap != FOLLOWCASE)
		{
		if (entryhasaffixes (dent, hit))
		    return 1;
		}
	    else
		{
		/*
		** Make sure followcase matches exactly.
		** Life is made more difficult by the
		** possibility of affixes.  Start with
		** the prefix.
		*/
		strtoichar (dentword, dent->word, 1);
		dword = dentword;
		limit = word + preadd;
		if (myupper (dword[prestrip]))
		    {
		    for (w = word;  w < limit;  w++)
			{
			if (mylower (*w))
			    goto doublecontinue;
			}
		    }
		else
		    {
		    for (w = word;  w < limit;  w++)
			{
			if (myupper (*w))
			    goto doublecontinue;
			}
		    }
		dword += prestrip;
		/* Do root part of word */
		limit = dword + len - preadd - sufadd;
		while (dword < limit)
		    {
		    if (*dword++ != *w++)
		      goto doublecontinue;
		    }
		/* Do suffix */
		dword = limit - 1;
		if (myupper (*dword))
		    {
		    for (  ;  *w;  w++)
			{
			if (mylower (*w))
			    goto doublecontinue;
			}
		    }
		else
		    {
		    for (  ;  *w;  w++)
			{
			if (myupper (*w))
			    goto doublecontinue;
			}
		    }
		/*
		** All failure paths go to "doublecontinue,"
		** so if we get here it must match.
		*/
		if (entryhasaffixes (dent, hit))
		    return 1;
doublecontinue:	;
		}
	    }
	if ((dent->flagfield & MOREVARIANTS) == 0)
	    break;
	dent = dent->next;
	}

    /* No matches found */
    return 0;
    }

/*
** See if this particular capitalization (dent) is legal with these
** particular affixes.
*/
entryhasaffixes (dent, hit)
    register struct dent *	dent;
    register struct success *	hit;
    {

    if (hit->prefix  &&  !TSTMASKBIT (dent->mask, hit->prefix->flagbit))
	return 0;
    if (hit->suffix  &&  !TSTMASKBIT (dent->mask, hit->suffix->flagbit))
	return 0;
    return 1;			/* Yes, these affixes are legal */
    }
#endif

/*
 * Print a word and its flag, making sure the case of the output matches
 * the case of the original found in "orig_word".
 */
flagpr (word, preflag, prestrip, preadd, sufflag, sufadd)
    register ichar_t *	word;		/* (Modified) word to print */
    int			preflag;	/* Prefix flag (if any) */
    int			prestrip;	/* Lth of pfx stripped off orig_word */
    int			preadd;		/* Length of prefix added to w */
    int			sufflag;	/* Suffix flag (if any) */
    int			sufadd;		/* Length of suffix added to w */
    {
    register ichar_t *	origp;		/* Pointer into orig_word */
    int			orig_len;	/* Length of orig_word */

    orig_len = icharlen (orig_word);
    /*
     * We refuse to print if the cases outside the modification
     * points don't match those just inside.  This prevents things
     * like "OEM's" from being turned into "OEM/S" which expands
     * only to "OEM'S".
     */
    if (preflag > 0)
	{
	origp = orig_word + preadd;
	if (myupper (*origp))
	    {
	    for (origp = orig_word;  origp < orig_word + preadd;  origp++)
		{
		if (mylower (*origp))
		    return;
		}
	    }
	else
	    {
	    for (origp = orig_word;  origp < orig_word + preadd;  origp++)
		{
		if (myupper (*origp))
		    return;
		}
	    }
	}
    if (sufflag > 0)
	{
	origp = orig_word + orig_len - sufadd;
	if (myupper (origp[-1]))
	    {
	    for (  ;  *origp != 0;  origp++)
		{
		if (mylower (*origp))
		    return;
		}
	    }
	else
	    {
	    origp = orig_word + orig_len - sufadd;
	    for (  ;  *origp != 0;  origp++)
		{
		if (myupper (*origp))
		    return;
		}
	    }
	}
    /*
     * The cases are ok.  Put out the word, being careful that the
     * prefix/suffix cases match those in the original, and that the
     * unchanged characters from the original actually match it.
     */
    (void) putchar (' ');
    origp = orig_word + preadd;
    if (myupper (*origp))
	{
	while (--prestrip >= 0)
	    (void) fputs (printichar (*word++), stdout);
	}
    else
	{
	while (--prestrip >= 0)
	    (void) fputs (printichar (mytolower (*word++)), stdout);
	}
    for (prestrip = orig_len - preadd - sufadd;  --prestrip >= 0;  word++)
	(void) fputs (printichar (*origp++), stdout);
    if (origp > orig_word)
	origp--;
    if (myupper (*origp))
	(void) fputs (ichartosstr (word, 0), stdout);
    else
	{
	while (*word)
	    {
	    (void) fputs (printichar (mytolower (*word++)), stdout);
	    }
	}
    /*
     * Now put out the flags
     */
    (void) putchar (hashheader.flagmarker);
    if (preflag > 0)
	(void) putchar (preflag);
    if (sufflag > 0)
	(void) putchar (sufflag);
    }
