#ifndef CFCLASS_H
#define CFCLASS_H

/* Compound file v2.0
 * (C) John Remyn 1992-1994
 * booyman@xs4all.hacktic.nl
 *
 *
 * storage types :
 *   0 - X ( simple byte stream for v1 compatibility )
 *   1 - simple byte stream
 *
 * cf.read:
 * If target == NULL, the required memory is allocated by the read routine. The
 * maximum amount of memory allocated is n bytes.
 * If n==0 and target is NULL the required amount of memory is allocated.
 * if fnam or nr is 0, the file indicated by readnr is read.
 * Every time a file is read, readnr is incremented.
 *
 *
 * error handling:
 *  if an error occurs the errno integer will be != 0. a subsequent call to
 *  errorstr() returns a string with an error message and resets errno.
 */

// class' function definitions in are in cfclass.cpp

struct cf_filelist {
    char name[13];
    unsigned long storsize;
    unsigned long truesize;
    long offset;
    unsigned short int stor;
};                                  // element in list of files

class cfc {
    protected:
    	int handle;
    	struct cf_filelist *file_list;
    	int readnr;
    	int errno;
    	int nroff;                   // nr of files in compound file
    	int version;                 // version of the compound file
    	void closecf( void );        // closes compound file
    	int getnroffile( char *fnam );
    	int readdata( int handle, void *target, int size );
    	char *strupr( char *str );
    	void copyfnam( char *filename );
    	char fnam[13];
    	static char *cf_sigs[2];
    	static char *errstr[9];

    public:
    	cfc( void );
    	// constructor
    	
    	~cfc( void ); 
    	// destructor
    	
    	int open( char *cfnam );        
    	// opens a compound file
    	
    	char *read( char *filename = NULL, long n = 0, char *target = NULL );
    	char *readoffset( char *filename, long offset, long n=0, char *target=NULL );
    	// reads a file, maxsize n, allocates memory if required
    	// increases readnr by 1
    	
    	long size( char *filename = NULL);
    	// returns the size of <filename>, or the file currently pointed to
    	// by readnr
    	
    	int close( void );
    	// closes the comound file
    	
    	int error( void );
        // returns a value not equal to 0 if an error occured
        
    	int nroffiles( void );
    	// returns the number of files in the compound file
    	
    	int tofile( char *filename );
    	// sets readnr to <filename>
    	
    	char *namestr( void );      
    	// returns name of file currently pointed to
    	
    	char *errorstr( void );           
    	// returns pointer to string with error desc.
};

#endif
