/* vis603vdu.c - 18:46 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */

/* From input file "../include/globals.p" */

#include "config.h"
#include "globals.h"

#include "screenio.h"
#include "vdu.h"

#include "tek4010emu.h"

extern Void InitVIS630 (VOID);

/*****************************************************************************/

Void InitVIS603 (VOID)
{
  /* The dialog region will be the top 4 text lines in VT200 mode:
        Line 1 = DVI status line,
        Line 2 = window status line,
        Line 3 = message line,
        Line 4 = command line.
     The window region will be text lines 5 to 24 in VT200 mode.
  */

  InitVIS630();

  /* The following values assume the VIS603 is in VT200 mode.  */

  bottoml = 24;        /* also number of text lines on screen */
  textlinewidth = 72;  /* text characters per line - a guess */

  /* The following values assume it is emulating a Tektronix 4010.
     Note that windowv must be given a value using DVItoVDU's
     coordinate scheme, where top left pixel is (0,0).
  */

  windowv = 125;
  /* approx. height in TEK4010 pixels of 4 text lines
                              i.e. ~ 4 * 780/25 */
  windowh = 0;
  windowht = 745 - windowv;   /* avoid drawing in status line */
  windowwd = 1024;
}
/*InitVIS603 */

/*****************************************************************************/

/* end vis603vdu.c */
