#include <OI/oi.H>			/* CursView.C */
#include <strings.h>		/* for strncmp, strlen */
#define	CURSORS	"/usr/include/X11/cursorfont.h"
void see_cursor(OI_menu_cell* cellp,void *argp,OI_number)
{
	if (cellp->selected()) {
		if (cellp && cellp->app_window() && cellp->app_window()->is_visible())
			cellp->app_window()->set_cursor((int)argp);
	}
}

void populate_menu_with_cursors(OI_menu *mp)
{
	FILE		*fi;
	int		index;
	char		buf[256];
	char		cursor[256];
	OI_menu_cell	*cellp ;

	if (fi = fopen(CURSORS,"r")) {
		mp->suspend_layout();
		while (fgets(buf,sizeof(buf),fi)) {
			if (strncmp(buf,"#define",strlen("#define")))
				continue ;
			sscanf(buf,"%*s %s %d",cursor,&index);
			if (!strcmp(cursor,"XC_num_glyphs"))
				continue ;
			cellp = oi_create_menu_cell(cursor,cursor,see_cursor,(void*)index);
			mp->add_cell(cellp,mp->num_cells());
		}
		mp->resume_layout();
	}
}

int main(int argc,char **argv)
{
	OI_connection	*conp;
	OI_app_window	*wp;
	OI_menu		*mp;

	if (conp = OI_init(&argc,argv,"CursView")) {
		wp = oi_create_app_window("main",1,1," Cursor Previewer");
		wp->set_layout(OI_layout_column);
		mp = oi_create_scroll_menu("cursors",OI_scroll_bar_vertical,20,OI_EXCL_RECT_MENU,0,(OI_cell_spec*)NULL,OI_vertical);
		mp->layout_associated_object(wp,1,1,OI_active);
		populate_menu_with_cursors(mp);
		wp->set_associated_object(conp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
	}
	OI_fini();
}

