 /* *************************************************************************		
 *	Test program for protocol delete on OI_app_window objects
 *	Creates an OI_app_window
 *	Creates two additional app_windows with protocol_delete enabled.
 *	Sets destroy callback for each app window.
 *	Has buttons to map and unmap the windows with protocol_delete enabled
 ****************************************************************************/
#include <OI/oi.H>			/* ProtocolDelete.C */
#include <string.h>

void win_killed(OI_d_tech *p, void*)
{
	p->set_state(OI_not_displayed);
	p->set_loc(p->loc_x(),p->loc_y());	// prevent user positioning after 1st time
	return;
}

void activate(OI_menu_cell *, void *argp, OI_number)
{
			OI_app_window	*wp;

	wp = (OI_app_window*) argp;
	wp->set_state(OI_active);
	return;
}

int main(int argc, char**argv)
{
			OI_connection	*conp;
			OI_app_window	*wp;		// ptr to main app_window
			OI_app_window	*aux_wp;	// ptr to auxiliary app window
			OI_menu		*mp;
		static	OI_cell_spec	win_cells[] = {
				{"options","Options",&activate},
				{"prps","Properties",&activate},
			};
		static	OI_menu_spec	win_mnu = {"win_pd",OI_count(win_cells),&win_cells[0],OI_vertical};
		static	OI_cell_spec	cells[] = {
				{"windows","Windows",NULL,NULL,NULL_PMF,NULL,OI_text_cell,&win_mnu},
			};

	if (conp = OI_init(&argc,argv,"ProtocolDelete")) {
		wp = oi_create_app_window("main",100,50,"ProtocolDelete");
		mp = oi_create_button_menu("mn_menu",OI_count(cells),cells,OI_horizontal);
		wp->set_main_menu(mp);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);

		aux_wp = oi_create_app_window("options",300,200,"Option Window");
		aux_wp->disallow_clip();
		((OI_menu_cell*)(mp->descendant("options")))->change_arg(aux_wp);
		aux_wp->set_protocol_delete(win_killed);
		aux_wp->set_associated_object(wp,OI_def_loc,OI_def_loc,OI_not_displayed);

		aux_wp = oi_create_app_window("prps",300,200,"Property Window");
		aux_wp->disallow_clip();
		((OI_menu_cell*)(mp->descendant("prps")))->change_arg(aux_wp);
		aux_wp->set_protocol_delete(win_killed);
		aux_wp->set_associated_object(wp,OI_def_loc,OI_def_loc,OI_not_displayed);

		OI_begin_interaction();
		OI_fini();
	}
}
