#include <OI/oi.H>
#include <strings.h>

/*
 *	Internationilization
 *	
 *	This program provides an example of how to do customization
 *	of applications for international usage.  With the useage of
 *	language-specific resource files, text items in the application
 *      can appear in the chosen language for the user.
 *
 *	This demonstration uses the "-config" flag to specify the 
 *	resource file for the application.  In an actual installation
 *	the specific resource file for the desired language would 
 *	be installed in /usr/lib/X11/app_defaults
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init
 *			OI_begin_interaction
 *			OI_fini
 *                      OI_count
 *                      OI_fork
 *		- OI_d_tech( 30 )
 *			layout_associated_object
 *			set_associated_object
 *			set_layout
 *		- OI_app_window( 3O )
 *			oi_create_app_window
 *		- OI_button_menu( 3O )
 *			oi_create_button_menu
 *
 */

/*
 *	The function StartNewDemo must be defined before we define the
 *	static cell definitions, else the compiler complains.
 */

void StartNewDemo(OI_menu_cell *);

/* 
 *	These are the cell definitions for each cell in the application.
 *	They are in english, the other langauges will be specified in 
 *	resource files.  Each cell has a name for identification, and an
 *	English text string for the default label.  
 */


OI_cell_spec demoMenuCells[] = {
  {"english", "Start English Demo", (OI_action_fnp)StartNewDemo},
  {"german", "Start German Demo", (OI_action_fnp)StartNewDemo},
  {"french", "Start French Demo", (OI_action_fnp)StartNewDemo},
  {"spanish", "Start Spanish Demo", (OI_action_fnp)StartNewDemo},
  {"kanji", "Start Kanji Demo", (OI_action_fnp)StartNewDemo},
  {"quit", "Quit", (OI_action_fnp)OI_end_interaction},
};

OI_cell_spec numberMenuCells[] = {
  {"one", "One"},
  {"two", "Two"},
  {"three", "Three"},
  {"four", "Four"},
  {"five", "Five"},
  {"six", "Six"},
  {"seven", "Seven"},
  {"eight", "Eight"},
  {"nine", "Nine"},
  {"ten", "Ten"},
};



/*
 *	main
 *
 *	This program demonstrates
 *		- initializing OI, opening a connection to the server
 *		- create the application window.
 *		- creating the buttons and text fields
 */
void
main (int argc, char **argv)
{
	OI_connection	*conp;			/* the connection to the server */
	OI_app_window	*appWindow;		/* the enclosing app window */
	OI_button_menu  *controlMenu;           /* control menu */
	OI_button_menu  *numberMenu;            /* number menu */
	OI_entry_field  *field;                 /* Entry field */

	/*
	 *	Open a connection to the server.
	 */
	if (conp = OI_init(&argc, argv, "internat", "Internat"))
	    {
		/*
		 *	Create the main window.
		 *	Make it column layout.
		 */
		appWindow = oi_create_app_window("mainWin", 1, 1, "International Demo");
		appWindow->set_layout(OI_layout_column);

		/*
		 *	Create the two button menus and lay them out side by side
		 *	The function OI_count counts the cells in the static cell definition.
		 */
		controlMenu = oi_create_button_menu("controlMenu", OI_count(demoMenuCells), demoMenuCells, OI_VERTICAL, NULL);
		controlMenu->layout_associated_object(appWindow, (OI_number) 0, (OI_number) 0, OI_ACTIVE);
		numberMenu = oi_create_button_menu("controlMenu", OI_count(numberMenuCells), numberMenuCells, OI_VERTICAL, NULL);
		numberMenu->layout_associated_object(appWindow, 1, 0, OI_ACTIVE);

		/* 
		 *  Create an entry field and lay it out below the button menus 
		 */

		field = oi_create_entry_field("helpField", 10, "Help: ", NULL, 20);
		field->layout_associated_object(appWindow, 0, 1, OI_ACTIVE);
		/*
		 *	display main window, then begin interaction.
		 */
		appWindow->set_associated_object(conp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE);
		OI_begin_interaction();
	}

	/*
	 * Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
}

void StartNewDemo(OI_menu_cell *cell)
{

  char command[256];  /* Character string for forked command */
  char **common_argv;
  int i, common_argc;
  
  /* 
   * create the command string for invoked command.  
   * Append OI_common_argv to the command string so that the
   * invoked process has the same attributes as the original
   * one.
   *  
   * Also, invoke command with the correct -language flag to
   * find the correct text strings file for the desired language
   *
   */

  strcpy(command, "internat ");
  
  common_argc = OI_common_argc();
  common_argv = OI_common_argv();

  for (i = 0; i < common_argc; i++)
    {
      strcat(command, common_argv[i]);
      strcat(command, " ");
    }
  
  strcat(command, "-conf internat.conf -language ");
  strcat(command, cell->name());

  strcat(command, " &");

  /* Invoke the command */
  OI_fork(command);
}
