#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/***************************************************************************
 *
 * Function:    sscanf
 *
 * Description:
 *     Scan the input string for the arguments based upon the input format.
 *
 * Entry:
 *     pszString  - Pointer to the input string to be scanned
 *     pszFormat  - Pointer to the input format
 *     args       - Pointers to the argument addresses for the values scanned.
 *
 * Returns:
 *     The number of characters scanned.
 */

int sscanf (const char *pszString, const char *pszFormat, ...)
    {
    va_list  vaArgs;
    FILE     fdString;
    int      nAnswer;
    FUNC_ENTRY ("sscanf");
/*
 *  Construct the "file" to hold the input string buffer
 */
    fdString._flag = _IOREAD | _IOSTRG | _IOMYBUF;
    fdString._ptr  =
    fdString._base = (char *) pszString;
    fdString._cnt  = strlen (pszString);
    fdString._file = _NFILE;
/*
 *  Scan the input for the data
 */
    va_start (vaArgs, pszFormat);
    nAnswer = _input (&fdString, pszFormat, vaArgs);
    va_end (vaArgs);
/*
 *  Return to the caller.
 */
    FUNC_EXIT ("sscanf");
    return (nAnswer);
    }
