#include <stdio.h>
#include "file2.h"
#include <malloc.h>
#include "internal.h"
#include <trace.h>

/************************************************************************
 *
 * Function:    _getbuf
 *
 * Description: This routine will allocate a buffer for the indicated file.
 *
 * Input:       stream - a pointer to the file to be allocated
 *
 * Output:      none.
 */

void _getbuf (FILE *stream)
    {
    FILE2 *stream2 = file2p (stream);
    FUNC_ENTRY ("_getbuf");
/*
 *  Try to allocate a large buffer
 */
    stream->_base = malloc (BUFSIZ);
    if (stream->_base != NULL)
        {
	stream->_flag |= _IOMYBUF;
	stream2->_bufsiz = BUFSIZ;
        }
/*
 *  A buffer could not be allocated. Use the single character buffer
 */
    else
        {
	stream->_flag |= _IONBF;
	stream->_base = &(stream2->_charbuf);
	stream2->_bufsiz = 1;
        }
/*
 *  Reset the pointers to the information
 */
    stream->_ptr = stream->_base;
    stream->_cnt = 0;
    FUNC_EXIT ("_getbuf");
    }
