
enum { view_brief, view_full, view_long, view_info, view_nothing };
enum { show_dates, show_perm };
enum { brief_mode, full_mode, long_mode };

typedef struct {
    dir_list dir;		/* Directory contents */
    int      view_type;		/* type of view */
    int      active;		/* If panel is currently selected */
    char     cwd [MAXPATHLEN];	/* Current Working Directory */
    int      count;		/* Number of files in dir structure */
    int      lines;		/* Panel Lines */
    int      cols;		/* Panel columns */
    int      marked;		/* Count of marked file */
    long int total;		/* Bytes in marked files */
    int      top_file;		/* The file showed on the top of the panel */
    int      selected;		/* Index to the selected file */
    int      is_status;		/* Is the panel a status display? */
    sortfn   *sort_type;	/* Sort type */
    WINDOW   *win_file;		/* Where the files are listed */
    WINDOW   *win_mini;		/* The mini-info */
    
    WINDOW   *small_frame;	/* Default small frame */
    WINDOW   *big_frame;	/* For long display */

    struct   stat dir_stat;	/* Stat of current dir: used by execute () */
} Panel;

void init_panel (Panel *panel, int x1, int y1, int x2, int y2);
void paint_panel (Panel *panel);
void panel_refresh (Panel *panel);
void set_attr (Panel *panel, int hilight, int marked);
void Xtry_to_select (Panel *panel, char *name);

extern int show_mini_info;

extern file_entry *selection;

extern int fast_reload;

/*#define ITEMS(p) ((p)->view_type == view_brief ? (p)->lines *2 : (p)->lines)
*/
/* The return value of panel_reload */
#define CHANGED 1

#define PANEL_ISVIEW(p) (p->view_type == view_brief || \
			 p->view_type == view_full  || \
			 p->view_type == view_long)

#define VIEW_DISABLED 0x80
void set_colors (Panel *panel);
void repaint_file (Panel *panel, int file_index);
void display_mini_info (Panel *panel);
void panel_reload (Panel *panel);
void paint_dir (Panel *panel);
void show_dir (Panel *panel);

void brief_frame (Panel *panel);
void full_frame (Panel *panel);
void long_frame (Panel *panel);
