------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             S E M _ E V A L                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.12 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains various subprograms involved in compile time
--  evaluation of expressions and checks for staticness of expressions
--  and types.

with Types; use Types;

package Sem_Eval is
   function Is_Static_Subtype (Typ : Entity_Id) return Boolean;
   --  Determines whether a subtype fits the definition of an Ada static
   --  subtype as given in LRM 4.9.

   function Expr_Value (N : Node_Id) return Uint;
   --  Returns the folded value of the expression. This function is called
   --  in instances which it has already been determined that the expression
   --  has been constant folded.

   procedure Eval_Arithmetic_Op (N : Node_Id);
   --  Eval for binary operators: +, -, *, /, **, mod, rem

   procedure Eval_Attribute (N : Node_Id);

   procedure Eval_Character_Literal (N : Node_Id);
   pragma Inline (Eval_Character_Literal);

   procedure Eval_Concatenation (N : Node_Id);

   procedure Eval_Entity_Name (N : Node_Id);
   --  Eval for identifiers and expanded names

   procedure Eval_Integer_Literal (N : Node_Id);
   pragma Inline (Eval_Integer_Literal);

   procedure Eval_Logical_Op (N : Node_Id);
   --  Eval for operators: and, or, xor

   procedure Eval_Membership_Op (N : Node_Id);
   --  Eval for operators: in, not in

   procedure Eval_Op_Expon (N : Node_Id);

   procedure Eval_Op_Not (N : Node_Id);

   procedure Eval_Qualified_Expression (N : Node_Id);
   pragma Inline (Eval_Qualified_Expression);

   procedure Eval_Real_Literal (N : Node_Id);
   pragma Inline (Eval_Real_Literal);

   procedure Eval_Relational_Op (N : Node_Id);
   --  Eval for operators: =, /=, <, <=, >, >=

   procedure Eval_Shift (N : Node_Id);
   --  Eval for intrinsic shift functions

   procedure Eval_Short_Circuit (N : Node_Id);
   --  Eval for short circuit forms: and then, or else

   procedure Eval_String_Literal (N : Node_Id);
   pragma Inline (Eval_String_Literal);

   procedure Eval_Type_Conversion (N : Node_Id);
   --  Eval for type conversions transforms static discrete conversions into
   --  the appropriate literal node which is marked as static in Ada9X mode.

   procedure Eval_Unary_Op (N : Node_Id);
   --  Eval for unary operators: +, -, abs

end Sem_Eval;
