------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                F N A M E                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.11 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the association between source file names and
--  unit names as defined in package Uname.

with Types; use Types;

package Fname is

   --  Note: this package spec does not depend on the Uname spec in the Ada
   --  sense, but the comments and description of the semantics do depend on
   --  the conventions established by Uname, which explains the "with Uname".

   ---------------------------
   -- File Name Conventions --
   ---------------------------

   --  GNAT requires that there be a one to one correspondence between source
   --  file names (as used in the Osint package interface) and unit names as
   --  defined by the Uname package. This correspondence is defined by the
   --  two subprograms defined here in the Fname package.

   --  The body of this package is potentially system dependent, since file
   --  naming conventions do differ from operating system to operating system.
   --  However, the code in the body of Fname does not typically require any
   --  operating system interface, and furthermore, we choose a convention
   --  that is likely to be widely implementable, and certainly is one that
   --  can be shared between Unix, DOS, NT, Mac OS and OS/2.

   --  Since we do expect this convention to be followed widely, and since
   --  Osint depends on the convention, it is described here in the Spec.
   --  However, no unit (other than Osint) in any way depends on the choices
   --  described here.

   --  Unit names are the Ada names, with all lower case letters (except for
   --  the use of upper case letters for encoding and for internal names,
   --  see package Namet for further details), and a suffix that is either
   --  that is either %b or %s for bodies and specs respectively. This is the
   --  convention described and implemented in package Uname.

   --  Source file names are obtained by taking the decoded unit name (i.e.
   --  with Uhh and Whhhh sequences decoded to the ESC sequence or literal
   --  upper half character), excluding the %b or %s, and replacing the
   --  periods with minus signs. The extension is either .ads for a spec,
   --  or .adb for a body (or subunit).

   --  Examples of these rules are:

   --    Unit                           Unit name           File name

   --    Packge_Scan (spec)             packge_scan%s      packge_scan.ads
   --    Packge_Scan (body)             packge_scan%b      packge_scan.adb
   --    Scn.Nlit (subunit)             scn.nlit%b         scn-nlit.adb
   --    Child.Pkg (child unit spec)    child.pkg%s        child-pkg.ads
   --    Child.Pkg (child unit body)    child.pkg%b        child-pkg.adb
   --    Xyz.Arg.Lms (child subunit)    xyz.arg.lms%b      xyz-arg-lms.adb
   --    Accent?d (spec)                accentUc1d         accent?d.ads

   --  In the last example, ? stands for the graphic character that is
   --  displayed for the character UC_A_Acute (i.e. an upper case accented A).

   --  Note that the file name does *not* include the directory name. The
   --  management of directories is provided by Osint, and full file names
   --  are used only for error message purposes within GNAT itself.

   -------------------------
   -- File Name Crunching --
   -------------------------

   --  The rules described above give the file names that are generated if
   --  there is no restriction on the length of file names. However, the
   --  Get_File_Name routine will, if necessary according to the value in
   --  Opt.Maximum_File_Name_Length, crunch these file names down to this
   --  maximum value. For details of the crunching algorithm, see Krunch.

   -----------------
   -- Subprograms --
   -----------------

   type Expected_Unit_Type is (Expect_Body, Expect_Spec, Unknown);
   --  Return value from Get_Expected_Unit_Type

   function Get_Expected_Unit_Type (Fname : File_Name_Type)
     return Expected_Unit_Type;
   --  If possible, determine whether the given file name corresponds to a unit
   --  that is a spec or body (e.g. by examining the extension). If this cannot
   --  be determined with the file naming conventions in use, then the returned
   --  value is set to Unknown.

   function Get_File_Name (Uname : Unit_Name_Type) return File_Name_Type;
   --  This function returns the file name that corresponds to a given unit
   --  name. The caller is responsible for ensuring that the unit name meets
   --  the requirements given in package Uname and described above.

end Fname;
