/*
 * mandb.c: used to create and initialise global man database.
 *  
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#define MAN_MAIN 	/* to not define config_file */
#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "config.h"
#include "mydbm.h"
#include "statdir.h"
#include "manp.h"
#include "dbver.h"

void ver(void);

char *prognam;
int debug = 0;
short quiet = 0;
short create_user = 0;
short dups = DUPS;
MYDBM_FILE dbf;
char *manp;
char *database;

void usage(void)
{
	printf("usage: %s [ -dqru ] [ -h ]\n", prognam);
	printf(	"\t\t-d: produce debugging info.\n"
		"\t\t-q: work quietly, except for 'bogus' warning.\n"
		"\t\t-r: reverse the 'duplicates' flag - default: %s.\n"
		"\t\t-u: create user databases, even with write access to global.\n"
		"\t\t-h: this usage message.\n", dups ? "don't add" : "add");
}

short create_local(void)
{
	short amount;
	
	if (!quiet)
		printf("Creating user database: %s\n", database);
	if ( (dbf = MYDBM_OPEN(database)) == NULL){
		fprintf(stderr, "%s: create_local: ", prognam);
		perror(database);
		exit(1);
	}

	dbver_wr(dbf);
	
	amount = check_mandirs(0);
	MYDBM_CLOSE(dbf);
	return amount;
}
	
int main(int argc, char *argv[])
{
	int c;
	short amount = 0;
	char *c1, *user;
	
	prognam = *argv;

	while ((c = getopt(argc, argv, "druqhV")) != -1){

		switch (c){

			case 'd':
				debug++;
				break;
			case 'q':
				quiet++;
				break;
			case 'r':
				dups = !dups;
				break;
			case 'u':
				create_user++;
				break;
			case 'V':
				ver();
				exit(0);
			case 'h':
				usage();
				exit(0);
			default:
				usage();
				exit(1);
		}
	}

	manp = manpath(quiet);
	user = strdup(DB);
	*(strrchr(user, '/')) = '\0';

	/*
	 * Check access rights of invoking user. Would they be allowed to 
	 * either write to the database, or if it doesn't exist, create in 
	 * the directory that it lives?
	 */

	if (!create_user && (access(DB, W_OK) == 0 || access(user, W_OK) == 0) ) {
		if (!quiet)
			puts("Creating global database: " DB);
		if ( (dbf = MYDBM_OPEN(DB)) == NULL){
			fprintf(stderr, "%s: main: ", prognam);
			perror(DB);
			exit(1);
		}

	/* give the db a version */

		dbver_wr(dbf);
		
		amount = check_mandirs(1);

/*		if (!debug){
			if (!quiet)
				puts("reorganising database if gdbm");
			MYDBM_REORG(dbf); 
		}
 */
		MYDBM_CLOSE(dbf);
	
	} else if ( (user = get_userdb_list()) != NULL) {
		if (setreuid(geteuid(), getuid()) == -1) {
			fputs("Problems changing to real uid (you).\n",
			  stderr);
			exit(1);
		}
		while ( (c1 = strchr(user, ':')) != NULL) {
			*c1 = '\0';
			database = ++c1;
			amount += create_local();
		}
		database = user;
		amount += create_local();
		free(--user);
	} else {
		if (!quiet)
			puts("No access to global database and no user databases: nothing to do.");
		exit(0);
	}	

	if (!quiet)
		printf("%d man directories changed\n", amount);

	return 0;
}
