#ifndef _IFS_FS_I
#define _IFS_FS_I

/*
 * Inheriting file system inode data in memory
 */


#include <linux/ifs_fs_param.h>


struct ifs_inode_info {
	struct inode * volatile layer[IFS_MAX_LAYERS];
	struct inode *parent; /* parent chain is kept in-core */
	struct inode *next,*prev; /* IFS' own lookup list */
	struct wait_queue *pop_wait; /* lock inode while popping a file */
	int pop_lock;
	struct wait_queue *trans_wait;
	int trans_lock;
	uid_t val_uid; /* validated permission data */
	gid_t val_gid;
	umode_t val_mode;
	size_t val_size;
};

#endif
