// Code generated by running "go generate". DO NOT EDIT.

// Copyright 2017 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cgen

const baseAllImplC = "" +
	"#ifndef WUFFS_INCLUDE_GUARD__BASE\n#define WUFFS_INCLUDE_GUARD__BASE\n\n#if defined(WUFFS_IMPLEMENTATION) && !defined(WUFFS_CONFIG__MODULES)\n#define WUFFS_CONFIG__MODULES\n#define WUFFS_CONFIG__MODULE__BASE\n#endif\n\n// !! WUFFS MONOLITHIC RELEASE DISCARDS EVERYTHING ABOVE.\n\n// !! INSERT base/copyright\n\n#include <stdbool.h>\n#include <stdint.h>\n#include <string.h>\n\n// GCC does not warn for unused *static inline* functions, but clang does.\n#ifdef __clang__\n#pragma clang diagnostic push\n#pragma clang diagnostic ignored \"-Wunused-function\"\n#endif\n\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n// !! INSERT base/all-public.h.\n\n#ifdef __cplusplus\n}  // extern \"C\"\n#endif\n\n#ifdef __clang__\n#pragma clang diagnostic pop\n#endif\n\n// WUFFS C HEADER ENDS HERE.\n#ifdef WUFFS_IMPLEMENTATION\n\n// GCC does not warn for unused *static inline* functions, but clang does.\n#ifdef __clang__\n#pragma clang diagnostic push\n#pragma clang diagnostic ignored \"-Wunused-function\"\n#endif\n\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n// !! INSERT base/all-privat" +
	"e.h.\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE)\n\nconst uint8_t wuffs_base__low_bits_mask__u8[9] = {\n    0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF,\n};\n\nconst uint16_t wuffs_base__low_bits_mask__u16[17] = {\n    0x0000, 0x0001, 0x0003, 0x0007, 0x000F, 0x001F, 0x003F, 0x007F, 0x00FF,\n    0x01FF, 0x03FF, 0x07FF, 0x0FFF, 0x1FFF, 0x3FFF, 0x7FFF, 0xFFFF,\n};\n\nconst uint32_t wuffs_base__low_bits_mask__u32[33] = {\n    0x00000000, 0x00000001, 0x00000003, 0x00000007, 0x0000000F, 0x0000001F,\n    0x0000003F, 0x0000007F, 0x000000FF, 0x000001FF, 0x000003FF, 0x000007FF,\n    0x00000FFF, 0x00001FFF, 0x00003FFF, 0x00007FFF, 0x0000FFFF, 0x0001FFFF,\n    0x0003FFFF, 0x0007FFFF, 0x000FFFFF, 0x001FFFFF, 0x003FFFFF, 0x007FFFFF,\n    0x00FFFFFF, 0x01FFFFFF, 0x03FFFFFF, 0x07FFFFFF, 0x0FFFFFFF, 0x1FFFFFFF,\n    0x3FFFFFFF, 0x7FFFFFFF, 0xFFFFFFFF,\n};\n\nconst uint64_t wuffs_base__low_bits_mask__u64[65] = {\n    0x0000000000000000, 0x0000000000000001, 0x0000000000000003,\n    0x0000000000000007, 0x00000" +
	"0000000000F, 0x000000000000001F,\n    0x000000000000003F, 0x000000000000007F, 0x00000000000000FF,\n    0x00000000000001FF, 0x00000000000003FF, 0x00000000000007FF,\n    0x0000000000000FFF, 0x0000000000001FFF, 0x0000000000003FFF,\n    0x0000000000007FFF, 0x000000000000FFFF, 0x000000000001FFFF,\n    0x000000000003FFFF, 0x000000000007FFFF, 0x00000000000FFFFF,\n    0x00000000001FFFFF, 0x00000000003FFFFF, 0x00000000007FFFFF,\n    0x0000000000FFFFFF, 0x0000000001FFFFFF, 0x0000000003FFFFFF,\n    0x0000000007FFFFFF, 0x000000000FFFFFFF, 0x000000001FFFFFFF,\n    0x000000003FFFFFFF, 0x000000007FFFFFFF, 0x00000000FFFFFFFF,\n    0x00000001FFFFFFFF, 0x00000003FFFFFFFF, 0x00000007FFFFFFFF,\n    0x0000000FFFFFFFFF, 0x0000001FFFFFFFFF, 0x0000003FFFFFFFFF,\n    0x0000007FFFFFFFFF, 0x000000FFFFFFFFFF, 0x000001FFFFFFFFFF,\n    0x000003FFFFFFFFFF, 0x000007FFFFFFFFFF, 0x00000FFFFFFFFFFF,\n    0x00001FFFFFFFFFFF, 0x00003FFFFFFFFFFF, 0x00007FFFFFFFFFFF,\n    0x0000FFFFFFFFFFFF, 0x0001FFFFFFFFFFFF, 0x0003FFFFFFFFFFFF,\n    0x0007FFFFFFFFFFFF, 0x000FF" +
	"FFFFFFFFFFF, 0x001FFFFFFFFFFFFF,\n    0x003FFFFFFFFFFFFF, 0x007FFFFFFFFFFFFF, 0x00FFFFFFFFFFFFFF,\n    0x01FFFFFFFFFFFFFF, 0x03FFFFFFFFFFFFFF, 0x07FFFFFFFFFFFFFF,\n    0x0FFFFFFFFFFFFFFF, 0x1FFFFFFFFFFFFFFF, 0x3FFFFFFFFFFFFFFF,\n    0x7FFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF,\n};\n\n// !! INSERT wuffs_base__status strings.\n\n// !! INSERT base/image-impl.c.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE)\n\n#ifdef __cplusplus\n}  // extern \"C\"\n#endif\n\n#ifdef __clang__\n#pragma clang diagnostic pop\n#endif\n\n#endif  // WUFFS_IMPLEMENTATION\n\n// !! WUFFS MONOLITHIC RELEASE DISCARDS EVERYTHING BELOW.\n\n#endif  // WUFFS_INCLUDE_GUARD__BASE\n" +
	""

const baseImageImplC = "" +
	"// ---------------- Images\n\nconst uint32_t wuffs_base__pixel_format__bits_per_channel[16] = {\n    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,\n    0x08, 0x0A, 0x0C, 0x10, 0x18, 0x20, 0x30, 0x40,\n};\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__copy_1_1(wuffs_base__slice_u8 dst,\n                                     wuffs_base__slice_u8 dst_palette,\n                                     wuffs_base__slice_u8 src) {\n  return wuffs_base__slice_u8__copy_from_slice(dst, src);\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__copy_3_1(wuffs_base__slice_u8 dst,\n                                     wuffs_base__slice_u8 dst_palette,\n                                     wuffs_base__slice_u8 src) {\n  if (dst_palette.len != 1024) {\n    return 0;\n  }\n  size_t dst_len3 = dst.len / 3;\n  size_t len = dst_len3 < src.len ? dst_len3 : src.len;\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n  size_t n = len;\n\n  // N is the loop unroll count.\n  const int N = 4;\n\n  // The comparison in the while condition is \">\", not \">=\", be" +
	"cause with \">=\",\n  // the last 4-byte store could write past the end of the dst slice.\n  //\n  // Each 4-byte store writes one too many bytes, but a subsequent store will\n  // overwrite that with the correct byte. There is always another store,\n  // whether a 4-byte store in this loop or a 1-byte store in the next loop.\n  while (n > N) {\n    wuffs_base__store_u32le(\n        d + (0 * 3),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[0]) * 4)));\n    wuffs_base__store_u32le(\n        d + (1 * 3),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[1]) * 4)));\n    wuffs_base__store_u32le(\n        d + (2 * 3),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[2]) * 4)));\n    wuffs_base__store_u32le(\n        d + (3 * 3),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[3]) * 4)));\n\n    s += 1 * N;\n    d += 3 * N;\n    n -= (size_t)(1 * N);\n  }\n\n  while (n >= 1) {\n    uint32_t color =\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[0]) * 4));\n    d[0" +
	"] = (uint8_t)(color >> 0);\n    d[1] = (uint8_t)(color >> 8);\n    d[2] = (uint8_t)(color >> 16);\n\n    s += 1 * 1;\n    d += 3 * 1;\n    n -= (size_t)(1 * 1);\n  }\n\n  return len;\n}\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__copy_4_1(wuffs_base__slice_u8 dst,\n                                     wuffs_base__slice_u8 dst_palette,\n                                     wuffs_base__slice_u8 src) {\n  if (dst_palette.len != 1024) {\n    return 0;\n  }\n  size_t dst_len4 = dst.len / 4;\n  size_t len = dst_len4 < src.len ? dst_len4 : src.len;\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n  size_t n = len;\n\n  // N is the loop unroll count.\n  const int N = 4;\n\n  while (n >= N) {\n    wuffs_base__store_u32le(\n        d + (0 * 4),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[0]) * 4)));\n    wuffs_base__store_u32le(\n        d + (1 * 4),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[1]) * 4)));\n    wuffs_base__store_u32le(\n        d + (2 * 4),\n        wuffs_base__load_u32le(dst_palette.ptr + (" +
	"(uint32_t)(s[2]) * 4)));\n    wuffs_base__store_u32le(\n        d + (3 * 4),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[3]) * 4)));\n\n    s += 1 * N;\n    d += 4 * N;\n    n -= (size_t)(1 * N);\n  }\n\n  while (n >= 1) {\n    wuffs_base__store_u32le(\n        d + (0 * 4),\n        wuffs_base__load_u32le(dst_palette.ptr + ((uint32_t)(s[0]) * 4)));\n\n    s += 1 * 1;\n    d += 4 * 1;\n    n -= (size_t)(1 * 1);\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__swap_rgbx_bgrx(wuffs_base__slice_u8 dst,\n                                           wuffs_base__slice_u8 src) {\n  size_t len4 = (dst.len < src.len ? dst.len : src.len) / 4;\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n\n  size_t n = len4;\n  while (n--) {\n    uint8_t b0 = s[0];\n    uint8_t b1 = s[1];\n    uint8_t b2 = s[2];\n    uint8_t b3 = s[3];\n    d[0] = b2;\n    d[1] = b1;\n    d[2] = b0;\n    d[3] = b3;\n    s += 4;\n    d += 4;\n  }\n  return len4 * 4;\n}\n\nwuffs_base__status  //\nwuffs_base__pixel_swizzler__prepare(wuffs_base__pixel_s" +
	"wizzler* p,\n                                    wuffs_base__pixel_format dst_format,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_format,\n                                    wuffs_base__slice_u8 src_palette) {\n  if (!p) {\n    return wuffs_base__error__bad_receiver;\n  }\n\n  // TODO: support many more formats.\n\n  uint64_t (*func)(wuffs_base__slice_u8 dst, wuffs_base__slice_u8 dst_palette,\n                   wuffs_base__slice_u8 src) = NULL;\n\n  switch (src_format) {\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY:\n      switch (dst_format) {\n        case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL:\n        case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_PREMUL:\n        case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY:\n          if (wuffs_base__slice_u8__copy_from_slice(dst_palette, src_palette) !=\n              1024) {\n            break;\n          }\n          func = wuffs_base__pixel_swizzler__copy_1_1;\n       " +
	"   break;\n        case WUFFS_BASE__PIXEL_FORMAT__BGR:\n          if (wuffs_base__slice_u8__copy_from_slice(dst_palette, src_palette) !=\n              1024) {\n            break;\n          }\n          func = wuffs_base__pixel_swizzler__copy_3_1;\n          break;\n        case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n        case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n        case WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY:\n          if (wuffs_base__slice_u8__copy_from_slice(dst_palette, src_palette) !=\n              1024) {\n            break;\n          }\n          func = wuffs_base__pixel_swizzler__copy_4_1;\n          break;\n        case WUFFS_BASE__PIXEL_FORMAT__RGB:\n          if (wuffs_base__pixel_swizzler__swap_rgbx_bgrx(dst_palette,\n                                                         src_palette) != 1024) {\n            break;\n          }\n          func = wuffs_base__pixel_swizzler__copy_3_1;\n          break;\n        case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n        case WUFFS_BASE__PIXEL_FORMAT__RGBA_PR" +
	"EMUL:\n        case WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY:\n          if (wuffs_base__pixel_swizzler__swap_rgbx_bgrx(dst_palette,\n                                                         src_palette) != 1024) {\n            break;\n          }\n          func = wuffs_base__pixel_swizzler__copy_4_1;\n          break;\n        default:\n          break;\n      }\n      break;\n\n    default:\n      break;\n  }\n\n  p->private_impl.func = func;\n  return func ? NULL : wuffs_base__error__unsupported_option;\n}\n\nuint64_t  //\nwuffs_base__pixel_swizzler__swizzle_interleaved(\n    const wuffs_base__pixel_swizzler* p,\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src) {\n  if (p && p->private_impl.func) {\n    return (*(p->private_impl.func))(dst, dst_palette, src);\n  }\n  return 0;\n}\n" +
	""

const baseCorePrivateH = "" +
	"static inline wuffs_base__empty_struct  //\nwuffs_base__ignore_status(wuffs_base__status z) {\n  return wuffs_base__make_empty_struct();\n}\n\n// WUFFS_BASE__MAGIC is a magic number to check that initializers are called.\n// It's not foolproof, given C doesn't automatically zero memory before use,\n// but it should catch 99.99% of cases.\n//\n// Its (non-zero) value is arbitrary, based on md5sum(\"wuffs\").\n#define WUFFS_BASE__MAGIC ((uint32_t)0x3CCB6C71)\n\n// WUFFS_BASE__DISABLED is a magic number to indicate that a non-recoverable\n// error was previously encountered.\n//\n// Its (non-zero) value is arbitrary, based on md5sum(\"disabled\").\n#define WUFFS_BASE__DISABLED ((uint32_t)0x075AE3D2)\n\n// Denote intentional fallthroughs for -Wimplicit-fallthrough.\n//\n// The order matters here. Clang also defines \"__GNUC__\".\n#if defined(__clang__) && defined(__cplusplus) && (__cplusplus >= 201103L)\n#define WUFFS_BASE__FALLTHROUGH [[clang::fallthrough]]\n#elif !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 7)\n#define WUFFS_BAS" +
	"E__FALLTHROUGH __attribute__((fallthrough))\n#else\n#define WUFFS_BASE__FALLTHROUGH\n#endif\n\n// Use switch cases for coroutine suspension points, similar to the technique\n// in https://www.chiark.greenend.org.uk/~sgtatham/coroutines.html\n//\n// We use trivial macros instead of an explicit assignment and case statement\n// so that clang-format doesn't get confused by the unusual \"case\"s.\n#define WUFFS_BASE__COROUTINE_SUSPENSION_POINT_0 case 0:;\n#define WUFFS_BASE__COROUTINE_SUSPENSION_POINT(n) \\\n  coro_susp_point = n;                            \\\n  WUFFS_BASE__FALLTHROUGH;                        \\\n  case n:;\n\n#define WUFFS_BASE__COROUTINE_SUSPENSION_POINT_MAYBE_SUSPEND(n) \\\n  if (!status) {                                                \\\n    goto ok;                                                    \\\n  } else if (*status != '$') {                                  \\\n    goto exit;                                                  \\\n  }                                                             \\\n  coro_susp_point" +
	" = n;                                          \\\n  goto suspend;                                                 \\\n  case n:;\n\n// Clang also defines \"__GNUC__\".\n#if defined(__GNUC__)\n#define WUFFS_BASE__LIKELY(expr) (__builtin_expect(!!(expr), 1))\n#define WUFFS_BASE__UNLIKELY(expr) (__builtin_expect(!!(expr), 0))\n#else\n#define WUFFS_BASE__LIKELY(expr) (expr)\n#define WUFFS_BASE__UNLIKELY(expr) (expr)\n#endif\n\n// The helpers below are functions, instead of macros, because their arguments\n// can be an expression that we shouldn't evaluate more than once.\n//\n// They are static, so that linking multiple wuffs .o files won't complain about\n// duplicate function definitions.\n//\n// They are explicitly marked inline, even if modern compilers don't use the\n// inline attribute to guide optimizations such as inlining, to avoid the\n// -Wunused-function warning, and we like to compile with -Wall -Werror.\n\n" +
	"" +
	"// ---------------- Numeric Types\n\nstatic inline uint8_t  //\nwuffs_base__load_u8be(uint8_t* p) {\n  return p[0];\n}\n\nstatic inline uint16_t  //\nwuffs_base__load_u16be(uint8_t* p) {\n  return (uint16_t)(((uint16_t)(p[0]) << 8) | ((uint16_t)(p[1]) << 0));\n}\n\nstatic inline uint16_t  //\nwuffs_base__load_u16le(uint8_t* p) {\n  return (uint16_t)(((uint16_t)(p[0]) << 0) | ((uint16_t)(p[1]) << 8));\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u24be(uint8_t* p) {\n  return ((uint32_t)(p[0]) << 16) | ((uint32_t)(p[1]) << 8) |\n         ((uint32_t)(p[2]) << 0);\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u24le(uint8_t* p) {\n  return ((uint32_t)(p[0]) << 0) | ((uint32_t)(p[1]) << 8) |\n         ((uint32_t)(p[2]) << 16);\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u32be(uint8_t* p) {\n  return ((uint32_t)(p[0]) << 24) | ((uint32_t)(p[1]) << 16) |\n         ((uint32_t)(p[2]) << 8) | ((uint32_t)(p[3]) << 0);\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u32le(uint8_t* p) {\n  return ((uint32_t)(p[0]) << 0) | ((uint32_t)(p[1]" +
	") << 8) |\n         ((uint32_t)(p[2]) << 16) | ((uint32_t)(p[3]) << 24);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u40be(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 32) | ((uint64_t)(p[1]) << 24) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 8) |\n         ((uint64_t)(p[4]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u40le(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u48be(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 40) | ((uint64_t)(p[1]) << 32) |\n         ((uint64_t)(p[2]) << 24) | ((uint64_t)(p[3]) << 16) |\n         ((uint64_t)(p[4]) << 8) | ((uint64_t)(p[5]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u48le(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32) | ((uint64_t)(p[5]) <<" +
	" 40);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u56be(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 48) | ((uint64_t)(p[1]) << 40) |\n         ((uint64_t)(p[2]) << 32) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 16) | ((uint64_t)(p[5]) << 8) |\n         ((uint64_t)(p[6]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u56le(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32) | ((uint64_t)(p[5]) << 40) |\n         ((uint64_t)(p[6]) << 48);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u64be(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 56) | ((uint64_t)(p[1]) << 48) |\n         ((uint64_t)(p[2]) << 40) | ((uint64_t)(p[3]) << 32) |\n         ((uint64_t)(p[4]) << 24) | ((uint64_t)(p[5]) << 16) |\n         ((uint64_t)(p[6]) << 8) | ((uint64_t)(p[7]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u64le(uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8" +
	") |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32) | ((uint64_t)(p[5]) << 40) |\n         ((uint64_t)(p[6]) << 48) | ((uint64_t)(p[7]) << 56);\n}\n\n" +
	"" +
	"// --------\n\nstatic inline void  //\nwuffs_base__store_u8be(uint8_t* p, uint8_t x) {\n  p[0] = x;\n}\n\nstatic inline void  //\nwuffs_base__store_u16be(uint8_t* p, uint16_t x) {\n  p[0] = (uint8_t)(x >> 8);\n  p[1] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u16le(uint8_t* p, uint16_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n}\n\nstatic inline void  //\nwuffs_base__store_u24be(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 16);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u24le(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n}\n\nstatic inline void  //\nwuffs_base__store_u32be(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 24);\n  p[1] = (uint8_t)(x >> 16);\n  p[2] = (uint8_t)(x >> 8);\n  p[3] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u32le(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x" +
	" >> 16);\n  p[3] = (uint8_t)(x >> 24);\n}\n\nstatic inline void  //\nwuffs_base__store_u40be(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 32);\n  p[1] = (uint8_t)(x >> 24);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 8);\n  p[4] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u40le(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n}\n\nstatic inline void  //\nwuffs_base__store_u48be(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 40);\n  p[1] = (uint8_t)(x >> 32);\n  p[2] = (uint8_t)(x >> 24);\n  p[3] = (uint8_t)(x >> 16);\n  p[4] = (uint8_t)(x >> 8);\n  p[5] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u48le(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n  p[5] = (uint8_t)(x >> 40);\n}\n\nstatic inline void  //\nwuffs_base__store_u56be(ui" +
	"nt8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 48);\n  p[1] = (uint8_t)(x >> 40);\n  p[2] = (uint8_t)(x >> 32);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 16);\n  p[5] = (uint8_t)(x >> 8);\n  p[6] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u56le(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n  p[5] = (uint8_t)(x >> 40);\n  p[6] = (uint8_t)(x >> 48);\n}\n\nstatic inline void  //\nwuffs_base__store_u64be(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 56);\n  p[1] = (uint8_t)(x >> 48);\n  p[2] = (uint8_t)(x >> 40);\n  p[3] = (uint8_t)(x >> 32);\n  p[4] = (uint8_t)(x >> 24);\n  p[5] = (uint8_t)(x >> 16);\n  p[6] = (uint8_t)(x >> 8);\n  p[7] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u64le(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32" +
	");\n  p[5] = (uint8_t)(x >> 40);\n  p[6] = (uint8_t)(x >> 48);\n  p[7] = (uint8_t)(x >> 56);\n}\n\n" +
	"" +
	"// --------\n\nextern const uint8_t wuffs_base__low_bits_mask__u8[9];\nextern const uint16_t wuffs_base__low_bits_mask__u16[17];\nextern const uint32_t wuffs_base__low_bits_mask__u32[33];\nextern const uint64_t wuffs_base__low_bits_mask__u64[65];\n\n#define WUFFS_BASE__LOW_BITS_MASK__U8(n) (wuffs_base__low_bits_mask__u8[n])\n#define WUFFS_BASE__LOW_BITS_MASK__U16(n) (wuffs_base__low_bits_mask__u16[n])\n#define WUFFS_BASE__LOW_BITS_MASK__U32(n) (wuffs_base__low_bits_mask__u32[n])\n#define WUFFS_BASE__LOW_BITS_MASK__U64(n) (wuffs_base__low_bits_mask__u64[n])\n\n" +
	"" +
	"// --------\n\nstatic inline void  //\nwuffs_base__u8__sat_add_indirect(uint8_t* x, uint8_t y) {\n  *x = wuffs_base__u8__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u8__sat_sub_indirect(uint8_t* x, uint8_t y) {\n  *x = wuffs_base__u8__sat_sub(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u16__sat_add_indirect(uint16_t* x, uint16_t y) {\n  *x = wuffs_base__u16__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u16__sat_sub_indirect(uint16_t* x, uint16_t y) {\n  *x = wuffs_base__u16__sat_sub(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u32__sat_add_indirect(uint32_t* x, uint32_t y) {\n  *x = wuffs_base__u32__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u32__sat_sub_indirect(uint32_t* x, uint32_t y) {\n  *x = wuffs_base__u32__sat_sub(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u64__sat_add_indirect(uint64_t* x, uint64_t y) {\n  *x = wuffs_base__u64__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u64__sat_sub_indirect(uint64_t* x, uint64_t y) {\n  *x = wuffs_base__u64__sat_sub(*x, y);\n}\n\n" +
	"" +
	"// ---------------- Slices and Tables\n\n// wuffs_base__slice_u8__prefix returns up to the first up_to bytes of s.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__prefix(wuffs_base__slice_u8 s, uint64_t up_to) {\n  if ((uint64_t)(s.len) > up_to) {\n    s.len = up_to;\n  }\n  return s;\n}\n\n// wuffs_base__slice_u8__suffix returns up to the last up_to bytes of s.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__suffix(wuffs_base__slice_u8 s, uint64_t up_to) {\n  if ((uint64_t)(s.len) > up_to) {\n    s.ptr += (uint64_t)(s.len) - up_to;\n    s.len = up_to;\n  }\n  return s;\n}\n\n// wuffs_base__slice_u8__copy_from_slice calls memmove(dst.ptr, src.ptr, len)\n// where len is the minimum of dst.len and src.len.\n//\n// Passing a wuffs_base__slice_u8 with all fields NULL or zero (a valid, empty\n// slice) is valid and results in a no-op.\nstatic inline uint64_t  //\nwuffs_base__slice_u8__copy_from_slice(wuffs_base__slice_u8 dst,\n                                      wuffs_base__slice_u8 src) {\n  size_t len = dst.l" +
	"en < src.len ? dst.len : src.len;\n  if (len > 0) {\n    memmove(dst.ptr, src.ptr, len);\n  }\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__table_u8__row(wuffs_base__table_u8 t, uint32_t y) {\n  if (y < t.height) {\n    return wuffs_base__make_slice_u8(t.ptr + (t.stride * y), t.width);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n" +
	"" +
	"// ---------------- Slices and Tables (Utility)\n\n#define wuffs_base__utility__empty_slice_u8 wuffs_base__empty_slice_u8\n" +
	""

const baseCorePublicH = "" +
	"// Wuffs assumes that:\n//  - converting a uint32_t to a size_t will never overflow.\n//  - converting a size_t to a uint64_t will never overflow.\n#ifdef __WORDSIZE\n#if (__WORDSIZE != 32) && (__WORDSIZE != 64)\n#error \"Wuffs requires a word size of either 32 or 64 bits\"\n#endif\n#endif\n\n// WUFFS_VERSION is the major.minor.patch version, as per https://semver.org/,\n// as a uint64_t. The major number is the high 32 bits. The minor number is the\n// middle 16 bits. The patch number is the low 16 bits. The pre-release label\n// and build metadata are part of the string representation (such as\n// \"1.2.3-beta+456.20181231\") but not the uint64_t representation.\n//\n// WUFFS_VERSION_PRE_RELEASE_LABEL (such as \"\", \"beta\" or \"rc.1\") being\n// non-empty denotes a developer preview, not a release version, and has no\n// backwards or forwards compatibility guarantees.\n//\n// WUFFS_VERSION_BUILD_METADATA_XXX, if non-zero, are the number of commits and\n// the last commit date in the repository used to build this library. Within\n// eac" +
	"h major.minor branch, the commit count should increase monotonically.\n//\n// !! Some code generation programs can override WUFFS_VERSION.\n#define WUFFS_VERSION ((uint64_t)0)\n#define WUFFS_VERSION_MAJOR ((uint64_t)0)\n#define WUFFS_VERSION_MINOR ((uint64_t)0)\n#define WUFFS_VERSION_PATCH ((uint64_t)0)\n#define WUFFS_VERSION_PRE_RELEASE_LABEL \"work.in.progress\"\n#define WUFFS_VERSION_BUILD_METADATA_COMMIT_COUNT 0\n#define WUFFS_VERSION_BUILD_METADATA_COMMIT_DATE 0\n#define WUFFS_VERSION_STRING \"0.0.0+0.00000000\"\n\n// Define WUFFS_CONFIG__STATIC_FUNCTIONS to make all of Wuffs' functions have\n// static storage. The motivation is discussed in the \"ALLOW STATIC\n// IMPLEMENTATION\" section of\n// https://raw.githubusercontent.com/nothings/stb/master/docs/stb_howto.txt\n#ifdef WUFFS_CONFIG__STATIC_FUNCTIONS\n#define WUFFS_BASE__MAYBE_STATIC static\n#else\n#define WUFFS_BASE__MAYBE_STATIC\n#endif\n\n#if defined(__clang__)\n#define WUFFS_BASE__POTENTIALLY_UNUSED_FIELD __attribute__((unused))\n#else\n#define WUFFS_BASE__POTENTIALLY_UNUSED_" +
	"FIELD\n#endif\n\n// Clang also defines \"__GNUC__\".\n#if defined(__GNUC__)\n#define WUFFS_BASE__POTENTIALLY_UNUSED __attribute__((unused))\n#define WUFFS_BASE__WARN_UNUSED_RESULT __attribute__((warn_unused_result))\n#else\n#define WUFFS_BASE__POTENTIALLY_UNUSED\n#define WUFFS_BASE__WARN_UNUSED_RESULT\n#endif\n\n// Flags for wuffs_foo__bar__initialize functions.\n\n#define WUFFS_INITIALIZE__DEFAULT_OPTIONS ((uint32_t)0x00000000)\n\n// WUFFS_INITIALIZE__ALREADY_ZEROED means that the \"self\" receiver struct value\n// has already been set to all zeroes.\n#define WUFFS_INITIALIZE__ALREADY_ZEROED ((uint32_t)0x00000001)\n\n// WUFFS_INITIALIZE__LEAVE_INTERNAL_BUFFERS_UNINITIALIZED means that, absent\n// WUFFS_INITIALIZE__ALREADY_ZEROED, only some of the \"self\" receiver struct\n// value will be set to all zeroes. Internal buffers, which tend to be a large\n// proportion of the struct's size, will be left uninitialized. Internal means\n// that the buffer is contained by the receiver struct, as opposed to being\n// passed as a separately allocate" +
	"d \"work buffer\".\n//\n// With or without this bit set, the Wuffs compiler still enforces that no\n// reads or writes will overflow internal buffers' bounds. Even with this bit\n// set, the Wuffs standard library also considers reading from an uninitialized\n// buffer to be a bug, and strives to never do so, but unlike buffer overflows,\n// it is not a bug class that the Wuffs compiler eliminates.\n//\n// For those paranoid about security, leave this bit unset, so that\n// wuffs_foo__bar__initialize will initialize the entire struct value to zeroes\n// (unless WUFFS_INITIALIZE__ALREADY_ZEROED is set).\n//\n// Setting this bit (avoiding a fixed-size cost) gives a small absolute\n// improvement on micro-benchmarks, mostly noticable (in relative terms) only\n// when the actual work to do (i.e. the input) is also small. Look for\n// WUFFS_INITIALIZE__LEAVE_INTERNAL_BUFFERS_UNINITIALIZED in\n// https://github.com/google/wuffs/blob/master/doc/benchmarks.md for numbers.\n#define WUFFS_INITIALIZE__LEAVE_INTERNAL_BUFFERS_UNINITIALIZED " +
	"\\\n  ((uint32_t)0x00000002)\n\n" +
	"" +
	"// --------\n\n// wuffs_base__empty_struct is used when a Wuffs function returns an empty\n// struct. In C, if a function f returns void, you can't say \"x = f()\", but in\n// Wuffs, if a function g returns empty, you can say \"y = g()\".\ntypedef struct {\n  // private_impl is a placeholder field. It isn't explicitly used, except that\n  // without it, the sizeof a struct with no fields can differ across C/C++\n  // compilers, and it is undefined behavior in C99. For example, gcc says that\n  // the sizeof an empty struct is 0, and g++ says that it is 1. This leads to\n  // ABI incompatibility if a Wuffs .c file is processed by one compiler and\n  // its .h file with another compiler.\n  //\n  // Instead, we explicitly insert an otherwise unused field, so that the\n  // sizeof this struct is always 1.\n  uint8_t private_impl;\n} wuffs_base__empty_struct;\n\nstatic inline wuffs_base__empty_struct  //\nwuffs_base__make_empty_struct() {\n  wuffs_base__empty_struct ret;\n  ret.private_impl = 0;\n  return ret;\n}\n\n// wuffs_base__utility is" +
	" a placeholder receiver type. It enables what Java\n// calls static methods, as opposed to regular methods.\ntypedef struct {\n  // private_impl is a placeholder field. It isn't explicitly used, except that\n  // without it, the sizeof a struct with no fields can differ across C/C++\n  // compilers, and it is undefined behavior in C99. For example, gcc says that\n  // the sizeof an empty struct is 0, and g++ says that it is 1. This leads to\n  // ABI incompatibility if a Wuffs .c file is processed by one compiler and\n  // its .h file with another compiler.\n  //\n  // Instead, we explicitly insert an otherwise unused field, so that the\n  // sizeof this struct is always 1.\n  uint8_t private_impl;\n} wuffs_base__utility;\n\n" +
	"" +
	"// --------\n\n// A status is either NULL (meaning OK) or a string message. That message is\n// human-readable, for programmers, but it is not for end users. It is not\n// localized, and does not contain additional contextual information such as a\n// source filename.\n//\n// Status strings are statically allocated and should never be free'd. They can\n// be compared by the == operator and not just by strcmp.\n//\n// Statuses come in four categories:\n//  - OK:          the request was completed, successfully.\n//  - Warnings:    the request was completed, unsuccessfully.\n//  - Suspensions: the request was not completed, but can be re-tried.\n//  - Errors:      the request was not completed, permanently.\n//\n// When a function returns an incomplete status, a suspension means that that\n// function should be called again within a new context, such as after flushing\n// or re-filling an I/O buffer. An error means that an irrecoverable failure\n// state was reached.\ntypedef const char* wuffs_base__status;\n\n// !! INSERT wuffs_bas" +
	"e__status names.\n\nstatic inline bool  //\nwuffs_base__status__is_complete(wuffs_base__status z) {\n  return (z == NULL) || ((*z != '$') && (*z != '#'));\n}\n\nstatic inline bool  //\nwuffs_base__status__is_error(wuffs_base__status z) {\n  return z && (*z == '#');\n}\n\nstatic inline bool  //\nwuffs_base__status__is_ok(wuffs_base__status z) {\n  return z == NULL;\n}\n\nstatic inline bool  //\nwuffs_base__status__is_suspension(wuffs_base__status z) {\n  return z && (*z == '$');\n}\n\nstatic inline bool  //\nwuffs_base__status__is_warning(wuffs_base__status z) {\n  return z && (*z != '$') && (*z != '#');\n}\n\n" +
	"" +
	"// --------\n\n// FourCC constants.\n\n// !! INSERT FourCCs.\n\n" +
	"" +
	"// --------\n\n// Flicks are a unit of time. One flick (frame-tick) is 1 / 705_600_000 of a\n// second. See https://github.com/OculusVR/Flicks\ntypedef int64_t wuffs_base__flicks;\n\n#define WUFFS_BASE__FLICKS_PER_SECOND ((uint64_t)705600000)\n#define WUFFS_BASE__FLICKS_PER_MILLISECOND ((uint64_t)705600)\n\n" +
	"" +
	"// ---------------- Numeric Types\n\nstatic inline uint8_t  //\nwuffs_base__u8__min(uint8_t x, uint8_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint8_t  //\nwuffs_base__u8__max(uint8_t x, uint8_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__min(uint16_t x, uint16_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__max(uint16_t x, uint16_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__min(uint32_t x, uint32_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__max(uint32_t x, uint32_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__min(uint64_t x, uint64_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__max(uint64_t x, uint64_t y) {\n  return x > y ? x : y;\n}\n\n" +
	"" +
	"// --------\n\n// Saturating arithmetic (sat_add, sat_sub) branchless bit-twiddling algorithms\n// are per https://locklessinc.com/articles/sat_arithmetic/\n//\n// It is important that the underlying types are unsigned integers, as signed\n// integer arithmetic overflow is undefined behavior in C.\n\nstatic inline uint8_t  //\nwuffs_base__u8__sat_add(uint8_t x, uint8_t y) {\n  uint8_t res = (uint8_t)(x + y);\n  res |= (uint8_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint8_t  //\nwuffs_base__u8__sat_sub(uint8_t x, uint8_t y) {\n  uint8_t res = (uint8_t)(x - y);\n  res &= (uint8_t)(-(res <= x));\n  return res;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__sat_add(uint16_t x, uint16_t y) {\n  uint16_t res = (uint16_t)(x + y);\n  res |= (uint16_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__sat_sub(uint16_t x, uint16_t y) {\n  uint16_t res = (uint16_t)(x - y);\n  res &= (uint16_t)(-(res <= x));\n  return res;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__sat_add(uint32_t x, uint32_t y) {\n  uint32" +
	"_t res = (uint32_t)(x + y);\n  res |= (uint32_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__sat_sub(uint32_t x, uint32_t y) {\n  uint32_t res = (uint32_t)(x - y);\n  res &= (uint32_t)(-(res <= x));\n  return res;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__sat_add(uint64_t x, uint64_t y) {\n  uint64_t res = (uint64_t)(x + y);\n  res |= (uint64_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__sat_sub(uint64_t x, uint64_t y) {\n  uint64_t res = (uint64_t)(x - y);\n  res &= (uint64_t)(-(res <= x));\n  return res;\n}\n\n" +
	"" +
	"// ---------------- Slices and Tables\n\n// WUFFS_BASE__SLICE is a 1-dimensional buffer.\n//\n// len measures a number of elements, not necessarily a size in bytes.\n//\n// A value with all fields NULL or zero is a valid, empty slice.\n#define WUFFS_BASE__SLICE(T) \\\n  struct {                   \\\n    T* ptr;                  \\\n    size_t len;              \\\n  }\n\n// WUFFS_BASE__TABLE is a 2-dimensional buffer.\n//\n// width height, and stride measure a number of elements, not necessarily a\n// size in bytes.\n//\n// A value with all fields NULL or zero is a valid, empty table.\n#define WUFFS_BASE__TABLE(T) \\\n  struct {                   \\\n    T* ptr;                  \\\n    size_t width;            \\\n    size_t height;           \\\n    size_t stride;           \\\n  }\n\ntypedef WUFFS_BASE__SLICE(uint8_t) wuffs_base__slice_u8;\ntypedef WUFFS_BASE__SLICE(uint16_t) wuffs_base__slice_u16;\ntypedef WUFFS_BASE__SLICE(uint32_t) wuffs_base__slice_u32;\ntypedef WUFFS_BASE__SLICE(uint64_t) wuffs_base__slice_u64;\n\ntypedef WUFFS_BASE__TABLE(u" +
	"int8_t) wuffs_base__table_u8;\ntypedef WUFFS_BASE__TABLE(uint16_t) wuffs_base__table_u16;\ntypedef WUFFS_BASE__TABLE(uint32_t) wuffs_base__table_u32;\ntypedef WUFFS_BASE__TABLE(uint64_t) wuffs_base__table_u64;\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__make_slice_u8(uint8_t* ptr, size_t len) {\n  wuffs_base__slice_u8 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u16  //\nwuffs_base__make_slice_u16(uint16_t* ptr, size_t len) {\n  wuffs_base__slice_u16 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u32  //\nwuffs_base__make_slice_u32(uint32_t* ptr, size_t len) {\n  wuffs_base__slice_u32 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u64  //\nwuffs_base__make_slice_u64(uint64_t* ptr, size_t len) {\n  wuffs_base__slice_u64 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__empty_slice_u8() {\n  wuffs_base__slice_u8 ret;\n  ret.ptr = NULL;\n" +
	"  ret.len = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__table_u8  //\nwuffs_base__empty_table_u8() {\n  wuffs_base__table_u8 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stride = 0;\n  return ret;\n}\n\n// wuffs_base__slice_u8__subslice_i returns s[i:].\n//\n// It returns an empty slice if i is out of bounds.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__subslice_i(wuffs_base__slice_u8 s, uint64_t i) {\n  if ((i <= SIZE_MAX) && (i <= s.len)) {\n    return wuffs_base__make_slice_u8(s.ptr + i, s.len - i);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n// wuffs_base__slice_u8__subslice_j returns s[:j].\n//\n// It returns an empty slice if j is out of bounds.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__subslice_j(wuffs_base__slice_u8 s, uint64_t j) {\n  if ((j <= SIZE_MAX) && (j <= s.len)) {\n    return wuffs_base__make_slice_u8(s.ptr, j);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n// wuffs_base__slice_u8__subslice_ij returns s[i:j].\n//\n// It returns an empty s" +
	"lice if i or j is out of bounds.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__subslice_ij(wuffs_base__slice_u8 s,\n                                  uint64_t i,\n                                  uint64_t j) {\n  if ((i <= j) && (j <= SIZE_MAX) && (j <= s.len)) {\n    return wuffs_base__make_slice_u8(s.ptr + i, j - i);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n" +
	""

const baseMemoryPrivateH = "" +
	"// ---------------- Memory Allocation\n" +
	""

const baseMemoryPublicH = "" +
	"// ---------------- Memory Allocation\n\n// The memory allocation related functions in this section aren't used by Wuffs\n// per se, but they may be helpful to the code that uses Wuffs.\n\n// wuffs_base__malloc_slice_uxx wraps calling a malloc-like function, except\n// that it takes a uint64_t number of elements instead of a size_t size in\n// bytes, and it returns a slice (a pointer and a length) instead of just a\n// pointer.\n//\n// You can pass the C stdlib's malloc as the malloc_func.\n//\n// It returns an empty slice (containing a NULL ptr field) if (num_uxx *\n// sizeof(uintxx_t)) would overflow SIZE_MAX.\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__malloc_slice_u8(void* (*malloc_func)(size_t), uint64_t num_u8) {\n  if (malloc_func && (num_u8 <= (SIZE_MAX / sizeof(uint8_t)))) {\n    void* p = (*malloc_func)(num_u8 * sizeof(uint8_t));\n    if (p) {\n      return wuffs_base__make_slice_u8((uint8_t*)(p), num_u8);\n    }\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\nstatic inline wuffs_base__slice_u16  //\nwuffs" +
	"_base__malloc_slice_u16(void* (*malloc_func)(size_t), uint64_t num_u16) {\n  if (malloc_func && (num_u16 <= (SIZE_MAX / sizeof(uint16_t)))) {\n    void* p = (*malloc_func)(num_u16 * sizeof(uint16_t));\n    if (p) {\n      return wuffs_base__make_slice_u16((uint16_t*)(p), num_u16);\n    }\n  }\n  return wuffs_base__make_slice_u16(NULL, 0);\n}\n\nstatic inline wuffs_base__slice_u32  //\nwuffs_base__malloc_slice_u32(void* (*malloc_func)(size_t), uint64_t num_u32) {\n  if (malloc_func && (num_u32 <= (SIZE_MAX / sizeof(uint32_t)))) {\n    void* p = (*malloc_func)(num_u32 * sizeof(uint32_t));\n    if (p) {\n      return wuffs_base__make_slice_u32((uint32_t*)(p), num_u32);\n    }\n  }\n  return wuffs_base__make_slice_u32(NULL, 0);\n}\n\nstatic inline wuffs_base__slice_u64  //\nwuffs_base__malloc_slice_u64(void* (*malloc_func)(size_t), uint64_t num_u64) {\n  if (malloc_func && (num_u64 <= (SIZE_MAX / sizeof(uint64_t)))) {\n    void* p = (*malloc_func)(num_u64 * sizeof(uint64_t));\n    if (p) {\n      return wuffs_base__make_slice_u64((uint64_" +
	"t*)(p), num_u64);\n    }\n  }\n  return wuffs_base__make_slice_u64(NULL, 0);\n}\n" +
	""

const baseImagePrivateH = "" +
	"// ---------------- Images\n" +
	""

const baseImagePublicH = "" +
	"// ---------------- Images\n\n// wuffs_base__color_u32_argb_premul is an 8 bit per channel premultiplied\n// Alpha, Red, Green, Blue color, as a uint32_t value. It is in word order, not\n// byte order: its value is always 0xAARRGGBB, regardless of endianness.\ntypedef uint32_t wuffs_base__color_u32_argb_premul;\n\n" +
	"" +
	"// --------\n\n// wuffs_base__pixel_format encodes the format of the bytes that constitute an\n// image frame's pixel data. Its bits:\n//  - bit        31  is reserved.\n//  - bits 30 .. 28 encodes color (and channel order, in terms of memory).\n//  - bit        27  is reserved.\n//  - bits 26 .. 24 encodes transparency.\n//  - bits 23 .. 21 are reserved.\n//  - bit        20 indicates big-endian/MSB-first (as opposed to little/LSB).\n//  - bit        19 indicates floating point (as opposed to integer).\n//  - bit        18 indicates palette-indexed. The number-of-planes (the next\n//                  field) will be 0, as the format is considered interleaved,\n//                  but the 8-bit N-BGRA color data is stored in plane 3.\n//  - bits 17 .. 16 are the number of planes, minus 1. Zero means interleaved.\n//  - bits 15 .. 12 encodes the number of bits (depth) in the 3rd channel.\n//  - bits 11 ..  8 encodes the number of bits (depth) in the 2nd channel.\n//  - bits  7 ..  4 encodes the number of bits (depth) in the 1st" +
	" channel.\n//  - bits  3 ..  0 encodes the number of bits (depth) in the 0th channel.\n//\n// The bit fields of a wuffs_base__pixel_format are not independent. For\n// example, the number of planes should not be greater than the number of\n// channels. Similarly, bits 15..4 are unused (and should be zero) if bits\n// 31..24 (color and transparency) together imply only 1 channel (gray, no\n// alpha) and floating point samples should mean a bit depth of 16, 32 or 64.\n//\n// Formats hold between 1 and 4 channels. For example: Y (1 channel: gray), YA\n// (2 channels: gray and alpha), BGR (3 channels: blue, green, red) or CMYK (4\n// channels: cyan, magenta, yellow, black).\n//\n// For direct formats with N > 1 channels, those channels can be laid out in\n// either 1 (interleaved) or N (planar) planes. For example, RGBA data is\n// usually interleaved, but YCbCr data is usually planar, due to chroma\n// subsampling (for details, see the wuffs_base__pixel_subsampling type).\n//\n// For indexed formats, the palette (always 256 × 4 " +
	"bytes) holds 8 bits per\n// channel non-alpha-premultiplied BGRA color data. There is only 1 plane (for\n// the index), as the format is considered interleaved. Plane 0 holds the\n// per-pixel indices. Plane 3 is re-purposed to hold the per-index colors.\n//\n// The color field is encoded in 3 bits:\n//  - 0 means                   A (Alpha).\n//  - 1 means Y         or     YA (Gray, Alpha).\n//  - 2 means YCbCr     or YCbCrA (Luma, Chroma-blue, Chroma-red, Alpha).\n//  - 3 means YCoCg     or YCoCgA (Luma, Chroma-orange, Chroma-green, Alpha).\n//  - 4 means BGR, BGRX or   BGRA (Blue, Green, Red, X-padding or Alpha).\n//  - 5 means RGB, RGBX or   RGBA (Red, Green, Blue, X-padding or Alpha).\n//  - 6 means CMY       or   CMYK (Cyan, Magenta, Yellow, Black).\n//  - all other values are reserved.\n//\n// In Wuffs, channels are given in memory order (also known as byte order),\n// regardless of endianness, since the C type for the pixel data is an array of\n// bytes, not an array of uint32_t. For example, interleaved BGRA with 8 b" +
	"its\n// per channel means that the bytes in memory are always Blue, Green, Red then\n// Alpha. On big-endian systems, that is the uint32_t 0xBBGGRRAA. On\n// little-endian, 0xAARRGGBB.\n//\n// When the color field (3 bits) encodes multiple options, the transparency\n// field (3 bits) distinguishes them:\n//  - 0 means fully opaque, no extra channels\n//  - 1 means fully opaque, one extra channel (X or K, padding or black).\n//  - 5 means one extra alpha channel, other channels are non-premultiplied.\n//  - 6 means one extra alpha channel, other channels are     premultiplied.\n//  - 7 means one extra alpha channel, binary alpha.\n//  - all other values are reserved.\n//\n// Binary alpha means that if a color is not completely opaque, it is\n// completely transparent black. As a source pixel format, it can therefore be\n// treated as either non-premultiplied or premultiplied.\n//\n// The zero wuffs_base__pixel_format value is an invalid pixel format, as it is\n// invalid to combine the zero color (alpha only) with the zero trans" +
	"parency.\n//\n// Bit depth is encoded in 4 bits:\n//  -  0 means the channel or index is unused.\n//  -  x means a bit depth of  x, for x in the range 1..8.\n//  -  9 means a bit depth of 10.\n//  - 10 means a bit depth of 12.\n//  - 11 means a bit depth of 16.\n//  - 12 means a bit depth of 24.\n//  - 13 means a bit depth of 32.\n//  - 14 means a bit depth of 48.\n//  - 15 means a bit depth of 64.\n//\n// For example, wuffs_base__pixel_format 0x5510BBBB is a natural format for\n// decoding a PNG image - network byte order (also known as big-endian),\n// interleaved, non-premultiplied alpha - that happens to be 16-bit-depth\n// truecolor with alpha (RGBA). In memory order:\n//\n//  ptr+0  ptr+1  ptr+2  ptr+3  ptr+4  ptr+5  ptr+6  ptr+7\n//  Rhi    Rlo    Ghi    Glo    Bhi    Blo    Ahi    Alo\n//\n// For example, the value wuffs_base__pixel_format 0x40000565 means BGR with no\n// alpha or padding, 5/6/5 bits for blue/green/red, interleaved 2 bytes per\n// pixel, laid out LSB-first in memory order:\n//\n//  ptr+0...........  ptr+1...." +
	".......\n//  MSB          LSB  MSB          LSB\n//  G₂G₁G₀B₄B₃B₂B₁B₀  R₄R₃R₂R₁R₀G₅G₄G₃\n//\n// On little-endian systems (but not big-endian), this Wuffs pixel format value\n// (0x40000565) corresponds to the Cairo library's CAIRO_FORMAT_RGB16_565, the\n// SDL2 (Simple DirectMedia Layer 2) library's SDL_PIXELFORMAT_RGB565 and the\n// Skia library's kRGB_565_SkColorType. Note BGR in Wuffs versus RGB in the\n// other libraries.\n//\n// Regardless of endianness, this Wuffs pixel format value (0x40000565)\n// corresponds to the V4L2 (Video For Linux 2) library's V4L2_PIX_FMT_RGB565\n// and the Wayland-DRM library's WL_DRM_FORMAT_RGB565.\n//\n// Different software libraries name their pixel formats (and especially their\n// channel order) either according to memory layout or as bits of a native\n// integer type like uint32_t. The two conventions differ because of a system's\n// endianness. As mentioned earlier, Wuffs pixel formats are always in memory\n// order. More detail of other software librarie" +
	"s' naming conventions is in the\n// Pixel Format Guide at https://afrantzis.github.io/pixel-format-guide/\n//\n// Do not manipulate these bits directly; they are private implementation\n// details. Use methods such as wuffs_base__pixel_format__num_planes instead.\ntypedef uint32_t wuffs_base__pixel_format;\n\n// Common 8-bit-depth pixel formats. This list is not exhaustive; not all valid\n// wuffs_base__pixel_format values are present.\n\n#define WUFFS_BASE__PIXEL_FORMAT__INVALID ((wuffs_base__pixel_format)0x00000000)\n\n#define WUFFS_BASE__PIXEL_FORMAT__A ((wuffs_base__pixel_format)0x02000008)\n\n#define WUFFS_BASE__PIXEL_FORMAT__Y ((wuffs_base__pixel_format)0x10000008)\n#define WUFFS_BASE__PIXEL_FORMAT__YA_NONPREMUL \\\n  ((wuffs_base__pixel_format)0x15000008)\n#define WUFFS_BASE__PIXEL_FORMAT__YA_PREMUL \\\n  ((wuffs_base__pixel_format)0x16000008)\n\n#define WUFFS_BASE__PIXEL_FORMAT__YCBCR ((wuffs_base__pixel_format)0x20020888)\n#define WUFFS_BASE__PIXEL_FORMAT__YCBCRK ((wuffs_base__pixel_format)0x21038888)\n#define WUFFS_BASE__P" +
	"IXEL_FORMAT__YCBCRA_NONPREMUL \\\n  ((wuffs_base__pixel_format)0x25038888)\n\n#define WUFFS_BASE__PIXEL_FORMAT__YCOCG ((wuffs_base__pixel_format)0x30020888)\n#define WUFFS_BASE__PIXEL_FORMAT__YCOCGK ((wuffs_base__pixel_format)0x31038888)\n#define WUFFS_BASE__PIXEL_FORMAT__YCOCGA_NONPREMUL \\\n  ((wuffs_base__pixel_format)0x35038888)\n\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL \\\n  ((wuffs_base__pixel_format)0x45040008)\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_PREMUL \\\n  ((wuffs_base__pixel_format)0x46040008)\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY \\\n  ((wuffs_base__pixel_format)0x47040008)\n\n#define WUFFS_BASE__PIXEL_FORMAT__BGR ((wuffs_base__pixel_format)0x40000888)\n#define WUFFS_BASE__PIXEL_FORMAT__BGRX ((wuffs_base__pixel_format)0x41008888)\n#define WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL \\\n  ((wuffs_base__pixel_format)0x45008888)\n#define WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL \\\n  ((wuffs_base__pixel_format)0x46008888)\n#define WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY \\\n  ((wuffs_base" +
	"__pixel_format)0x47008888)\n\n#define WUFFS_BASE__PIXEL_FORMAT__RGB ((wuffs_base__pixel_format)0x50000888)\n#define WUFFS_BASE__PIXEL_FORMAT__RGBX ((wuffs_base__pixel_format)0x51008888)\n#define WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL \\\n  ((wuffs_base__pixel_format)0x55008888)\n#define WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL \\\n  ((wuffs_base__pixel_format)0x56008888)\n#define WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY \\\n  ((wuffs_base__pixel_format)0x57008888)\n\n#define WUFFS_BASE__PIXEL_FORMAT__CMY ((wuffs_base__pixel_format)0x60020888)\n#define WUFFS_BASE__PIXEL_FORMAT__CMYK ((wuffs_base__pixel_format)0x61038888)\n\nextern const uint32_t wuffs_base__pixel_format__bits_per_channel[16];\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_valid(wuffs_base__pixel_format f) {\n  return f != 0;\n}\n\n// wuffs_base__pixel_format__bits_per_pixel returns the number of bits per\n// pixel for interleaved pixel formats, and returns 0 for planar pixel formats.\nstatic inline uint32_t  //\nwuffs_base__pixel_format__bits_per_pixel(wuffs_base__" +
	"pixel_format f) {\n  if (((f >> 16) & 0x03) != 0) {\n    return 0;\n  }\n  return wuffs_base__pixel_format__bits_per_channel[0x0F & (f >> 0)] +\n         wuffs_base__pixel_format__bits_per_channel[0x0F & (f >> 4)] +\n         wuffs_base__pixel_format__bits_per_channel[0x0F & (f >> 8)] +\n         wuffs_base__pixel_format__bits_per_channel[0x0F & (f >> 12)];\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_indexed(wuffs_base__pixel_format f) {\n  return (f >> 18) & 0x01;\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_interleaved(wuffs_base__pixel_format f) {\n  return ((f >> 16) & 0x03) == 0;\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_planar(wuffs_base__pixel_format f) {\n  return ((f >> 16) & 0x03) != 0;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_format__num_planes(wuffs_base__pixel_format f) {\n  return ((f >> 16) & 0x03) + 1;\n}\n\n#define WUFFS_BASE__PIXEL_FORMAT__NUM_PLANES_MAX 4\n\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__INDEX_PLANE 0\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__COLOR_PLA" +
	"NE 3\n\n" +
	"" +
	"// --------\n\n// wuffs_base__pixel_subsampling encodes the mapping of pixel space coordinates\n// (x, y) to pixel buffer indices (i, j). That mapping can differ for each\n// plane p. For a depth of 8 bits (1 byte), the p'th plane's sample starts at\n// (planes[p].ptr + (j * planes[p].stride) + i).\n//\n// For interleaved pixel formats, the mapping is trivial: i = x and j = y. For\n// planar pixel formats, the mapping can differ due to chroma subsampling. For\n// example, consider a three plane YCbCr pixel format with 4:2:2 subsampling.\n// For the luma (Y) channel, there is one sample for every pixel, but for the\n// chroma (Cb, Cr) channels, there is one sample for every two pixels: pairs of\n// horizontally adjacent pixels form one macropixel, i = x / 2 and j == y. In\n// general, for a given p:\n//  - i = (x + bias_x) >> shift_x.\n//  - j = (y + bias_y) >> shift_y.\n// where biases and shifts are in the range 0..3 and 0..2 respectively.\n//\n// In general, the biases will be zero after decoding an image. However, making\n//" +
	" a sub-image may change the bias, since the (x, y) coordinates are relative\n// to the sub-image's top-left origin, but the backing pixel buffers were\n// created relative to the original image's origin.\n//\n// For each plane p, each of those four numbers (biases and shifts) are encoded\n// in two bits, which combine to form an 8 bit unsigned integer:\n//\n//  e_p = (bias_x << 6) | (shift_x << 4) | (bias_y << 2) | (shift_y << 0)\n//\n// Those e_p values (e_0 for the first plane, e_1 for the second plane, etc)\n// combine to form a wuffs_base__pixel_subsampling value:\n//\n//  pixsub = (e_3 << 24) | (e_2 << 16) | (e_1 << 8) | (e_0 << 0)\n//\n// Do not manipulate these bits directly; they are private implementation\n// details. Use methods such as wuffs_base__pixel_subsampling__bias_x instead.\ntypedef uint32_t wuffs_base__pixel_subsampling;\n\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__NONE ((wuffs_base__pixel_subsampling)0)\n\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__444 \\\n  ((wuffs_base__pixel_subsampling)0x000000)\n#define WUFFS_BAS" +
	"E__PIXEL_SUBSAMPLING__440 \\\n  ((wuffs_base__pixel_subsampling)0x010100)\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__422 \\\n  ((wuffs_base__pixel_subsampling)0x101000)\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__420 \\\n  ((wuffs_base__pixel_subsampling)0x111100)\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__411 \\\n  ((wuffs_base__pixel_subsampling)0x202000)\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__410 \\\n  ((wuffs_base__pixel_subsampling)0x212100)\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__bias_x(wuffs_base__pixel_subsampling s,\n                                      uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 6;\n  return (s >> shift) & 0x03;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__shift_x(wuffs_base__pixel_subsampling s,\n                                       uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 4;\n  return (s >> shift) & 0x03;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__bias_y(wuffs_base__pixel_subsampling s,\n                               " +
	"       uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 2;\n  return (s >> shift) & 0x03;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__shift_y(wuffs_base__pixel_subsampling s,\n                                       uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 0;\n  return (s >> shift) & 0x03;\n}\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__pixel_format pixfmt;\n    wuffs_base__pixel_subsampling pixsub;\n    uint32_t width;\n    uint32_t height;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline void set(wuffs_base__pixel_format pixfmt,\n                  wuffs_base__pixel_subsampling pixsub,\n                  uint32_t width,\n                  uint32_t height);\n  inline void invalidate();\n  inline bool is_valid() const;\n  inline wuffs_base__pixel_format pixel_format() const;\n  inline wuffs_base__pixel_subsampling pixel_subsampling() const;\n  inline wuffs_base__rect_ie_u32 bounds() const;\n  inline uint32_t width() const;\n  inline uint32_t height() const;\n  inline uint64_t pixbuf_len() const;\n#endif  // __cplusplus\n\n} wuffs_base__pixel_config;\n\nstatic inline wuffs_base__pixel_config  //\nwuffs_base__null_pixel_config() {\n  wuffs_base__pixel_config ret;\n  ret.private_impl.pix" +
	"fmt = 0;\n  ret.private_impl.pixsub = 0;\n  ret.private_impl.width = 0;\n  ret.private_impl.height = 0;\n  return ret;\n}\n\n// TODO: Should this function return bool? An error type?\nstatic inline void  //\nwuffs_base__pixel_config__set(wuffs_base__pixel_config* c,\n                              wuffs_base__pixel_format pixfmt,\n                              wuffs_base__pixel_subsampling pixsub,\n                              uint32_t width,\n                              uint32_t height) {\n  if (!c) {\n    return;\n  }\n  if (pixfmt) {\n    uint64_t wh = ((uint64_t)width) * ((uint64_t)height);\n    // TODO: handle things other than 1 byte per pixel.\n    if (wh <= ((uint64_t)SIZE_MAX)) {\n      c->private_impl.pixfmt = pixfmt;\n      c->private_impl.pixsub = pixsub;\n      c->private_impl.width = width;\n      c->private_impl.height = height;\n      return;\n    }\n  }\n\n  c->private_impl.pixfmt = 0;\n  c->private_impl.pixsub = 0;\n  c->private_impl.width = 0;\n  c->private_impl.height = 0;\n}\n\nstatic inline void  //\nwuffs_base__pixel_co" +
	"nfig__invalidate(wuffs_base__pixel_config* c) {\n  if (c) {\n    c->private_impl.pixfmt = 0;\n    c->private_impl.pixsub = 0;\n    c->private_impl.width = 0;\n    c->private_impl.height = 0;\n  }\n}\n\nstatic inline bool  //\nwuffs_base__pixel_config__is_valid(const wuffs_base__pixel_config* c) {\n  return c && c->private_impl.pixfmt;\n}\n\nstatic inline wuffs_base__pixel_format  //\nwuffs_base__pixel_config__pixel_format(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.pixfmt : 0;\n}\n\nstatic inline wuffs_base__pixel_subsampling  //\nwuffs_base__pixel_config__pixel_subsampling(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.pixsub : 0;\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__pixel_config__bounds(const wuffs_base__pixel_config* c) {\n  if (c) {\n    wuffs_base__rect_ie_u32 ret;\n    ret.min_incl_x = 0;\n    ret.min_incl_y = 0;\n    ret.max_excl_x = c->private_impl.width;\n    ret.max_excl_y = c->private_impl.height;\n    return ret;\n  }\n\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl" +
	"_x = 0;\n  ret.min_incl_y = 0;\n  ret.max_excl_x = 0;\n  ret.max_excl_y = 0;\n  return ret;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_config__width(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.width : 0;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_config__height(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.height : 0;\n}\n\n// TODO: this is the right API for planar (not interleaved) pixbufs? Should it\n// allow decoding into a color model different from the format's intrinsic one?\n// For example, decoding a JPEG image straight to RGBA instead of to YCbCr?\nstatic inline uint64_t  //\nwuffs_base__pixel_config__pixbuf_len(const wuffs_base__pixel_config* c) {\n  if (!c) {\n    return 0;\n  }\n  if (wuffs_base__pixel_format__is_planar(c->private_impl.pixfmt)) {\n    // TODO: support planar pixel formats, concious of pixel subsampling.\n    return 0;\n  }\n  uint32_t bits_per_pixel =\n      wuffs_base__pixel_format__bits_per_pixel(c->private_impl.pixfmt);\n  if ((bits_per_pixel == 0" +
	") || ((bits_per_pixel % 8) != 0)) {\n    // TODO: support fraction-of-byte pixels, e.g. 1 bit per pixel?\n    return 0;\n  }\n  uint64_t bytes_per_pixel = bits_per_pixel / 8;\n\n  uint64_t n =\n      ((uint64_t)c->private_impl.width) * ((uint64_t)c->private_impl.height);\n  if (n > (UINT64_MAX / bytes_per_pixel)) {\n    return 0;\n  }\n  n *= bytes_per_pixel;\n\n  if (wuffs_base__pixel_format__is_indexed(c->private_impl.pixfmt)) {\n    if (n > (UINT64_MAX - 1024)) {\n      return 0;\n    }\n    n += 1024;\n  }\n\n  return n;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__pixel_config::set(wuffs_base__pixel_format pixfmt,\n                              wuffs_base__pixel_subsampling pixsub,\n                              uint32_t width,\n                              uint32_t height) {\n  wuffs_base__pixel_config__set(this, pixfmt, pixsub, width, height);\n}\n\ninline void  //\nwuffs_base__pixel_config::invalidate() {\n  wuffs_base__pixel_config__invalidate(this);\n}\n\ninline bool  //\nwuffs_base__pixel_config::is_valid() const {\n  return" +
	" wuffs_base__pixel_config__is_valid(this);\n}\n\ninline wuffs_base__pixel_format  //\nwuffs_base__pixel_config::pixel_format() const {\n  return wuffs_base__pixel_config__pixel_format(this);\n}\n\ninline wuffs_base__pixel_subsampling  //\nwuffs_base__pixel_config::pixel_subsampling() const {\n  return wuffs_base__pixel_config__pixel_subsampling(this);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__pixel_config::bounds() const {\n  return wuffs_base__pixel_config__bounds(this);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_config::width() const {\n  return wuffs_base__pixel_config__width(this);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_config::height() const {\n  return wuffs_base__pixel_config__height(this);\n}\n\ninline uint64_t  //\nwuffs_base__pixel_config::pixbuf_len() const {\n  return wuffs_base__pixel_config__pixbuf_len(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  wuffs_base__pixel_config pixcfg;\n\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    uint64_t first_frame_io_position;\n    bool first_frame_is_opaque;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline void set(wuffs_base__pixel_format pixfmt,\n                  wuffs_base__pixel_subsampling pixsub,\n                  uint32_t width,\n                  uint32_t height,\n                  uint64_t first_frame_io_position,\n                  bool first_frame_is_opaque);\n  inline void invalidate();\n  inline bool is_valid() const;\n  inline uint64_t first_frame_io_position() const;\n  inline bool first_frame_is_opaque() const;\n#endif  // __cplusplus\n\n} wuffs_base__image_config;\n\nstatic inline wuffs_base__image_config  //\nwuffs_base__null_image_config() {\n  wuffs_base__image_config ret;\n  ret.pixcfg = wuffs_base__null_pixel_config();\n  ret.private_impl.first_frame_io_position = 0;\n  ret.private_impl.fir" +
	"st_frame_is_opaque = false;\n  return ret;\n}\n\n// TODO: Should this function return bool? An error type?\nstatic inline void  //\nwuffs_base__image_config__set(wuffs_base__image_config* c,\n                              wuffs_base__pixel_format pixfmt,\n                              wuffs_base__pixel_subsampling pixsub,\n                              uint32_t width,\n                              uint32_t height,\n                              uint64_t first_frame_io_position,\n                              bool first_frame_is_opaque) {\n  if (!c) {\n    return;\n  }\n  if (wuffs_base__pixel_format__is_valid(pixfmt)) {\n    c->pixcfg.private_impl.pixfmt = pixfmt;\n    c->pixcfg.private_impl.pixsub = pixsub;\n    c->pixcfg.private_impl.width = width;\n    c->pixcfg.private_impl.height = height;\n    c->private_impl.first_frame_io_position = first_frame_io_position;\n    c->private_impl.first_frame_is_opaque = first_frame_is_opaque;\n    return;\n  }\n\n  c->pixcfg.private_impl.pixfmt = 0;\n  c->pixcfg.private_impl.pixsub = 0;\n  c->pix" +
	"cfg.private_impl.width = 0;\n  c->pixcfg.private_impl.height = 0;\n  c->private_impl.first_frame_io_position = 0;\n  c->private_impl.first_frame_is_opaque = 0;\n}\n\nstatic inline void  //\nwuffs_base__image_config__invalidate(wuffs_base__image_config* c) {\n  if (c) {\n    c->pixcfg.private_impl.pixfmt = 0;\n    c->pixcfg.private_impl.pixsub = 0;\n    c->pixcfg.private_impl.width = 0;\n    c->pixcfg.private_impl.height = 0;\n    c->private_impl.first_frame_io_position = 0;\n    c->private_impl.first_frame_is_opaque = 0;\n  }\n}\n\nstatic inline bool  //\nwuffs_base__image_config__is_valid(const wuffs_base__image_config* c) {\n  return c && wuffs_base__pixel_config__is_valid(&(c->pixcfg));\n}\n\nstatic inline uint64_t  //\nwuffs_base__image_config__first_frame_io_position(\n    const wuffs_base__image_config* c) {\n  return c ? c->private_impl.first_frame_io_position : 0;\n}\n\nstatic inline bool  //\nwuffs_base__image_config__first_frame_is_opaque(\n    const wuffs_base__image_config* c) {\n  return c ? c->private_impl.first_frame_is_opaqu" +
	"e : false;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__image_config::set(wuffs_base__pixel_format pixfmt,\n                              wuffs_base__pixel_subsampling pixsub,\n                              uint32_t width,\n                              uint32_t height,\n                              uint64_t first_frame_io_position,\n                              bool first_frame_is_opaque) {\n  wuffs_base__image_config__set(this, pixfmt, pixsub, width, height,\n                                first_frame_io_position, first_frame_is_opaque);\n}\n\ninline void  //\nwuffs_base__image_config::invalidate() {\n  wuffs_base__image_config__invalidate(this);\n}\n\ninline bool  //\nwuffs_base__image_config::is_valid() const {\n  return wuffs_base__image_config__is_valid(this);\n}\n\ninline uint64_t  //\nwuffs_base__image_config::first_frame_io_position() const {\n  return wuffs_base__image_config__first_frame_io_position(this);\n}\n\ninline bool  //\nwuffs_base__image_config::first_frame_is_opaque() const {\n  return wuffs_base__image_co" +
	"nfig__first_frame_is_opaque(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\n// wuffs_base__animation_blend encodes, for an animated image, how to blend the\n// transparent pixels of this frame with the existing canvas. In Porter-Duff\n// compositing operator terminology:\n//  - 0 means the frame may be transparent, and should be blended \"src over\n//    dst\", also known as just \"over\".\n//  - 1 means the frame may be transparent, and should be blended \"src\".\n//  - 2 means the frame is completely opaque, so that \"src over dst\" and \"src\"\n//    are equivalent.\n//\n// These semantics are conservative. It is valid for a completely opaque frame\n// to have a blend value other than 2.\ntypedef uint8_t wuffs_base__animation_blend;\n\n#define WUFFS_BASE__ANIMATION_BLEND__SRC_OVER_DST \\\n  ((wuffs_base__animation_blend)0)\n#define WUFFS_BASE__ANIMATION_BLEND__SRC ((wuffs_base__animation_blend)1)\n#define WUFFS_BASE__ANIMATION_BLEND__OPAQUE ((wuffs_base__animation_blend)2)\n\n" +
	"" +
	"// --------\n\n// wuffs_base__animation_disposal encodes, for an animated image, how to\n// dispose of a frame after displaying it:\n//  - None means to draw the next frame on top of this one.\n//  - Restore Background means to clear the frame's dirty rectangle to \"the\n//    background color\" (in practice, this means transparent black) before\n//    drawing the next frame.\n//  - Restore Previous means to undo the current frame, so that the next frame\n//    is drawn on top of the previous one.\ntypedef uint8_t wuffs_base__animation_disposal;\n\n#define WUFFS_BASE__ANIMATION_DISPOSAL__NONE ((wuffs_base__animation_disposal)0)\n#define WUFFS_BASE__ANIMATION_DISPOSAL__RESTORE_BACKGROUND \\\n  ((wuffs_base__animation_disposal)1)\n#define WUFFS_BASE__ANIMATION_DISPOSAL__RESTORE_PREVIOUS \\\n  ((wuffs_base__animation_disposal)2)\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__rect_ie_u32 bounds;\n    wuffs_base__flicks duration;\n    uint64_t index;\n    uint64_t io_position;\n    wuffs_base__animation_blend blend;\n    wuffs_base__animation_disposal disposal;\n    wuffs_base__color_u32_argb_premul background_color;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline void update(wuffs_base__rect_ie_u32 bounds,\n                     wuffs_base__flicks duration,\n                     uint64_t index,\n                     uint64_t io_position,\n                     wuffs_base__animation_blend blend,\n                     wuffs_base__animation_disposal disposal,\n                     wuffs_base__color_u32_argb_premul background_color);\n  inline wuffs_base__rect_ie_u32 bounds() const;\n  inline uint32_t width() const;\n  inline uint32_t height() const;\n  inline wuffs_base__flicks duration() const;\n  inline uint64_t index()" +
	" const;\n  inline uint64_t io_position() const;\n  inline wuffs_base__animation_blend blend() const;\n  inline wuffs_base__animation_disposal disposal() const;\n  inline wuffs_base__color_u32_argb_premul background_color() const;\n#endif  // __cplusplus\n\n} wuffs_base__frame_config;\n\nstatic inline wuffs_base__frame_config  //\nwuffs_base__null_frame_config() {\n  wuffs_base__frame_config ret;\n  ret.private_impl.bounds = wuffs_base__make_rect_ie_u32(0, 0, 0, 0);\n  ret.private_impl.duration = 0;\n  ret.private_impl.index = 0;\n  ret.private_impl.io_position = 0;\n  ret.private_impl.blend = 0;\n  ret.private_impl.disposal = 0;\n  return ret;\n}\n\nstatic inline void  //\nwuffs_base__frame_config__update(\n    wuffs_base__frame_config* c,\n    wuffs_base__rect_ie_u32 bounds,\n    wuffs_base__flicks duration,\n    uint64_t index,\n    uint64_t io_position,\n    wuffs_base__animation_blend blend,\n    wuffs_base__animation_disposal disposal,\n    wuffs_base__color_u32_argb_premul background_color) {\n  if (!c) {\n    return;\n  }\n\n  c->privat" +
	"e_impl.bounds = bounds;\n  c->private_impl.duration = duration;\n  c->private_impl.index = index;\n  c->private_impl.io_position = io_position;\n  c->private_impl.blend = blend;\n  c->private_impl.disposal = disposal;\n  c->private_impl.background_color = background_color;\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__frame_config__bounds(const wuffs_base__frame_config* c) {\n  if (c) {\n    return c->private_impl.bounds;\n  }\n\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl_x = 0;\n  ret.min_incl_y = 0;\n  ret.max_excl_x = 0;\n  ret.max_excl_y = 0;\n  return ret;\n}\n\nstatic inline uint32_t  //\nwuffs_base__frame_config__width(const wuffs_base__frame_config* c) {\n  return c ? wuffs_base__rect_ie_u32__width(&c->private_impl.bounds) : 0;\n}\n\nstatic inline uint32_t  //\nwuffs_base__frame_config__height(const wuffs_base__frame_config* c) {\n  return c ? wuffs_base__rect_ie_u32__height(&c->private_impl.bounds) : 0;\n}\n\n// wuffs_base__frame_config__duration returns the amount of time to display\n// this frame. Zero means to d" +
	"isplay forever - a still (non-animated) image.\nstatic inline wuffs_base__flicks  //\nwuffs_base__frame_config__duration(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.duration : 0;\n}\n\n// wuffs_base__frame_config__index returns the index of this frame. The first\n// frame in an image has index 0, the second frame has index 1, and so on.\nstatic inline uint64_t  //\nwuffs_base__frame_config__index(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.index : 0;\n}\n\n// wuffs_base__frame_config__io_position returns the I/O stream position before\n// the frame config.\nstatic inline uint64_t  //\nwuffs_base__frame_config__io_position(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.io_position : 0;\n}\n\n// wuffs_base__frame_config__blend returns, for an animated image, how to blend\n// the transparent pixels of this frame with the existing canvas.\nstatic inline wuffs_base__animation_blend  //\nwuffs_base__frame_config__blend(const wuffs_base__frame_config* c) {\n  return c ? c->p" +
	"rivate_impl.blend : 0;\n}\n\n// wuffs_base__frame_config__disposal returns, for an animated image, how to\n// dispose of this frame after displaying it.\nstatic inline wuffs_base__animation_disposal  //\nwuffs_base__frame_config__disposal(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.disposal : 0;\n}\n\nstatic inline wuffs_base__color_u32_argb_premul  //\nwuffs_base__frame_config__background_color(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.background_color : 0;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__frame_config::update(\n    wuffs_base__rect_ie_u32 bounds,\n    wuffs_base__flicks duration,\n    uint64_t index,\n    uint64_t io_position,\n    wuffs_base__animation_blend blend,\n    wuffs_base__animation_disposal disposal,\n    wuffs_base__color_u32_argb_premul background_color) {\n  wuffs_base__frame_config__update(this, bounds, duration, index, io_position,\n                                   blend, disposal, background_color);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_b" +
	"ase__frame_config::bounds() const {\n  return wuffs_base__frame_config__bounds(this);\n}\n\ninline uint32_t  //\nwuffs_base__frame_config::width() const {\n  return wuffs_base__frame_config__width(this);\n}\n\ninline uint32_t  //\nwuffs_base__frame_config::height() const {\n  return wuffs_base__frame_config__height(this);\n}\n\ninline wuffs_base__flicks  //\nwuffs_base__frame_config::duration() const {\n  return wuffs_base__frame_config__duration(this);\n}\n\ninline uint64_t  //\nwuffs_base__frame_config::index() const {\n  return wuffs_base__frame_config__index(this);\n}\n\ninline uint64_t  //\nwuffs_base__frame_config::io_position() const {\n  return wuffs_base__frame_config__io_position(this);\n}\n\ninline wuffs_base__animation_blend  //\nwuffs_base__frame_config::blend() const {\n  return wuffs_base__frame_config__blend(this);\n}\n\ninline wuffs_base__animation_disposal  //\nwuffs_base__frame_config::disposal() const {\n  return wuffs_base__frame_config__disposal(this);\n}\n\ninline wuffs_base__color_u32_argb_premul  //\nwuffs_base__frame_confi" +
	"g::background_color() const {\n  return wuffs_base__frame_config__background_color(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  wuffs_base__pixel_config pixcfg;\n\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__table_u8 planes[WUFFS_BASE__PIXEL_FORMAT__NUM_PLANES_MAX];\n    // TODO: color spaces.\n  } private_impl;\n\n#ifdef __cplusplus\n  inline wuffs_base__status set_from_slice(wuffs_base__pixel_config* pixcfg,\n                                           wuffs_base__slice_u8 pixbuf_memory);\n  inline wuffs_base__status set_from_table(wuffs_base__pixel_config* pixcfg,\n                                           wuffs_base__table_u8 pixbuf_memory);\n  inline wuffs_base__slice_u8 palette();\n  inline wuffs_base__pixel_format pixel_format() const;\n  inline wuffs_base__table_u8 plane(uint32_t p);\n#endif  // __cplusplus\n\n} wuffs_base__pixel_buffer;\n\nstatic inline wuffs_base__pixel_buffer  //\nwuffs_base__null_pixel_buffer() {\n  wuffs_base__pixel_buffer ret;\n  ret.pixcfg = wuffs_base__null_pixel_config();\n  ret.pri" +
	"vate_impl.planes[0] = wuffs_base__empty_table_u8();\n  ret.private_impl.planes[1] = wuffs_base__empty_table_u8();\n  ret.private_impl.planes[2] = wuffs_base__empty_table_u8();\n  ret.private_impl.planes[3] = wuffs_base__empty_table_u8();\n  return ret;\n}\n\nstatic inline wuffs_base__status  //\nwuffs_base__pixel_buffer__set_from_slice(wuffs_base__pixel_buffer* b,\n                                         wuffs_base__pixel_config* pixcfg,\n                                         wuffs_base__slice_u8 pixbuf_memory) {\n  if (!b) {\n    return wuffs_base__error__bad_receiver;\n  }\n  memset(b, 0, sizeof(*b));\n  if (!pixcfg) {\n    return wuffs_base__error__bad_argument;\n  }\n  if (wuffs_base__pixel_format__is_planar(pixcfg->private_impl.pixfmt)) {\n    // TODO: support planar pixel formats, concious of pixel subsampling.\n    return wuffs_base__error__unsupported_option;\n  }\n  uint32_t bits_per_pixel =\n      wuffs_base__pixel_format__bits_per_pixel(pixcfg->private_impl.pixfmt);\n  if ((bits_per_pixel == 0) || ((bits_per_pixel % 8" +
	") != 0)) {\n    // TODO: support fraction-of-byte pixels, e.g. 1 bit per pixel?\n    return wuffs_base__error__unsupported_option;\n  }\n  uint64_t bytes_per_pixel = bits_per_pixel / 8;\n\n  uint8_t* ptr = pixbuf_memory.ptr;\n  uint64_t len = pixbuf_memory.len;\n  if (wuffs_base__pixel_format__is_indexed(pixcfg->private_impl.pixfmt)) {\n    // Split a 1024 byte chunk (256 palette entries × 4 bytes per entry) from\n    // the start of pixbuf_memory. We split from the start, not the end, so\n    // that the both chunks' pointers have the same alignment as the original\n    // pointer, up to an alignment of 1024.\n    if (len < 1024) {\n      return wuffs_base__error__bad_argument_length_too_short;\n    }\n    wuffs_base__table_u8* tab =\n        &b->private_impl.planes[WUFFS_BASE__PIXEL_FORMAT__INDEXED__COLOR_PLANE];\n    tab->ptr = ptr;\n    tab->width = 1024;\n    tab->height = 1;\n    tab->stride = 1024;\n    ptr += 1024;\n    len -= 1024;\n  }\n\n  uint64_t wh = ((uint64_t)pixcfg->private_impl.width) *\n                ((uint64_t)pi" +
	"xcfg->private_impl.height);\n  size_t width = (size_t)(pixcfg->private_impl.width);\n  if ((wh > (UINT64_MAX / bytes_per_pixel)) ||\n      (width > (SIZE_MAX / bytes_per_pixel))) {\n    return wuffs_base__error__bad_argument;\n  }\n  wh *= bytes_per_pixel;\n  width *= bytes_per_pixel;\n  if (wh > len) {\n    return wuffs_base__error__bad_argument_length_too_short;\n  }\n\n  b->pixcfg = *pixcfg;\n  wuffs_base__table_u8* tab = &b->private_impl.planes[0];\n  tab->ptr = ptr;\n  tab->width = width;\n  tab->height = pixcfg->private_impl.height;\n  tab->stride = width;\n  return NULL;\n}\n\nstatic inline wuffs_base__status  //\nwuffs_base__pixel_buffer__set_from_table(wuffs_base__pixel_buffer* b,\n                                         wuffs_base__pixel_config* pixcfg,\n                                         wuffs_base__table_u8 pixbuf_memory) {\n  if (!b) {\n    return wuffs_base__error__bad_receiver;\n  }\n  memset(b, 0, sizeof(*b));\n  if (!pixcfg ||\n      wuffs_base__pixel_format__is_planar(pixcfg->private_impl.pixfmt)) {\n    return wuf" +
	"fs_base__error__bad_argument;\n  }\n  uint32_t bits_per_pixel =\n      wuffs_base__pixel_format__bits_per_pixel(pixcfg->private_impl.pixfmt);\n  if ((bits_per_pixel == 0) || ((bits_per_pixel % 8) != 0)) {\n    // TODO: support fraction-of-byte pixels, e.g. 1 bit per pixel?\n    return wuffs_base__error__unsupported_option;\n  }\n  uint64_t bytes_per_pixel = bits_per_pixel / 8;\n\n  uint64_t width_in_bytes =\n      ((uint64_t)pixcfg->private_impl.width) * bytes_per_pixel;\n  if ((width_in_bytes > pixbuf_memory.width) ||\n      (pixcfg->private_impl.height > pixbuf_memory.height)) {\n    return wuffs_base__error__bad_argument;\n  }\n\n  b->pixcfg = *pixcfg;\n  b->private_impl.planes[0] = pixbuf_memory;\n  return NULL;\n}\n\n// wuffs_base__pixel_buffer__palette returns the palette color data. If\n// non-empty, it will have length 1024.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__pixel_buffer__palette(wuffs_base__pixel_buffer* b) {\n  if (b &&\n      wuffs_base__pixel_format__is_indexed(b->pixcfg.private_impl.pixfmt)) {\n    wuffs_" +
	"base__table_u8* tab =\n        &b->private_impl.planes[WUFFS_BASE__PIXEL_FORMAT__INDEXED__COLOR_PLANE];\n    if ((tab->width == 1024) && (tab->height == 1)) {\n      return wuffs_base__make_slice_u8(tab->ptr, 1024);\n    }\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\nstatic inline wuffs_base__pixel_format  //\nwuffs_base__pixel_buffer__pixel_format(const wuffs_base__pixel_buffer* b) {\n  if (b) {\n    return b->pixcfg.private_impl.pixfmt;\n  }\n  return WUFFS_BASE__PIXEL_FORMAT__INVALID;\n}\n\nstatic inline wuffs_base__table_u8  //\nwuffs_base__pixel_buffer__plane(wuffs_base__pixel_buffer* b, uint32_t p) {\n  if (b && (p < WUFFS_BASE__PIXEL_FORMAT__NUM_PLANES_MAX)) {\n    return b->private_impl.planes[p];\n  }\n\n  wuffs_base__table_u8 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stride = 0;\n  return ret;\n}\n\n#ifdef __cplusplus\n\ninline wuffs_base__status  //\nwuffs_base__pixel_buffer::set_from_slice(wuffs_base__pixel_config* pixcfg,\n                                         wuffs_base__slice_u8 pixbuf_me" +
	"mory) {\n  return wuffs_base__pixel_buffer__set_from_slice(this, pixcfg, pixbuf_memory);\n}\n\ninline wuffs_base__status  //\nwuffs_base__pixel_buffer::set_from_table(wuffs_base__pixel_config* pixcfg,\n                                         wuffs_base__table_u8 pixbuf_memory) {\n  return wuffs_base__pixel_buffer__set_from_table(this, pixcfg, pixbuf_memory);\n}\n\ninline wuffs_base__slice_u8  //\nwuffs_base__pixel_buffer::palette() {\n  return wuffs_base__pixel_buffer__palette(this);\n}\n\ninline wuffs_base__pixel_format  //\nwuffs_base__pixel_buffer::pixel_format() const {\n  return wuffs_base__pixel_buffer__pixel_format(this);\n}\n\ninline wuffs_base__table_u8  //\nwuffs_base__pixel_buffer::plane(uint32_t p) {\n  return wuffs_base__pixel_buffer__plane(this, p);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    uint8_t TODO;\n  } private_impl;\n\n#ifdef __cplusplus\n#endif  // __cplusplus\n\n} wuffs_base__decode_frame_options;\n\n#ifdef __cplusplus\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    // TODO: should the func type take restrict pointers?\n    uint64_t (*func)(wuffs_base__slice_u8 dst,\n                     wuffs_base__slice_u8 dst_palette,\n                     wuffs_base__slice_u8 src);\n  } private_impl;\n\n#ifdef __cplusplus\n  inline wuffs_base__status prepare(wuffs_base__pixel_format dst_format,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_format,\n                                    wuffs_base__slice_u8 src_palette);\n  inline uint64_t swizzle_interleaved(wuffs_base__slice_u8 dst,\n                                      wuffs_base__slice_u8 dst_palette,\n                                      wuffs_base__slice_u8 src) const;\n#endif  // __cplusplus\n\n} wuffs_base__pixel_swizzler;\n\nwuffs_base__status  //\nwuffs_base__pixel_swizzler__prepare(w" +
	"uffs_base__pixel_swizzler* p,\n                                    wuffs_base__pixel_format dst_format,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_format,\n                                    wuffs_base__slice_u8 src_palette);\n\nuint64_t  //\nwuffs_base__pixel_swizzler__swizzle_interleaved(\n    const wuffs_base__pixel_swizzler* p,\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src);\n\n#ifdef __cplusplus\n\ninline wuffs_base__status  //\nwuffs_base__pixel_swizzler::prepare(wuffs_base__pixel_format dst_format,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_format,\n                                    wuffs_base__slice_u8 src_palette) {\n  return wuffs_base__pixel_swizzler__prepare(this, dst_format, dst_palette,\n                                             src_format, src_palette);\n}\n\nuint64_t  //\nwu" +
	"ffs_base__pixel_swizzler::swizzle_interleaved(\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src) const {\n  return wuffs_base__pixel_swizzler__swizzle_interleaved(this, dst, dst_palette,\n                                                         src);\n}\n\n#endif  // __cplusplus\n" +
	""

const baseIOPrivateH = "" +
	"// ---------------- I/O\n\nstatic inline uint64_t  //\nwuffs_base__io__count_since(uint64_t mark, uint64_t index) {\n  if (index >= mark) {\n    return index - mark;\n  }\n  return 0;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__io__since(uint64_t mark, uint64_t index, uint8_t* ptr) {\n  if (index >= mark) {\n    return wuffs_base__make_slice_u8(ptr + mark, index - mark);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\nstatic inline uint32_t  //\nwuffs_base__io_writer__copy_n_from_history(uint8_t** ptr_iop_w,\n                                           uint8_t* io1_w,\n                                           uint8_t* io2_w,\n                                           uint32_t length,\n                                           uint32_t distance) {\n  if (!distance) {\n    return 0;\n  }\n  uint8_t* p = *ptr_iop_w;\n  if ((size_t)(p - io1_w) < (size_t)(distance)) {\n    return 0;\n  }\n  uint8_t* q = p - distance;\n  size_t n = (size_t)(io2_w - p);\n  if ((size_t)(length) > n) {\n    length = (uint32_t)(n);\n  } else {\n" +
	"    n = (size_t)(length);\n  }\n  // TODO: unrolling by 3 seems best for the std/deflate benchmarks, but that\n  // is mostly because 3 is the minimum length for the deflate format. This\n  // function implementation shouldn't overfit to that one format. Perhaps the\n  // copy_n_from_history Wuffs method should also take an unroll hint argument,\n  // and the cgen can look if that argument is the constant expression '3'.\n  //\n  // See also wuffs_base__io_writer__copy_n_from_history_fast below.\n  //\n  // Alternatively, or additionally, have a sloppy_copy_n_from_history method\n  // that copies 8 bytes at a time, possibly writing more than length bytes?\n  for (; n >= 3; n -= 3) {\n    *p++ = *q++;\n    *p++ = *q++;\n    *p++ = *q++;\n  }\n  for (; n; n--) {\n    *p++ = *q++;\n  }\n  *ptr_iop_w = p;\n  return length;\n}\n\n// wuffs_base__io_writer__copy_n_from_history_fast is like the\n// wuffs_base__io_writer__copy_n_from_history function above, but has stronger\n// pre-conditions. The caller needs to prove that:\n//  - distance >  " +
	"0\n//  - distance <= (*ptr_iop_w - io1_w)\n//  - length   <= (io2_w      - *ptr_iop_w)\nstatic inline uint32_t  //\nwuffs_base__io_writer__copy_n_from_history_fast(uint8_t** ptr_iop_w,\n                                                uint8_t* io1_w,\n                                                uint8_t* io2_w,\n                                                uint32_t length,\n                                                uint32_t distance) {\n  uint8_t* p = *ptr_iop_w;\n  uint8_t* q = p - distance;\n  uint32_t n = length;\n  for (; n >= 3; n -= 3) {\n    *p++ = *q++;\n    *p++ = *q++;\n    *p++ = *q++;\n  }\n  for (; n; n--) {\n    *p++ = *q++;\n  }\n  *ptr_iop_w = p;\n  return length;\n}\n\nstatic inline uint32_t  //\nwuffs_base__io_writer__copy_n_from_reader(uint8_t** ptr_iop_w,\n                                          uint8_t* io2_w,\n                                          uint32_t length,\n                                          uint8_t** ptr_iop_r,\n                                          uint8_t* io2_r) {\n  uint8_t* i" +
	"op_w = *ptr_iop_w;\n  size_t n = length;\n  if (n > ((size_t)(io2_w - iop_w))) {\n    n = (size_t)(io2_w - iop_w);\n  }\n  uint8_t* iop_r = *ptr_iop_r;\n  if (n > ((size_t)(io2_r - iop_r))) {\n    n = (size_t)(io2_r - iop_r);\n  }\n  if (n > 0) {\n    memmove(iop_w, iop_r, n);\n    *ptr_iop_w += n;\n    *ptr_iop_r += n;\n  }\n  return (uint32_t)(n);\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_writer__copy_from_slice(uint8_t** ptr_iop_w,\n                                       uint8_t* io2_w,\n                                       wuffs_base__slice_u8 src) {\n  uint8_t* iop_w = *ptr_iop_w;\n  size_t n = src.len;\n  if (n > ((size_t)(io2_w - iop_w))) {\n    n = (size_t)(io2_w - iop_w);\n  }\n  if (n > 0) {\n    memmove(iop_w, src.ptr, n);\n    *ptr_iop_w += n;\n  }\n  return (uint64_t)(n);\n}\n\nstatic inline uint32_t  //\nwuffs_base__io_writer__copy_n_from_slice(uint8_t** ptr_iop_w,\n                                         uint8_t* io2_w,\n                                         uint32_t length,\n                                         w" +
	"uffs_base__slice_u8 src) {\n  uint8_t* iop_w = *ptr_iop_w;\n  size_t n = src.len;\n  if (n > length) {\n    n = length;\n  }\n  if (n > ((size_t)(io2_w - iop_w))) {\n    n = (size_t)(io2_w - iop_w);\n  }\n  if (n > 0) {\n    memmove(iop_w, src.ptr, n);\n    *ptr_iop_w += n;\n  }\n  return (uint32_t)(n);\n}\n\nstatic inline wuffs_base__io_buffer*  //\nwuffs_base__io_reader__set(wuffs_base__io_buffer* b,\n                           uint8_t** ptr_iop_r,\n                           uint8_t** ptr_io0_r,\n                           uint8_t** ptr_io1_r,\n                           uint8_t** ptr_io2_r,\n                           wuffs_base__slice_u8 data) {\n  b->data = data;\n  b->meta.wi = data.len;\n  b->meta.ri = 0;\n  b->meta.pos = 0;\n  b->meta.closed = false;\n\n  *ptr_iop_r = data.ptr;\n  *ptr_io0_r = data.ptr;\n  *ptr_io1_r = data.ptr;\n  *ptr_io2_r = data.ptr + data.len;\n\n  return b;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__io_reader__take(uint8_t** ptr_iop_r, uint8_t* io2_r, uint64_t n) {\n  if (n <= ((size_t)(io2_r - *ptr_i" +
	"op_r))) {\n    uint8_t* p = *ptr_iop_r;\n    *ptr_iop_r += n;\n    return wuffs_base__make_slice_u8(p, n);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\nstatic inline wuffs_base__io_buffer*  //\nwuffs_base__io_writer__set(wuffs_base__io_buffer* b,\n                           uint8_t** ptr_iop_w,\n                           uint8_t** ptr_io0_w,\n                           uint8_t** ptr_io1_w,\n                           uint8_t** ptr_io2_w,\n                           wuffs_base__slice_u8 data) {\n  b->data = data;\n  b->meta.wi = 0;\n  b->meta.ri = 0;\n  b->meta.pos = 0;\n  b->meta.closed = false;\n\n  *ptr_iop_w = data.ptr;\n  *ptr_io0_w = data.ptr;\n  *ptr_io1_w = data.ptr;\n  *ptr_io2_w = data.ptr + data.len;\n\n  return b;\n}\n\n" +
	"" +
	"// ---------------- I/O (Utility)\n\n#define wuffs_base__utility__empty_io_reader wuffs_base__empty_io_reader\n#define wuffs_base__utility__empty_io_writer wuffs_base__empty_io_writer\n" +
	""

const baseIOPublicH = "" +
	"// ---------------- I/O\n//\n// See (/doc/note/io-input-output.md).\n\n// wuffs_base__io_buffer_meta is the metadata for a wuffs_base__io_buffer's\n// data.\ntypedef struct {\n  size_t wi;     // Write index. Invariant: wi <= len.\n  size_t ri;     // Read  index. Invariant: ri <= wi.\n  uint64_t pos;  // Position of the buffer start relative to the stream start.\n  bool closed;   // No further writes are expected.\n} wuffs_base__io_buffer_meta;\n\n// wuffs_base__io_buffer is a 1-dimensional buffer (a pointer and length) plus\n// additional metadata.\n//\n// A value with all fields zero is a valid, empty buffer.\ntypedef struct {\n  wuffs_base__slice_u8 data;\n  wuffs_base__io_buffer_meta meta;\n\n#ifdef __cplusplus\n  inline void compact();\n  inline uint64_t reader_available() const;\n  inline uint64_t reader_io_position() const;\n  inline uint64_t writer_available() const;\n  inline uint64_t writer_io_position() const;\n#endif  // __cplusplus\n\n} wuffs_base__io_buffer;\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__make_io_buff" +
	"er(wuffs_base__slice_u8 data,\n                           wuffs_base__io_buffer_meta meta) {\n  wuffs_base__io_buffer ret;\n  ret.data = data;\n  ret.meta = meta;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer_meta  //\nwuffs_base__make_io_buffer_meta(size_t wi,\n                                size_t ri,\n                                uint64_t pos,\n                                bool closed) {\n  wuffs_base__io_buffer_meta ret;\n  ret.wi = wi;\n  ret.ri = ri;\n  ret.pos = pos;\n  ret.closed = closed;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__empty_io_buffer() {\n  wuffs_base__io_buffer ret;\n  ret.data.ptr = NULL;\n  ret.data.len = 0;\n  ret.meta.wi = 0;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = false;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer_meta  //\nwuffs_base__empty_io_buffer_meta() {\n  wuffs_base__io_buffer_meta ret;\n  ret.wi = 0;\n  ret.ri = 0;\n  ret.pos = 0;\n  ret.closed = false;\n  return ret;\n}\n\n// wuffs_base__io_buffer__compact moves any written but unr" +
	"ead bytes to the\n// start of the buffer.\nstatic inline void  //\nwuffs_base__io_buffer__compact(wuffs_base__io_buffer* buf) {\n  if (!buf || (buf->meta.ri == 0)) {\n    return;\n  }\n  buf->meta.pos = wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.ri);\n  size_t n = buf->meta.wi - buf->meta.ri;\n  if (n != 0) {\n    memmove(buf->data.ptr, buf->data.ptr + buf->meta.ri, n);\n  }\n  buf->meta.wi = n;\n  buf->meta.ri = 0;\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_buffer__reader_available(const wuffs_base__io_buffer* buf) {\n  return buf ? buf->meta.wi - buf->meta.ri : 0;\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_buffer__reader_io_position(const wuffs_base__io_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.ri) : 0;\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_buffer__writer_available(const wuffs_base__io_buffer* buf) {\n  return buf ? buf->data.len - buf->meta.wi : 0;\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_buffer__writer_io_position(const wuffs_base__io_buffer* buf) {\n  return bu" +
	"f ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.wi) : 0;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__io_buffer::compact() {\n  wuffs_base__io_buffer__compact(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::reader_available() const {\n  return wuffs_base__io_buffer__reader_available(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::reader_io_position() const {\n  return wuffs_base__io_buffer__reader_io_position(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::writer_available() const {\n  return wuffs_base__io_buffer__writer_available(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::writer_io_position() const {\n  return wuffs_base__io_buffer__writer_io_position(this);\n}\n\n#endif  // __cplusplus\n" +
	""

const baseRangePrivateH = "" +
	"// ---------------- Ranges and Rects\n\nstatic inline uint32_t  //\nwuffs_base__range_ii_u32__get_min_incl(const wuffs_base__range_ii_u32* r) {\n  return r->min_incl;\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ii_u32__get_max_incl(const wuffs_base__range_ii_u32* r) {\n  return r->max_incl;\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ie_u32__get_min_incl(const wuffs_base__range_ie_u32* r) {\n  return r->min_incl;\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ie_u32__get_max_excl(const wuffs_base__range_ie_u32* r) {\n  return r->max_excl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ii_u64__get_min_incl(const wuffs_base__range_ii_u64* r) {\n  return r->min_incl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ii_u64__get_max_incl(const wuffs_base__range_ii_u64* r) {\n  return r->max_incl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ie_u64__get_min_incl(const wuffs_base__range_ie_u64* r) {\n  return r->min_incl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ie_u64__get_max_excl(const wuffs_base__range_" +
	"ie_u64* r) {\n  return r->max_excl;\n}\n\n" +
	"" +
	"// ---------------- Ranges and Rects (Utility)\n\n#define wuffs_base__utility__make_range_ii_u32 wuffs_base__make_range_ii_u32\n#define wuffs_base__utility__make_range_ie_u32 wuffs_base__make_range_ie_u32\n#define wuffs_base__utility__make_range_ii_u64 wuffs_base__make_range_ii_u64\n#define wuffs_base__utility__make_range_ie_u64 wuffs_base__make_range_ie_u64\n#define wuffs_base__utility__make_rect_ii_u32 wuffs_base__make_rect_ii_u32\n#define wuffs_base__utility__make_rect_ie_u32 wuffs_base__make_rect_ie_u32\n\n" +
	""

const baseRangePublicH = "" +
	"// ---------------- Ranges and Rects\n\n// See https://github.com/google/wuffs/blob/master/doc/note/ranges-and-rects.md\n\ntypedef struct wuffs_base__range_ii_u32__struct {\n  uint32_t min_incl;\n  uint32_t max_incl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ii_u32__struct s) const;\n  inline wuffs_base__range_ii_u32__struct intersect(\n      wuffs_base__range_ii_u32__struct s) const;\n  inline wuffs_base__range_ii_u32__struct unite(\n      wuffs_base__range_ii_u32__struct s) const;\n  inline bool contains(uint32_t x) const;\n  inline bool contains_range(wuffs_base__range_ii_u32__struct s) const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ii_u32;\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__make_range_ii_u32(uint32_t min_incl, uint32_t max_incl) {\n  wuffs_base__range_ii_u32 ret;\n  ret.min_incl = min_incl;\n  ret.max_incl = max_incl;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__is_empty(const wuffs_base__range_ii_u32* r) {\n  return r->min_inc" +
	"l > r->max_incl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__equals(const wuffs_base__range_ii_u32* r,\n                                 wuffs_base__range_ii_u32 s) {\n  return (r->min_incl == s.min_incl && r->max_incl == s.max_incl) ||\n         (wuffs_base__range_ii_u32__is_empty(r) &&\n          wuffs_base__range_ii_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32__intersect(const wuffs_base__range_ii_u32* r,\n                                    wuffs_base__range_ii_u32 s) {\n  wuffs_base__range_ii_u32 t;\n  t.min_incl = wuffs_base__u32__max(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u32__min(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32__unite(const wuffs_base__range_ii_u32* r,\n                                wuffs_base__range_ii_u32 s) {\n  if (wuffs_base__range_ii_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__range_ii_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ii_" +
	"u32 t;\n  t.min_incl = wuffs_base__u32__min(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u32__max(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__contains(const wuffs_base__range_ii_u32* r,\n                                   uint32_t x) {\n  return (r->min_incl <= x) && (x <= r->max_incl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__contains_range(const wuffs_base__range_ii_u32* r,\n                                         wuffs_base__range_ii_u32 s) {\n  return wuffs_base__range_ii_u32__equals(\n      &s, wuffs_base__range_ii_u32__intersect(r, s));\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ii_u32::is_empty() const {\n  return wuffs_base__range_ii_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__range_ii_u32::equals(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii_u32__equals(this, s);\n}\n\ninline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32::intersect(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii" +
	"_u32__intersect(this, s);\n}\n\ninline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32::unite(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ii_u32::contains(uint32_t x) const {\n  return wuffs_base__range_ii_u32__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ii_u32::contains_range(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii_u32__contains_range(this, s);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__range_ie_u32__struct {\n  uint32_t min_incl;\n  uint32_t max_excl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ie_u32__struct s) const;\n  inline wuffs_base__range_ie_u32__struct intersect(\n      wuffs_base__range_ie_u32__struct s) const;\n  inline wuffs_base__range_ie_u32__struct unite(\n      wuffs_base__range_ie_u32__struct s) const;\n  inline bool contains(uint32_t x) const;\n  inline bool contains_range(wuffs_base__range_ie_u32__struct s) const;\n  inline uint32_t length() const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ie_u32;\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__make_range_ie_u32(uint32_t min_incl, uint32_t max_excl) {\n  wuffs_base__range_ie_u32 ret;\n  ret.min_incl = min_incl;\n  ret.max_excl = max_excl;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__is_empty(const wuffs_base__range_ie_u32* r) {\n  return r->min_incl >= r->max_excl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__eq" +
	"uals(const wuffs_base__range_ie_u32* r,\n                                 wuffs_base__range_ie_u32 s) {\n  return (r->min_incl == s.min_incl && r->max_excl == s.max_excl) ||\n         (wuffs_base__range_ie_u32__is_empty(r) &&\n          wuffs_base__range_ie_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32__intersect(const wuffs_base__range_ie_u32* r,\n                                    wuffs_base__range_ie_u32 s) {\n  wuffs_base__range_ie_u32 t;\n  t.min_incl = wuffs_base__u32__max(r->min_incl, s.min_incl);\n  t.max_excl = wuffs_base__u32__min(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32__unite(const wuffs_base__range_ie_u32* r,\n                                wuffs_base__range_ie_u32 s) {\n  if (wuffs_base__range_ie_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__range_ie_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ie_u32 t;\n  t.min_incl = wuffs_base__u32__min(r->min_incl, s.min_incl);\n  " +
	"t.max_excl = wuffs_base__u32__max(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__contains(const wuffs_base__range_ie_u32* r,\n                                   uint32_t x) {\n  return (r->min_incl <= x) && (x < r->max_excl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__contains_range(const wuffs_base__range_ie_u32* r,\n                                         wuffs_base__range_ie_u32 s) {\n  return wuffs_base__range_ie_u32__equals(\n      &s, wuffs_base__range_ie_u32__intersect(r, s));\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ie_u32__length(const wuffs_base__range_ie_u32* r) {\n  return wuffs_base__u32__sat_sub(r->max_excl, r->min_incl);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ie_u32::is_empty() const {\n  return wuffs_base__range_ie_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__range_ie_u32::equals(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__equals(this, s);\n}\n\ninline wuffs_base__range_ie_u32  //\nwuffs_base__" +
	"range_ie_u32::intersect(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__intersect(this, s);\n}\n\ninline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32::unite(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ie_u32::contains(uint32_t x) const {\n  return wuffs_base__range_ie_u32__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ie_u32::contains_range(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__contains_range(this, s);\n}\n\ninline uint32_t  //\nwuffs_base__range_ie_u32::length() const {\n  return wuffs_base__range_ie_u32__length(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__range_ii_u64__struct {\n  uint64_t min_incl;\n  uint64_t max_incl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ii_u64__struct s) const;\n  inline wuffs_base__range_ii_u64__struct intersect(\n      wuffs_base__range_ii_u64__struct s) const;\n  inline wuffs_base__range_ii_u64__struct unite(\n      wuffs_base__range_ii_u64__struct s) const;\n  inline bool contains(uint64_t x) const;\n  inline bool contains_range(wuffs_base__range_ii_u64__struct s) const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ii_u64;\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__make_range_ii_u64(uint64_t min_incl, uint64_t max_incl) {\n  wuffs_base__range_ii_u64 ret;\n  ret.min_incl = min_incl;\n  ret.max_incl = max_incl;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__is_empty(const wuffs_base__range_ii_u64* r) {\n  return r->min_incl > r->max_incl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__equals(const wuffs_base__range_ii_u64" +
	"* r,\n                                 wuffs_base__range_ii_u64 s) {\n  return (r->min_incl == s.min_incl && r->max_incl == s.max_incl) ||\n         (wuffs_base__range_ii_u64__is_empty(r) &&\n          wuffs_base__range_ii_u64__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64__intersect(const wuffs_base__range_ii_u64* r,\n                                    wuffs_base__range_ii_u64 s) {\n  wuffs_base__range_ii_u64 t;\n  t.min_incl = wuffs_base__u64__max(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u64__min(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64__unite(const wuffs_base__range_ii_u64* r,\n                                wuffs_base__range_ii_u64 s) {\n  if (wuffs_base__range_ii_u64__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__range_ii_u64__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ii_u64 t;\n  t.min_incl = wuffs_base__u64__min(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u64__max(r" +
	"->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__contains(const wuffs_base__range_ii_u64* r,\n                                   uint64_t x) {\n  return (r->min_incl <= x) && (x <= r->max_incl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__contains_range(const wuffs_base__range_ii_u64* r,\n                                         wuffs_base__range_ii_u64 s) {\n  return wuffs_base__range_ii_u64__equals(\n      &s, wuffs_base__range_ii_u64__intersect(r, s));\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ii_u64::is_empty() const {\n  return wuffs_base__range_ii_u64__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__range_ii_u64::equals(wuffs_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__equals(this, s);\n}\n\ninline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64::intersect(wuffs_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__intersect(this, s);\n}\n\ninline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64::unite(wuffs_bas" +
	"e__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ii_u64::contains(uint64_t x) const {\n  return wuffs_base__range_ii_u64__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ii_u64::contains_range(wuffs_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__contains_range(this, s);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__range_ie_u64__struct {\n  uint64_t min_incl;\n  uint64_t max_excl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ie_u64__struct s) const;\n  inline wuffs_base__range_ie_u64__struct intersect(\n      wuffs_base__range_ie_u64__struct s) const;\n  inline wuffs_base__range_ie_u64__struct unite(\n      wuffs_base__range_ie_u64__struct s) const;\n  inline bool contains(uint64_t x) const;\n  inline bool contains_range(wuffs_base__range_ie_u64__struct s) const;\n  inline uint64_t length() const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ie_u64;\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__make_range_ie_u64(uint64_t min_incl, uint64_t max_excl) {\n  wuffs_base__range_ie_u64 ret;\n  ret.min_incl = min_incl;\n  ret.max_excl = max_excl;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__is_empty(const wuffs_base__range_ie_u64* r) {\n  return r->min_incl >= r->max_excl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__eq" +
	"uals(const wuffs_base__range_ie_u64* r,\n                                 wuffs_base__range_ie_u64 s) {\n  return (r->min_incl == s.min_incl && r->max_excl == s.max_excl) ||\n         (wuffs_base__range_ie_u64__is_empty(r) &&\n          wuffs_base__range_ie_u64__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64__intersect(const wuffs_base__range_ie_u64* r,\n                                    wuffs_base__range_ie_u64 s) {\n  wuffs_base__range_ie_u64 t;\n  t.min_incl = wuffs_base__u64__max(r->min_incl, s.min_incl);\n  t.max_excl = wuffs_base__u64__min(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64__unite(const wuffs_base__range_ie_u64* r,\n                                wuffs_base__range_ie_u64 s) {\n  if (wuffs_base__range_ie_u64__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__range_ie_u64__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ie_u64 t;\n  t.min_incl = wuffs_base__u64__min(r->min_incl, s.min_incl);\n  " +
	"t.max_excl = wuffs_base__u64__max(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__contains(const wuffs_base__range_ie_u64* r,\n                                   uint64_t x) {\n  return (r->min_incl <= x) && (x < r->max_excl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__contains_range(const wuffs_base__range_ie_u64* r,\n                                         wuffs_base__range_ie_u64 s) {\n  return wuffs_base__range_ie_u64__equals(\n      &s, wuffs_base__range_ie_u64__intersect(r, s));\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ie_u64__length(const wuffs_base__range_ie_u64* r) {\n  return wuffs_base__u64__sat_sub(r->max_excl, r->min_incl);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ie_u64::is_empty() const {\n  return wuffs_base__range_ie_u64__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__range_ie_u64::equals(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__equals(this, s);\n}\n\ninline wuffs_base__range_ie_u64  //\nwuffs_base__" +
	"range_ie_u64::intersect(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__intersect(this, s);\n}\n\ninline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64::unite(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ie_u64::contains(uint64_t x) const {\n  return wuffs_base__range_ie_u64__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ie_u64::contains_range(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__contains_range(this, s);\n}\n\ninline uint64_t  //\nwuffs_base__range_ie_u64::length() const {\n  return wuffs_base__range_ie_u64__length(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__rect_ii_u32__struct {\n  uint32_t min_incl_x;\n  uint32_t min_incl_y;\n  uint32_t max_incl_x;\n  uint32_t max_incl_y;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__rect_ii_u32__struct s) const;\n  inline wuffs_base__rect_ii_u32__struct intersect(\n      wuffs_base__rect_ii_u32__struct s) const;\n  inline wuffs_base__rect_ii_u32__struct unite(\n      wuffs_base__rect_ii_u32__struct s) const;\n  inline bool contains(uint32_t x, uint32_t y) const;\n  inline bool contains_rect(wuffs_base__rect_ii_u32__struct s) const;\n#endif  // __cplusplus\n\n} wuffs_base__rect_ii_u32;\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__make_rect_ii_u32(uint32_t min_incl_x,\n                             uint32_t min_incl_y,\n                             uint32_t max_incl_x,\n                             uint32_t max_incl_y) {\n  wuffs_base__rect_ii_u32 ret;\n  ret.min_incl_x = min_incl_x;\n  ret.min_incl_y = min_incl_y;\n  ret.max_incl_x = max_incl_x;\n  ret.max_incl_" +
	"y = max_incl_y;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__is_empty(const wuffs_base__rect_ii_u32* r) {\n  return (r->min_incl_x > r->max_incl_x) || (r->min_incl_y > r->max_incl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__equals(const wuffs_base__rect_ii_u32* r,\n                                wuffs_base__rect_ii_u32 s) {\n  return (r->min_incl_x == s.min_incl_x && r->min_incl_y == s.min_incl_y &&\n          r->max_incl_x == s.max_incl_x && r->max_incl_y == s.max_incl_y) ||\n         (wuffs_base__rect_ii_u32__is_empty(r) &&\n          wuffs_base__rect_ii_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32__intersect(const wuffs_base__rect_ii_u32* r,\n                                   wuffs_base__rect_ii_u32 s) {\n  wuffs_base__rect_ii_u32 t;\n  t.min_incl_x = wuffs_base__u32__max(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__max(r->min_incl_y, s.min_incl_y);\n  t.max_incl_x = wuffs_base__u32__min(r->max_incl_x, s.max_incl_x);\n  t." +
	"max_incl_y = wuffs_base__u32__min(r->max_incl_y, s.max_incl_y);\n  return t;\n}\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32__unite(const wuffs_base__rect_ii_u32* r,\n                               wuffs_base__rect_ii_u32 s) {\n  if (wuffs_base__rect_ii_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__rect_ii_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__rect_ii_u32 t;\n  t.min_incl_x = wuffs_base__u32__min(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__min(r->min_incl_y, s.min_incl_y);\n  t.max_incl_x = wuffs_base__u32__max(r->max_incl_x, s.max_incl_x);\n  t.max_incl_y = wuffs_base__u32__max(r->max_incl_y, s.max_incl_y);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__contains(const wuffs_base__rect_ii_u32* r,\n                                  uint32_t x,\n                                  uint32_t y) {\n  return (r->min_incl_x <= x) && (x <= r->max_incl_x) && (r->min_incl_y <= y) &&\n         (y <= r->max_incl_y);\n}\n\nstatic inline bool  //\nwuffs_bas" +
	"e__rect_ii_u32__contains_rect(const wuffs_base__rect_ii_u32* r,\n                                       wuffs_base__rect_ii_u32 s) {\n  return wuffs_base__rect_ii_u32__equals(\n      &s, wuffs_base__rect_ii_u32__intersect(r, s));\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__rect_ii_u32::is_empty() const {\n  return wuffs_base__rect_ii_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__rect_ii_u32::equals(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__equals(this, s);\n}\n\ninline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32::intersect(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__intersect(this, s);\n}\n\ninline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32::unite(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__rect_ii_u32::contains(uint32_t x, uint32_t y) const {\n  return wuffs_base__rect_ii_u32__contains(this, x, y);\n}\n\ninline bool  //\nwuffs_base__rect_ii_u32::contains_rect(wuffs_base__" +
	"rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__contains_rect(this, s);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__rect_ie_u32__struct {\n  uint32_t min_incl_x;\n  uint32_t min_incl_y;\n  uint32_t max_excl_x;\n  uint32_t max_excl_y;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__rect_ie_u32__struct s) const;\n  inline wuffs_base__rect_ie_u32__struct intersect(\n      wuffs_base__rect_ie_u32__struct s) const;\n  inline wuffs_base__rect_ie_u32__struct unite(\n      wuffs_base__rect_ie_u32__struct s) const;\n  inline bool contains(uint32_t x, uint32_t y) const;\n  inline bool contains_rect(wuffs_base__rect_ie_u32__struct s) const;\n  inline uint32_t width() const;\n  inline uint32_t height() const;\n#endif  // __cplusplus\n\n} wuffs_base__rect_ie_u32;\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__make_rect_ie_u32(uint32_t min_incl_x,\n                             uint32_t min_incl_y,\n                             uint32_t max_excl_x,\n                             uint32_t max_excl_y) {\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl_x = min_incl_x;\n  ret.min_" +
	"incl_y = min_incl_y;\n  ret.max_excl_x = max_excl_x;\n  ret.max_excl_y = max_excl_y;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__is_empty(const wuffs_base__rect_ie_u32* r) {\n  return (r->min_incl_x >= r->max_excl_x) || (r->min_incl_y >= r->max_excl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__equals(const wuffs_base__rect_ie_u32* r,\n                                wuffs_base__rect_ie_u32 s) {\n  return (r->min_incl_x == s.min_incl_x && r->min_incl_y == s.min_incl_y &&\n          r->max_excl_x == s.max_excl_x && r->max_excl_y == s.max_excl_y) ||\n         (wuffs_base__rect_ie_u32__is_empty(r) &&\n          wuffs_base__rect_ie_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32__intersect(const wuffs_base__rect_ie_u32* r,\n                                   wuffs_base__rect_ie_u32 s) {\n  wuffs_base__rect_ie_u32 t;\n  t.min_incl_x = wuffs_base__u32__max(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__max(r->min_incl_y, s.min_incl_y);\n  t" +
	".max_excl_x = wuffs_base__u32__min(r->max_excl_x, s.max_excl_x);\n  t.max_excl_y = wuffs_base__u32__min(r->max_excl_y, s.max_excl_y);\n  return t;\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32__unite(const wuffs_base__rect_ie_u32* r,\n                               wuffs_base__rect_ie_u32 s) {\n  if (wuffs_base__rect_ie_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__rect_ie_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__rect_ie_u32 t;\n  t.min_incl_x = wuffs_base__u32__min(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__min(r->min_incl_y, s.min_incl_y);\n  t.max_excl_x = wuffs_base__u32__max(r->max_excl_x, s.max_excl_x);\n  t.max_excl_y = wuffs_base__u32__max(r->max_excl_y, s.max_excl_y);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__contains(const wuffs_base__rect_ie_u32* r,\n                                  uint32_t x,\n                                  uint32_t y) {\n  return (r->min_incl_x <= x) && (x < r->max_excl_x) && (r->min_incl_y <= y) &" +
	"&\n         (y < r->max_excl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__contains_rect(const wuffs_base__rect_ie_u32* r,\n                                       wuffs_base__rect_ie_u32 s) {\n  return wuffs_base__rect_ie_u32__equals(\n      &s, wuffs_base__rect_ie_u32__intersect(r, s));\n}\n\nstatic inline uint32_t  //\nwuffs_base__rect_ie_u32__width(const wuffs_base__rect_ie_u32* r) {\n  return wuffs_base__u32__sat_sub(r->max_excl_x, r->min_incl_x);\n}\n\nstatic inline uint32_t  //\nwuffs_base__rect_ie_u32__height(const wuffs_base__rect_ie_u32* r) {\n  return wuffs_base__u32__sat_sub(r->max_excl_y, r->min_incl_y);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__rect_ie_u32::is_empty() const {\n  return wuffs_base__rect_ie_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__rect_ie_u32::equals(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__equals(this, s);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32::intersect(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_i" +
	"e_u32__intersect(this, s);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32::unite(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__rect_ie_u32::contains(uint32_t x, uint32_t y) const {\n  return wuffs_base__rect_ie_u32__contains(this, x, y);\n}\n\ninline bool  //\nwuffs_base__rect_ie_u32::contains_rect(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__contains_rect(this, s);\n}\n\ninline uint32_t  //\nwuffs_base__rect_ie_u32::width() const {\n  return wuffs_base__rect_ie_u32__width(this);\n}\n\ninline uint32_t  //\nwuffs_base__rect_ie_u32::height() const {\n  return wuffs_base__rect_ie_u32__height(this);\n}\n\n#endif  // __cplusplus\n" +
	""

const baseCopyright = "" +
	"// Copyright 2017 The Wuffs Authors.\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//    https://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n" +
	""
