/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtuosoUpdateRequest;

public class VirtuosoUpdateFactory {
    private VirtuosoUpdateFactory() {
    }

    public static VirtuosoUpdateRequest create(String string, VirtGraph virtGraph) {
        return new VirtuosoUpdateRequest(string, virtGraph);
    }

    public static VirtuosoUpdateRequest read(String string, VirtGraph virtGraph) {
        InputStream inputStream = null;
        if (string.equals("-")) {
            inputStream = System.in;
        } else {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UpdateException("File nout found: " + string);
            }
        }
        return VirtuosoUpdateFactory.read(inputStream, virtGraph);
    }

    public static VirtuosoUpdateRequest read(InputStream inputStream, VirtGraph virtGraph) {
        BufferedReader bufferedReader = FileUtils.asBufferedUTF8((InputStream)inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while ((c = (char)((Reader)bufferedReader).read()) != '\uffffffff') {
                stringBuffer.append(c);
            }
        }
        catch (Exception exception) {
            throw new UpdateException((Throwable)exception);
        }
        return new VirtuosoUpdateRequest(stringBuffer.toString(), virtGraph);
    }
}

