/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLDirectoryElement.h"

#include "HTMLDirectoryElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDirectoryElement);

/* Hash table */

static const HashTableValue JSHTMLDirectoryElementTableValues[3] =
{
    { "compact", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDirectoryElementCompact), (intptr_t)setJSHTMLDirectoryElementCompact },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDirectoryElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDirectoryElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLDirectoryElementTableValues, 0 };
#else
    { 4, 3, JSHTMLDirectoryElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDirectoryElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDirectoryElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDirectoryElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDirectoryElementConstructorTableValues, 0 };
#endif

class JSHTMLDirectoryElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDirectoryElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLDirectoryElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDirectoryElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDirectoryElementConstructor::s_info = { "HTMLDirectoryElementConstructor", 0, &JSHTMLDirectoryElementConstructorTable, 0 };

bool JSHTMLDirectoryElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElementConstructor, DOMObject>(exec, &JSHTMLDirectoryElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDirectoryElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDirectoryElementConstructor, DOMObject>(exec, &JSHTMLDirectoryElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDirectoryElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDirectoryElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDirectoryElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLDirectoryElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDirectoryElementPrototype::s_info = { "HTMLDirectoryElementPrototype", 0, &JSHTMLDirectoryElementPrototypeTable, 0 };

JSObject* JSHTMLDirectoryElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDirectoryElement>(exec, globalObject);
}

const ClassInfo JSHTMLDirectoryElement::s_info = { "HTMLDirectoryElement", &JSHTMLElement::s_info, &JSHTMLDirectoryElementTable, 0 };

JSHTMLDirectoryElement::JSHTMLDirectoryElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDirectoryElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDirectoryElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDirectoryElementPrototype(JSHTMLDirectoryElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDirectoryElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElement, Base>(exec, &JSHTMLDirectoryElementTable, this, propertyName, slot);
}

bool JSHTMLDirectoryElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDirectoryElement, Base>(exec, &JSHTMLDirectoryElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDirectoryElementCompact(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDirectoryElement* castedThis = static_cast<JSHTMLDirectoryElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->compact());
    return result;
}

JSValue jsHTMLDirectoryElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDirectoryElement* domObject = static_cast<JSHTMLDirectoryElement*>(asObject(slotBase));
    return JSHTMLDirectoryElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLDirectoryElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDirectoryElement, Base>(exec, propertyName, value, &JSHTMLDirectoryElementTable, this, slot);
}

void setJSHTMLDirectoryElementCompact(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDirectoryElement* castedThisObj = static_cast<JSHTMLDirectoryElement*>(thisObject);
    HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(castedThisObj->impl());
    imp->setCompact(value.toBoolean(exec));
}

JSValue JSHTMLDirectoryElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDirectoryElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
