/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.profiler.ui.wizards.panels.SelectIntegrationTypePanel;
import org.netbeans.modules.profiler.ui.wizards.panels.components.ResizableHintPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SelectIntegrationTypePanelUI
extends JPanel {
    private SelectIntegrationTypePanel.Model model = null;
    private final String INTEGRATION_TYPE_HELP = NbBundle.getMessage(this.getClass(), (String)"IntegrationTypeWizardPanelUI_IntegrationHintMsg");
    private JRadioButton buttonAutomatic;
    private JRadioButton buttonManual;
    private ButtonGroup groupIntegrationType;
    private ResizableHintPanel hintPanel;
    private JPanel selectionPanel;

    SelectIntegrationTypePanelUI(SelectIntegrationTypePanel.Model model) {
        this.model = model;
        this.initComponents();
        this.loadModel();
    }

    private void initComponents() {
        this.groupIntegrationType = new ButtonGroup();
        this.selectionPanel = new JPanel();
        this.buttonAutomatic = new JRadioButton();
        this.buttonManual = new JRadioButton();
        this.hintPanel = new ResizableHintPanel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/ui/wizards/panels/Bundle");
        this.selectionPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("IntegrationTypeWizardPanelUI_ChooseIntegrationTypeString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupIntegrationType.add(this.buttonAutomatic);
        this.buttonAutomatic.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAutomatic, (String)bundle.getString("IntegrationTypeWizardPanelUI_AutomaticString"));
        this.buttonAutomatic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonAutomatic.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAutomatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectIntegrationTypePanelUI.this.buttonAutomaticActionPerformed(evt);
            }
        });
        this.groupIntegrationType.add(this.buttonManual);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonManual, (String)bundle.getString("IntegrationTypeWizardPanelUI_ManualString"));
        this.buttonManual.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonManual.setMargin(new Insets(0, 0, 0, 0));
        this.buttonManual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectIntegrationTypePanelUI.this.buttonManualActionPerformed(evt);
            }
        });
        GroupLayout selectionPanelLayout = new GroupLayout((Container)this.selectionPanel);
        this.selectionPanel.setLayout((LayoutManager)selectionPanelLayout);
        selectionPanelLayout.setHorizontalGroup((GroupLayout.Group)selectionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)selectionPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)selectionPanelLayout.createParallelGroup(1).add((Component)this.buttonAutomatic).add((Component)this.buttonManual)).addContainerGap(291, Short.MAX_VALUE)));
        selectionPanelLayout.setVerticalGroup((GroupLayout.Group)selectionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)selectionPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.buttonAutomatic).addPreferredGap(0).add((Component)this.buttonManual).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonAutomatic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectIntegrationTypePanelUI.class, (String)"SelectIntegrationTypePanelUI.buttonAutomatic.AccessibleContext.accessibleDescription"));
        this.buttonManual.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectIntegrationTypePanelUI.class, (String)"SelectIntegrationTypePanelUI.buttonManual.AccessibleContext.accessibleDescription"));
        this.hintPanel.setMaximumSize(new Dimension(500, 100));
        this.hintPanel.setMinimumSize(new Dimension(500, 40));
        this.hintPanel.setPreferredSize(new Dimension(500, 80));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.selectionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).add((Component)this.hintPanel, -2, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.selectionPanel, -2, -1, -2).addPreferredGap(0, 125, Short.MAX_VALUE).add((Component)this.hintPanel, -2, -1, -2)));
        this.hintPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectIntegrationTypePanelUI.class, (String)"SelectIntegrationTypePanelUI.hintPanel.AccessibleContext.accessibleName"));
    }

    private void buttonManualActionPerformed(ActionEvent evt) {
        this.model.setIntegrationType(2);
    }

    private void buttonAutomaticActionPerformed(ActionEvent evt) {
        this.model.setIntegrationType(1);
    }

    private void loadModel() {
        this.model.setIntegrationType(this.buttonAutomatic.isSelected() ? 1 : 2);
    }

    public void refresh() {
        switch (this.model.getIntegrationType()) {
            case 1: {
                this.buttonAutomatic.setSelected(true);
                break;
            }
            case 2: {
                this.buttonManual.setSelected(true);
                break;
            }
            default: {
                this.buttonAutomatic.setSelected(true);
            }
        }
        String providerName = this.model.getProviderName();
        this.hintPanel.setHint(MessageFormat.format(this.INTEGRATION_TYPE_HELP, providerName != null ? providerName : ""));
    }
}

