/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.ui.components.JExtendedRadioButton;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NewCustomConfiguration
extends JPanel
implements ChangeListener,
ListSelectionListener,
DocumentListener {
    private static final String MONITOR_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_MonitorString");
    private static final String CPU_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_CpuString");
    private static final String MEMORY_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_MemoryString");
    private static final String NEW_CONFIG_DIALOG_CAPTION = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewConfigDialogCaption");
    private static final String DUPLICATE_CONFIG_DIALOG_CAPTION = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_DuplicateConfigDialogCaption");
    private static final String RENAME_CONFIG_DIALOG_CAPTION = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_RenameConfigDialogCaption");
    private static final String NEW_CONFIG_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewConfigString");
    private static final String NEW_MONITOR_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewMonitorString");
    private static final String NEW_CPU_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewCpuString");
    private static final String NEW_MEMORY_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewMemoryString");
    private static final String TYPE_LABEL_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_TypeLabelText");
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NameLabelText");
    private static final String INIT_SETTINGS_LABEL_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_InitSettingsLabelText");
    private static final String DEFAULT_RADIO_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_DefaultRadioText");
    private static final String EXISTING_RADIO_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_ExistingRadioText");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_OkButtonText");
    private static final int MODE_NEW_ANY = 0;
    private static final int MODE_NEW_TYPE = 1;
    private static final int MODE_DUPLICATE = 2;
    private static final int MODE_RENAME = 4;
    private static NewCustomConfiguration defaultInstance;
    private static final Icon ICON_MONITOR;
    private static final Icon ICON_CPU;
    private static final Icon ICON_MEMORY;
    private DefaultListModel existingSettingsListModel;
    private JButton okButton;
    private JLabel nameLabel;
    private JLabel settingsLabel;
    private JLabel typeLabel;
    private JList existingSettingsList;
    private JPanel bottomRenameSpacer;
    private JRadioButton cpuTypeRadio;
    private JRadioButton defaultSettingsRadio;
    private JRadioButton existingSettingsRadio;
    private JRadioButton memoryTypeRadio;
    private JRadioButton monitorTypeRadio;
    private JScrollPane existingSettingsScrollPane;
    private JTextField nameTextfield;
    private ProfilingSettings originalSettings = null;
    private ProfilingSettings[] availableSettings;
    private int mode;

    private NewCustomConfiguration() {
        this.initComponents();
    }

    public static ProfilingSettings createDuplicateConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupDuplicateConfiguration(originalConfiguration, availableConfigurations);
        DialogDescriptor dd = new DialogDescriptor((Object)ncc, MessageFormat.format(DUPLICATE_CONFIG_DIALOG_CAPTION, originalConfiguration.getSettingsName()));
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.pack();
        d.setVisible(true);
        ProfilingSettings newSettings = null;
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            newSettings = ncc.getProfilingSettings();
        }
        return newSettings;
    }

    public static ProfilingSettings createNewConfiguration(ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupUniversalConfiguration(availableConfigurations);
        DialogDescriptor dd = new DialogDescriptor((Object)ncc, NEW_CONFIG_DIALOG_CAPTION);
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.pack();
        d.setVisible(true);
        ProfilingSettings newSettings = null;
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            newSettings = ncc.getProfilingSettings();
        }
        return newSettings;
    }

    public static ProfilingSettings createNewConfiguration(int type, ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupTypeConfiguration(type, availableConfigurations);
        String typeString = "";
        if (Utils.isMonitorSettings(type)) {
            typeString = " (" + MONITOR_STRING + ")";
        } else if (Utils.isCPUSettings(type)) {
            typeString = " (" + CPU_STRING + ")";
        } else if (Utils.isMemorySettings(type)) {
            typeString = " (" + MEMORY_STRING + ")";
        }
        DialogDescriptor dd = new DialogDescriptor((Object)ncc, NEW_CONFIG_DIALOG_CAPTION + typeString, true, new Object[]{ncc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)ncc.okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.pack();
        d.setVisible(true);
        ProfilingSettings newSettings = null;
        if (dd.getValue() == ncc.okButton) {
            newSettings = ncc.getProfilingSettings();
        }
        return newSettings;
    }

    public static ProfilingSettings renameConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupRenameConfiguration(originalConfiguration, availableConfigurations);
        DialogDescriptor dd = new DialogDescriptor((Object)ncc, MessageFormat.format(RENAME_CONFIG_DIALOG_CAPTION, originalConfiguration.getSettingsName()));
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.pack();
        d.setVisible(true);
        ProfilingSettings newSettings = null;
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            newSettings = ncc.getProfilingSettings();
        }
        return newSettings;
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    public void stateChanged(ChangeEvent e) {
        this.existingSettingsList.setEnabled(this.existingSettingsRadio.isSelected());
        if (this.existingSettingsRadio.isEnabled() && this.defaultSettingsRadio.isSelected()) {
            this.existingSettingsList.clearSelection();
        }
        this.updateOKButton();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateOKButton();
    }

    private static NewCustomConfiguration getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new NewCustomConfiguration();
        }
        return defaultInstance;
    }

    private ProfilingSettings getProfilingSettings() {
        ProfilingSettings newSettings = null;
        if (this.mode == 4) {
            newSettings = this.originalSettings;
        } else if (this.mode == 2 || (this.mode == 0 || this.mode == 1) && this.existingSettingsRadio.isSelected()) {
            newSettings = new ProfilingSettings();
            this.availableSettings[this.existingSettingsList.getSelectedIndex()].copySettingsInto(newSettings);
        } else if (this.monitorTypeRadio.isSelected()) {
            newSettings = ProfilingSettingsPresets.createMonitorPreset();
            newSettings.setIsPreset(false);
        } else if (this.cpuTypeRadio.isSelected()) {
            newSettings = ProfilingSettingsPresets.createCPUPreset();
            newSettings.setIsPreset(false);
        } else if (this.memoryTypeRadio.isSelected()) {
            newSettings = ProfilingSettingsPresets.createMemoryPreset();
            newSettings.setIsPreset(false);
        }
        newSettings.setSettingsName(this.nameTextfield.getText().trim());
        return newSettings;
    }

    private String createSettingsName(ProfilingSettings[] availableConfigurations) {
        String nameBasis = NEW_CONFIG_STRING;
        if (this.monitorTypeRadio.isSelected()) {
            nameBasis = NEW_MONITOR_STRING;
        } else if (this.cpuTypeRadio.isSelected()) {
            nameBasis = NEW_CPU_STRING;
        } else if (this.memoryTypeRadio.isSelected()) {
            nameBasis = NEW_MEMORY_STRING;
        }
        ArrayList<String> configurationsNames = new ArrayList<String>(availableConfigurations.length);
        for (ProfilingSettings settings : availableConfigurations) {
            configurationsNames.add(settings.getSettingsName());
        }
        int index = 0;
        String indexStr = "";
        while (configurationsNames.contains(nameBasis + indexStr)) {
            indexStr = " " + Integer.toString(++index);
        }
        return nameBasis + indexStr;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup typeRadiosGroup = new ButtonGroup();
        ButtonGroup settingsRadiosGroup = new ButtonGroup();
        this.typeLabel = new JLabel(TYPE_LABEL_TEXT);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.typeLabel, constraints);
        this.monitorTypeRadio = new JExtendedRadioButton(MONITOR_STRING, ICON_MONITOR);
        Mnemonics.setLocalizedText((AbstractButton)this.monitorTypeRadio, (String)MONITOR_STRING);
        typeRadiosGroup.add(this.monitorTypeRadio);
        this.monitorTypeRadio.setSelected(true);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.monitorTypeRadio, constraints);
        this.cpuTypeRadio = new JExtendedRadioButton(CPU_STRING, ICON_CPU);
        Mnemonics.setLocalizedText((AbstractButton)this.cpuTypeRadio, (String)CPU_STRING);
        typeRadiosGroup.add(this.cpuTypeRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.cpuTypeRadio, constraints);
        this.memoryTypeRadio = new JExtendedRadioButton(MEMORY_STRING, ICON_MEMORY);
        Mnemonics.setLocalizedText((AbstractButton)this.memoryTypeRadio, (String)MEMORY_STRING);
        typeRadiosGroup.add(this.memoryTypeRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.memoryTypeRadio, constraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.nameLabel, constraints);
        this.nameTextfield = new JTextField();
        this.nameTextfield.getDocument().addDocumentListener(this);
        this.nameLabel.setLabelFor(this.nameTextfield);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 5, 0, 10);
        this.add((Component)this.nameTextfield, constraints);
        this.settingsLabel = new JLabel(INIT_SETTINGS_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.settingsLabel, constraints);
        this.defaultSettingsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.defaultSettingsRadio, (String)DEFAULT_RADIO_TEXT);
        settingsRadiosGroup.add(this.defaultSettingsRadio);
        this.defaultSettingsRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.defaultSettingsRadio, constraints);
        this.existingSettingsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.existingSettingsRadio, (String)EXISTING_RADIO_TEXT);
        settingsRadiosGroup.add(this.existingSettingsRadio);
        this.existingSettingsRadio.setSelected(true);
        this.existingSettingsRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 5, 0, 10);
        this.add((Component)this.existingSettingsRadio, constraints);
        this.existingSettingsListModel = new DefaultListModel();
        this.existingSettingsList = new JList(this.existingSettingsListModel);
        this.existingSettingsList.setVisibleRowCount(5);
        this.existingSettingsList.addListSelectionListener(this);
        this.existingSettingsScrollPane = new JScrollPane(this.existingSettingsList, 20, 31);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(4, 5, 15, 10);
        this.add((Component)this.existingSettingsScrollPane, constraints);
        this.bottomRenameSpacer = Utils.createFillerPanel();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.bottomRenameSpacer, constraints);
        this.okButton = new JButton(OK_BUTTON_TEXT);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && NewCustomConfiguration.this.isShowing()) {
                    NewCustomConfiguration.this.nameTextfield.requestFocusInWindow();
                    NewCustomConfiguration.this.nameTextfield.selectAll();
                }
            }
        });
    }

    private void setupDuplicateConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        this.mode = 2;
        this.originalSettings = originalConfiguration;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(Utils.isMonitorSettings(this.originalSettings));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(Utils.isCPUSettings(this.originalSettings));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(Utils.isMemorySettings(this.originalSettings));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(false);
        this.existingSettingsRadio.setEnabled(false);
        this.existingSettingsRadio.setSelected(true);
        this.existingSettingsList.setEnabled(false);
        this.nameTextfield.setText(this.createSettingsName(availableConfigurations));
        this.updateAvailableSettings();
        for (int i = 0; i < availableConfigurations.length; ++i) {
            if (this.originalSettings != availableConfigurations[i]) continue;
            this.existingSettingsList.setSelectedIndex(i);
            return;
        }
        this.updateOKButton();
    }

    private void setupRenameConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        this.mode = 4;
        this.originalSettings = originalConfiguration;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(Utils.isMonitorSettings(this.originalSettings));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(Utils.isCPUSettings(this.originalSettings));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(Utils.isMemorySettings(this.originalSettings));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.settingsLabel.setVisible(false);
        this.defaultSettingsRadio.setVisible(false);
        this.existingSettingsRadio.setVisible(false);
        this.existingSettingsScrollPane.setVisible(false);
        this.bottomRenameSpacer.setVisible(true);
        this.nameTextfield.setText(originalConfiguration.getSettingsName());
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void setupTypeConfiguration(int type, ProfilingSettings[] availableConfigurations) {
        this.mode = 1;
        this.originalSettings = null;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(Utils.isMonitorSettings(type));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(Utils.isCPUSettings(type));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(Utils.isMemorySettings(type));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(true);
        this.defaultSettingsRadio.setSelected(true);
        this.existingSettingsRadio.setEnabled(true);
        this.nameTextfield.setText(this.createSettingsName(availableConfigurations));
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void setupUniversalConfiguration(ProfilingSettings[] availableConfigurations) {
        this.mode = 0;
        this.originalSettings = null;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(true);
        this.cpuTypeRadio.setEnabled(true);
        this.cpuTypeRadio.setSelected(true);
        this.memoryTypeRadio.setEnabled(true);
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(true);
        this.defaultSettingsRadio.setSelected(true);
        this.existingSettingsRadio.setEnabled(true);
        this.nameTextfield.setText(this.createSettingsName(availableConfigurations));
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void updateAvailableSettings() {
        this.existingSettingsListModel.removeAllElements();
        for (ProfilingSettings settings : this.availableSettings) {
            this.existingSettingsListModel.addElement(settings.getSettingsName());
        }
    }

    private void updateOKButton() {
        this.okButton.setEnabled(this.nameTextfield.getText().trim().length() > 0 && (this.defaultSettingsRadio.isSelected() || this.existingSettingsList.getSelectedIndex() != -1));
    }

    static {
        ICON_MONITOR = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/telemetryWindow.png"));
        ICON_CPU = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/cpu.png"));
        ICON_MEMORY = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png"));
    }
}

