/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;

public final class ProfilingMonitor {
    private UpdateThread monitorThread = new UpdateThread();
    private boolean updateThreadStarted = false;

    public void monitorVM(TargetAppRunner runner) {
        if (!this.updateThreadStarted) {
            this.updateThreadStarted = true;
            this.monitorThread.start();
        }
        this.monitorThread.monitor(runner);
    }

    public void stopDisplayingVM() {
        if (this.monitorThread != null) {
            this.monitorThread.monitor(null);
        }
    }

    public void stopUpdateThread() {
        if (this.monitorThread != null) {
            this.monitorThread.stopThread();
            this.monitorThread = null;
        }
    }

    static final class UpdateThread
    extends Thread {
        private static final int UPDATE_INTERVAL = 1200;
        private TargetAppRunner runner;
        private ThreadsDataManager threadsDataManager;
        private VMTelemetryDataManager VMTelemetryManager;
        private boolean doUpdateLiveResults;
        private boolean keepRunning = true;

        UpdateThread() {
            super("Profiler Monitor");
        }

        public void monitor(TargetAppRunner runner) {
            this.runner = runner;
            this.threadsDataManager = Profiler.getDefault().getThreadsManager();
            this.VMTelemetryManager = Profiler.getDefault().getVMTelemetryManager();
            if (runner != null) {
                this.VMTelemetryManager.maxHeapSize = runner.getProfilingSessionStatus().maxHeapSize;
            }
        }

        public void run() {
            while (this.keepRunning) {
                block8: {
                    try {
                        if (this.runner != null) {
                            ProfilerControlPanel2.getDefault().updateStatus();
                            final MonitoredData md = this.runner.getProfilerClient().getMonitoredData();
                            if (md != null) {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        try {
                                            UpdateThread.this.threadsDataManager.processData(md);
                                            UpdateThread.this.VMTelemetryManager.processData(md);
                                            if (UpdateThread.this.doUpdateLiveResults && LiveResultsWindow.hasDefault()) {
                                                LiveResultsWindow.getDefault().refreshLiveResults();
                                            }
                                            UpdateThread.this.doUpdateLiveResults = !UpdateThread.this.doUpdateLiveResults;
                                        }
                                        catch (Exception e) {
                                            Profiler.getDefault().notifyException(8, e);
                                        }
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        ((NetBeansProfiler)Profiler.getDefault()).checkAndUpdateState();
                                    }
                                });
                                this.runner = null;
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block8;
                        throw (ThreadDeath)t;
                    }
                }
                try {
                    UpdateThread.sleep(1200L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        private void stopThread() {
            this.keepRunning = false;
        }
    }
}

