/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.HostsSupport;
import com.sun.tools.visualvm.host.RemoteHostsContainer;
import com.sun.tools.visualvm.host.impl.HostImpl;
import com.sun.tools.visualvm.host.impl.HostProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostProvider {
    private static final Logger LOGGER = Logger.getLogger(HostProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROPERTY_HOSTNAME = "prop_hostname";
    private static InetAddress localhostAddress2;
    private boolean initializingHosts = true;
    private Semaphore initializingHostsSemaphore = new Semaphore(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host createHost(HostProperties hostDescriptor, boolean interactive) {
        ProgressHandle pHandleF;
        this.waitForInitialization();
        final String hostName = hostDescriptor.getHostName();
        InetAddress inetAddress = null;
        ProgressHandle pHandle = null;
        try {
            block10: {
                pHandle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(HostProvider.class, (String)"LBL_Searching_for_host") + hostName));
                pHandle.setInitialDelay(0);
                pHandle.start();
                try {
                    inetAddress = InetAddress.getByName(hostName);
                }
                catch (UnknownHostException e) {
                    if (!interactive) break block10;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String error = NbBundle.getMessage(HostProvider.class, (String)"MSG_Wrong_Host", (Object)hostName);
                            NetBeansProfiler.getDefaultNB().displayError(error);
                        }
                    });
                }
            }
            pHandleF = pHandle;
        }
        catch (Throwable throwable) {
            ProgressHandle pHandleF2 = pHandle;
            SwingUtilities.invokeLater(new Runnable(pHandleF2){
                final /* synthetic */ ProgressHandle val$pHandleF;
                {
                    this.val$pHandleF = progressHandle;
                }

                public void run() {
                    if (this.val$pHandleF != null) {
                        this.val$pHandleF.finish();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        if (inetAddress != null) {
            final Host knownHost = this.getHostByAddress(inetAddress);
            if (knownHost != null) {
                if (interactive) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ExplorerSupport.sharedInstance().selectDataSource((DataSource)knownHost);
                            String warning = NbBundle.getMessage(HostProvider.class, (String)"MSG_Already_Monitored", (Object[])new Object[]{hostName, DataSourceDescriptorFactory.getDescriptor((DataSource)knownHost).getName()});
                            NetBeansProfiler.getDefaultNB().displayWarning(warning);
                        }
                    });
                }
                return knownHost;
            }
            String ipString = inetAddress.getHostAddress();
            String[] propNames = new String[]{SNAPSHOT_VERSION, PROPERTY_HOSTNAME, "prop_name"};
            String[] propValues = new String[]{CURRENT_SNAPSHOT_VERSION, hostName, hostDescriptor.getDisplayName()};
            File customPropertiesStorage = Utils.getUniqueFile((File)HostsSupport.getStorageDirectory(), (String)ipString, (String)".properties");
            Storage storage = new Storage(customPropertiesStorage.getParentFile(), customPropertiesStorage.getName());
            storage.setCustomProperties(propNames, propValues);
            HostImpl newHost = null;
            try {
                newHost = new HostImpl(hostName, storage);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error creating host", e);
            }
            if (newHost != null) {
                RemoteHostsContainer.sharedInstance().getRepository().addDataSource((DataSource)newHost);
            }
            return newHost;
        }
        return null;
    }

    void removeHost(HostImpl host, boolean interactive) {
        this.waitForInitialization();
        DataSource owner = host.getOwner();
        if (owner != null) {
            owner.getRepository().removeDataSource((DataSource)host);
        }
    }

    public Host getHostByAddress(InetAddress inetAddress) {
        this.waitForInitialization();
        Set knownHosts = DataSourceRepository.sharedInstance().getDataSources(HostImpl.class);
        for (HostImpl knownHost : knownHosts) {
            if (!knownHost.getInetAddress().equals(inetAddress)) continue;
            return knownHost;
        }
        if (inetAddress.equals(Host.LOCALHOST.getInetAddress())) {
            return Host.LOCALHOST;
        }
        if (inetAddress.equals(localhostAddress2)) {
            return Host.LOCALHOST;
        }
        if (inetAddress.isLoopbackAddress()) {
            return Host.LOCALHOST;
        }
        return null;
    }

    public Host createLocalHost() {
        try {
            return new Host("localhost"){};
        }
        catch (UnknownHostException e) {
            LOGGER.severe("Critical failure: cannot resolve localhost");
            return null;
        }
    }

    public Host createUnknownHost() {
        try {
            return new Host("unknown", InetAddress.getByAddress(new byte[]{0, 0, 0, 0})){};
        }
        catch (UnknownHostException e) {
            LOGGER.severe("Failure: cannot resolve <unknown> host");
            return null;
        }
    }

    private void initLocalHost() {
        try {
            localhostAddress2 = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Host localhost = Host.LOCALHOST;
        if (localhost != null) {
            DataSource.ROOT.getRepository().addDataSource((DataSource)localhost);
        }
    }

    private void initUnknownHost() {
        final Host unknownhost = Host.UNKNOWN_HOST;
        if (unknownhost != null) {
            unknownhost.getRepository().addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    unknownhost.setVisible(!event.getCurrent().isEmpty());
                }
            }, DataSource.class);
            RemoteHostsContainer.sharedInstance().getRepository().addDataSource((DataSource)unknownhost);
        }
    }

    private void initPersistedHosts() {
        if (HostsSupport.storageDirectoryExists()) {
            File[] files = HostsSupport.getStorageDirectory().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            });
            HashSet<File> unresolvedHostsF = new HashSet<File>();
            HashSet<String> unresolvedHostsS = new HashSet<String>();
            HashSet<HostImpl> hosts = new HashSet<HostImpl>();
            for (File file : files) {
                Storage storage = new Storage(file.getParentFile(), file.getName());
                String hostName = storage.getCustomProperty(PROPERTY_HOSTNAME);
                HostImpl persistedHost = null;
                try {
                    persistedHost = new HostImpl(hostName, storage);
                }
                catch (Exception e) {
                    LOGGER.throwing(HostProvider.class.getName(), "initPersistedHosts", e);
                    unresolvedHostsF.add(file);
                    unresolvedHostsS.add(hostName);
                }
                if (persistedHost == null) continue;
                hosts.add(persistedHost);
            }
            if (!unresolvedHostsF.isEmpty()) {
                HostProvider.notifyUnresolvedHosts(unresolvedHostsF, unresolvedHostsS);
            }
            RemoteHostsContainer.sharedInstance().getRepository().addDataSources(hosts);
        }
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                HostProvider.this.initializingHostsSemaphore.release();
                HostProvider.this.initializingHosts = false;
            }
        });
    }

    private static void notifyUnresolvedHosts(final Set<File> unresolvedHostsF, final Set<String> unresolvedHostsS) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                JPanel messagePanel = new JPanel(new BorderLayout(5, 5));
                messagePanel.add((Component)new JLabel(NbBundle.getMessage(HostProvider.class, (String)"MSG_Unresolved_Hosts")), "North");
                JList<Object> list = new JList<Object>(unresolvedHostsS.toArray());
                list.setVisibleRowCount(4);
                messagePanel.add((Component)new JScrollPane(list), "Center");
                NotifyDescriptor dd = new NotifyDescriptor((Object)messagePanel, NbBundle.getMessage(HostProvider.class, (String)"Title_Unresolved_Hosts"), 0, 0, null, NotifyDescriptor.YES_OPTION);
                if (DialogDisplayer.getDefault().notify(dd) == NotifyDescriptor.NO_OPTION) {
                    for (File file : unresolvedHostsF) {
                        Utils.delete((File)file, (boolean)true);
                    }
                }
                unresolvedHostsF.clear();
                unresolvedHostsS.clear();
            }
        }, 1000);
    }

    private void waitForInitialization() {
        if (this.initializingHosts) {
            try {
                this.initializingHostsSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                LOGGER.throwing(HostProvider.class.getName(), "waitForInitialization", ex);
            }
        }
    }

    public void initialize() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        HostProvider.this.initLocalHost();
                        HostProvider.this.initUnknownHost();
                        HostProvider.this.initPersistedHosts();
                    }
                });
            }
        });
    }

    public HostProvider() {
        try {
            this.initializingHostsSemaphore.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.throwing(HostProvider.class.getName(), "<init>", ex);
        }
    }
}

