/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.threads.CustomTimeLineViewport;
import org.netbeans.lib.profiler.ui.threads.ThreadNameCellRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateCellRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateHeaderRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;

public class ThreadsPanel
extends JPanel
implements AdjustmentListener,
ActionListener,
TableColumnModelListener,
DataManagerListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String VIEW_THREADS_ALL = messages.getString("ThreadsPanel_ViewThreadsAll");
    private static final String VIEW_THREADS_LIVE = messages.getString("ThreadsPanel_ViewThreadsLive");
    private static final String VIEW_THREADS_FINISHED = messages.getString("ThreadsPanel_ViewThreadsFinished");
    private static final String VIEW_THREADS_SELECTION = messages.getString("ThreadsPanel_ViewThreadsSelection");
    private static final String THREADS_TABLE = messages.getString("ThreadsPanel_ThreadsTable");
    private static final String ENABLE_THREADS_PROFILING = messages.getString("ThreadsPanel_EnableThreadsProfiling");
    private static final String ZOOM_IN_TOOLTIP = messages.getString("ThreadsPanel_ZoomInToolTip");
    private static final String ZOOM_OUT_TOOLTIP = messages.getString("ThreadsPanel_ZoomOutToolTip");
    private static final String FIXED_SCALE_TOOLTIP = messages.getString("ThreadsPanel_FixedScaleToolTip");
    private static final String SCALE_TO_FIT_TOOLTIP = messages.getString("ThreadsPanel_ScaleToFitToolTip");
    private static final String THREADS_MONITORING_DISABLED_1_MSG = messages.getString("ThreadsPanel_ThreadsMonitoringDisabled1Msg");
    private static final String THREADS_MONITORING_DISABLED_2_MSG = messages.getString("ThreadsPanel_ThreadsMonitoringDisabled2Msg");
    private static final String NO_PROFILING_MSG = messages.getString("ThreadsPanel_NoProfilingMsg");
    private static final String THREADS_COLUMN_NAME = messages.getString("ThreadsPanel_ThreadsColumnName");
    private static final String TIMELINE_COLUMN_NAME = messages.getString("ThreadsPanel_TimelineColumnName");
    private static final String SELECTED_THREADS_ITEM = messages.getString("ThreadsPanel_SelectedThreadsItem");
    private static final String THREAD_DETAILS_ITEM = messages.getString("ThreadsPanel_ThreadDetailsItem");
    private static final String TABLE_ACCESS_NAME = messages.getString("ThreadsPanel_TableAccessName");
    private static final String TABLE_ACCESS_DESCR = messages.getString("ThreadsPanel_TableAccessDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ComboAccessDescr");
    private static final String ENABLE_THREADS_MONITORING_BUTTON_ACCESS_NAME = messages.getString("ThreadsPanel_EnableThreadsMonitoringAccessName");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int DISPLAY_COLUMN_INDEX = 1;
    private static final int RIGHT_DISPLAY_MARGIN = 20;
    private static final int LEFT_DISPLAY_MARGIN = 20;
    private static final int NAME_COLUMN_WIDTH = 190;
    private static final int MIN_NAME_COLUMN_WIDTH = 55;
    private ArrayList filteredDataToDataIndex = new ArrayList();
    private CustomTimeLineViewport viewPort;
    private DefaultComboBoxModel comboModel;
    private DefaultComboBoxModel comboModelWithSelection;
    private JButton enableThreadsMonitoringButton;
    private JButton scaleToFitButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JComboBox threadsSelectionCombo;
    private JLabel enableThreadsMonitoringLabel1;
    private JLabel enableThreadsMonitoringLabel2;
    private JLabel enableThreadsMonitoringLabel3;
    private JLabel monitorLegend;
    private JLabel runningLegend;
    private JLabel sleepingLegend;
    private JLabel waitLegend;
    private JMenuItem showOnlySelectedThreads;
    private JMenuItem showThreadsDetails;
    private JPanel contentPanel;
    private JPanel notificationPanel;
    private JPopupMenu popupMenu;
    private JScrollBar scrollBar;
    private JScrollPane tableScroll;
    private JTable table;
    private JToolBar buttonsToolBar;
    private ThreadsDataManager manager;
    private ThreadsDetailsCallback detailsCallback;
    private boolean internalChange = false;
    private boolean internalScrollbarChange = false;
    private boolean resetPerformed = true;
    private boolean scaleToFit = false;
    private boolean supportsSleepingState;
    private boolean threadsMonitoringEnabled = false;
    private boolean trackingEnd = true;
    private float zoomResolutionPerPixel = 50.0f;
    private long viewEnd;
    private long viewStart = -1L;

    public ThreadsPanel(ThreadsDataManager manager, ThreadsDetailsCallback detailsCallback, boolean supportsSleepingState) {
        this.manager = manager;
        this.detailsCallback = detailsCallback;
        this.supportsSleepingState = supportsSleepingState;
        this.setOpaque(true);
        this.setBackground(new HTMLTextArea().getBackground());
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.setOpaque(true);
        this.contentPanel.setBackground(new HTMLTextArea().getBackground());
        this.table = this.createViewTable();
        this.table.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.table.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.table.getAccessibleContext().setAccessibleDescription(TABLE_ACCESS_DESCR);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.table.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.performDefaultAction();
            }
        });
        this.scrollBar = new ThreadsScrollBar();
        this.zoomInButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/zoomIn.png")));
        this.zoomOutButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/zoomOut.png")));
        this.scaleToFitButton = new JButton(new ImageIcon(this.getClass().getResource(this.scaleToFit ? "/org/netbeans/lib/profiler/ui/resources/zoom.png" : "/org/netbeans/lib/profiler/ui/resources/scaleToFit.png")));
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED});
        this.comboModelWithSelection = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED, VIEW_THREADS_SELECTION});
        this.threadsSelectionCombo = new JComboBox(this.comboModel){

            public Dimension getMaximumSize() {
                return new Dimension(250, this.getPreferredSize().height);
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        JLabel showLabel = new JLabel(SHOW_LABEL_TEXT);
        showLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        showLabel.setLabelFor(this.threadsSelectionCombo);
        int mnemCharIndex = 0;
        showLabel.setDisplayedMnemonic(showLabel.getText().charAt(mnemCharIndex));
        showLabel.setDisplayedMnemonicIndex(mnemCharIndex);
        this.buttonsToolBar = new FlatToolBar(){

            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)comp);
                }
                return super.add(comp);
            }
        };
        this.buttonsToolBar.setOpaque(true);
        this.buttonsToolBar.setBackground(this.getBackground());
        JPanel tablePanel = new JPanel();
        tablePanel.setOpaque(false);
        JPanel scrollPanel = new JPanel();
        scrollPanel.setOpaque(false);
        this.popupMenu = this.initPopupMenu();
        this.zoomInButton.setEnabled(!this.scaleToFit);
        this.zoomOutButton.setEnabled(!this.scaleToFit);
        this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
        this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
        this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        this.zoomInButton.getAccessibleContext().setAccessibleName(this.zoomInButton.getToolTipText());
        this.zoomOutButton.getAccessibleContext().setAccessibleName(this.zoomOutButton.getToolTipText());
        this.scaleToFitButton.getAccessibleContext().setAccessibleName(this.scaleToFitButton.getToolTipText());
        this.table.setSelectionMode(2);
        this.table.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.table.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setRowHeight(23);
        DefaultTableCellRenderer defaultHeaderRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setBackground(Color.WHITE);
                component.setFont(table.getFont().deriveFont(1));
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(new EmptyBorder(0, 3, 0, 3));
                }
                return component;
            }
        };
        this.table.getTableHeader().setDefaultRenderer(defaultHeaderRenderer);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(3);
        this.table.getColumnModel().getColumn(0).setMinWidth(55);
        this.table.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(190);
        ThreadStateHeaderRenderer headerRenderer = new ThreadStateHeaderRenderer(this);
        headerRenderer.setBackground(Color.WHITE);
        this.table.getColumnModel().getColumn(1).setHeaderRenderer(headerRenderer);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        columnModel.setColumnMargin(0);
        this.table.setDefaultRenderer(ThreadNameCellRenderer.class, new ThreadNameCellRenderer(this));
        this.table.setDefaultRenderer(ThreadStateCellRenderer.class, new ThreadStateCellRenderer(this));
        this.buttonsToolBar.setFloatable(false);
        this.buttonsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        tablePanel.setLayout(new BorderLayout());
        scrollPanel.setLayout(new BorderLayout());
        scrollPanel.setBackground(Color.WHITE);
        this.buttonsToolBar.add(this.zoomInButton);
        this.buttonsToolBar.add(this.zoomOutButton);
        this.buttonsToolBar.add(this.scaleToFitButton);
        this.buttonsToolBar.addSeparator();
        this.buttonsToolBar.add(showLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        scrollPanel.add((Component)this.scrollBar, "East");
        ThreadStateIcon runningIcon = new ThreadStateIcon(1, 18, 9);
        ThreadStateIcon sleepingIcon = new ThreadStateIcon(2, 18, 9);
        ThreadStateIcon monitorIcon = new ThreadStateIcon(3, 18, 9);
        ThreadStateIcon waitIcon = new ThreadStateIcon(4, 18, 9);
        this.runningLegend = new JLabel(CommonConstants.THREAD_STATUS_RUNNING_STRING, runningIcon, 10);
        this.runningLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.sleepingLegend = new JLabel(CommonConstants.THREAD_STATUS_SLEEPING_STRING, sleepingIcon, 10);
        this.sleepingLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.waitLegend = new JLabel(CommonConstants.THREAD_STATUS_WAIT_STRING, waitIcon, 10);
        this.waitLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.monitorLegend = new JLabel(CommonConstants.THREAD_STATUS_MONITOR_STRING, monitorIcon, 10);
        this.monitorLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel legendPanel = new JPanel();
        legendPanel.setOpaque(false);
        legendPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        legendPanel.add(this.runningLegend);
        legendPanel.add(this.sleepingLegend);
        if (!supportsSleepingState) {
            this.sleepingLegend.setVisible(false);
        }
        legendPanel.add(this.waitLegend);
        legendPanel.add(this.monitorLegend);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)legendPanel, "East");
        JPanel dataPanel = new JPanel();
        dataPanel.setOpaque(false);
        dataPanel.setLayout(new BorderLayout());
        dataPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.tableScroll = new JScrollPane();
        this.tableScroll.setOpaque(false);
        this.tableScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tableScroll.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.tableScroll.getCorner("UPPER_RIGHT_CORNER").setBackground(Color.WHITE);
        this.viewPort = new CustomTimeLineViewport(this);
        this.viewPort.setView(this.table);
        this.viewPort.setBackground(this.table.getBackground());
        this.tableScroll.setViewport(this.viewPort);
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.tableScroll.setVerticalScrollBarPolicy(20);
        dataPanel.add((Component)this.tableScroll, "Center");
        dataPanel.add((Component)scrollPanel, "South");
        tablePanel.add((Component)dataPanel, "Center");
        tablePanel.add((Component)bottomPanel, "South");
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBorder(dataPanel.getBorder());
        this.notificationPanel.setBackground(this.table.getBackground());
        CompoundBorder myRolloverBorder = new CompoundBorder(new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatToolBar.FlatMarginBorder());
        this.enableThreadsMonitoringLabel1 = new JLabel(THREADS_MONITORING_DISABLED_1_MSG);
        this.enableThreadsMonitoringLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 3));
        this.enableThreadsMonitoringLabel1.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/threadsView.png")));
        this.enableThreadsMonitoringButton.setContentAreaFilled(false);
        this.enableThreadsMonitoringButton.setMargin(new Insets(3, 3, 0, 0));
        this.enableThreadsMonitoringButton.setVerticalTextPosition(3);
        this.enableThreadsMonitoringButton.setHorizontalTextPosition(0);
        this.enableThreadsMonitoringButton.setRolloverEnabled(true);
        this.enableThreadsMonitoringButton.setBorder(myRolloverBorder);
        this.enableThreadsMonitoringButton.getAccessibleContext().setAccessibleName(ENABLE_THREADS_MONITORING_BUTTON_ACCESS_NAME);
        this.enableThreadsMonitoringLabel2 = new JLabel(THREADS_MONITORING_DISABLED_2_MSG);
        this.enableThreadsMonitoringLabel2.setBorder(BorderFactory.createEmptyBorder(20, 3, 20, 0));
        this.enableThreadsMonitoringLabel2.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringLabel3 = new JLabel(NO_PROFILING_MSG);
        this.enableThreadsMonitoringLabel3.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.enableThreadsMonitoringLabel3.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringLabel3.setVisible(false);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel1);
        this.notificationPanel.add(this.enableThreadsMonitoringButton);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel2);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel3);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.notificationPanel, ENABLE_THREADS_PROFILING);
        this.contentPanel.add((Component)tablePanel, THREADS_TABLE);
        this.add((Component)this.buttonsToolBar, "North");
        this.add((Component)this.contentPanel, "Center");
        this.scrollBar.addAdjustmentListener(this);
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.scaleToFitButton.addActionListener(this);
        this.threadsSelectionCombo.addActionListener(this);
        this.showOnlySelectedThreads.addActionListener(this);
        if (detailsCallback != null) {
            this.showThreadsDetails.addActionListener(this);
        }
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ThreadsPanel.this.refreshViewData();
                ThreadsPanel.this.updateScrollbar();
                ThreadsPanel.this.updateZoomButtonsEnabledState();
                ThreadsPanel.this.revalidate();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ThreadsPanel.this.table.getSelectedRow()) != -1) {
                    Rectangle cellRect = ThreadsPanel.this.table.getCellRect(selectedRow, 0, false);
                    ThreadsPanel.this.popupMenu.show(e.getComponent(), cellRect.x + ((ThreadsPanel)ThreadsPanel.this).table.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int line;
                if ((e.getModifiers() & 4) != 0 && (line = ThreadsPanel.this.table.rowAtPoint(e.getPoint())) != -1 && !ThreadsPanel.this.table.isRowSelected(line)) {
                    if (e.isControlDown()) {
                        ThreadsPanel.this.table.addRowSelectionInterval(line, line);
                    } else {
                        ThreadsPanel.this.table.setRowSelectionInterval(line, line);
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
                int clickedLine = ThreadsPanel.this.table.rowAtPoint(e.getPoint());
                if (clickedLine != -1) {
                    if ((e.getModifiers() & 4) != 0) {
                        ThreadsPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        ThreadsPanel.this.performDefaultAction();
                    }
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ThreadsPanel.this.dataChanged();
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.table.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.table.setFocusTraversalKeys(1, keys);
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        manager.addDataListener((DataManagerListener)this);
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.tableScroll);
        }
        return UIUtils.createScreenshot(this.table);
    }

    public long getDataEnd() {
        return this.manager.getEndTime();
    }

    public long getDataStart() {
        return this.manager.getStartTime();
    }

    public int getDisplayColumnWidth() {
        return this.table.getTableHeader().getHeaderRect((int)1).width;
    }

    public String getThreadClassName(int index) {
        return this.manager.getThreadClassName(index);
    }

    public ThreadData getThreadData(int index) {
        return this.manager.getThreadData(index);
    }

    public String getThreadName(int index) {
        return this.manager.getThreadName(index);
    }

    public long getViewEnd() {
        return this.viewEnd;
    }

    public long getViewStart() {
        return this.viewStart;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.internalChange) {
            return;
        }
        if (e.getSource() == this.scaleToFitButton) {
            if (!this.scaleToFit) {
                this.scrollBar.setVisible(true);
                this.scaleToFitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/zoom.png")));
                this.scaleToFit = true;
            } else {
                this.scaleToFit = false;
                this.scaleToFitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/scaleToFit.png")));
                this.scrollBar.setVisible(false);
                this.scrollBar.setValues(0, 0, 0, 0);
            }
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (e.getSource() == this.zoomInButton) {
            this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
            this.zoomResolutionPerPixel /= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (e.getSource() == this.zoomOutButton) {
            this.zoomResolutionPerPixel *= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (e.getSource() == this.threadsSelectionCombo) {
            if (this.threadsSelectionCombo.getModel() == this.comboModelWithSelection && this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
                this.internalChange = true;
                Object selectedItem = this.threadsSelectionCombo.getSelectedItem();
                this.threadsSelectionCombo.setModel(this.comboModel);
                this.threadsSelectionCombo.setSelectedItem(selectedItem);
                this.internalChange = false;
            }
            this.table.clearSelection();
            this.dataChanged();
        } else if (e.getSource() == this.showOnlySelectedThreads) {
            for (int i = this.filteredDataToDataIndex.size() - 1; i >= 0; --i) {
                if (this.table.isRowSelected(i)) continue;
                this.filteredDataToDataIndex.remove(i);
            }
            this.threadsSelectionCombo.setModel(this.comboModelWithSelection);
            this.threadsSelectionCombo.setSelectedItem(VIEW_THREADS_SELECTION);
            this.table.clearSelection();
        } else if (e.getSource() == this.showThreadsDetails) {
            this.performDefaultAction();
        }
    }

    public void addSaveViewAction(AbstractAction saveViewAction) {
        JButton actionButton = this.buttonsToolBar.add(saveViewAction);
        this.buttonsToolBar.remove(actionButton);
        this.buttonsToolBar.add((Component)actionButton, 0);
        this.buttonsToolBar.add((Component)new JToolBar.Separator(), 1);
    }

    public void addThreadsMonitoringActionListener(ActionListener listener) {
        this.enableThreadsMonitoringButton.addActionListener(listener);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.internalScrollbarChange) {
            if (this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() == this.scrollBar.getMaximum()) {
                this.trackingEnd = true;
            } else {
                this.trackingEnd = false;
                this.viewStart = this.manager.getStartTime() + (long)this.scrollBar.getValue();
                this.viewEnd = this.viewStart + (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
                this.repaint();
            }
        }
    }

    public void columnAdded(TableColumnModelEvent e) {
    }

    public void columnMarginChanged(ChangeEvent e) {
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        if (this.viewPort != null) {
            this.viewPort.repaint();
        }
        this.scrollBar.invalidate();
        this.revalidate();
    }

    public void columnMoved(TableColumnModelEvent e) {
    }

    public void columnRemoved(TableColumnModelEvent e) {
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public void dataChanged() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ThreadsPanel.this.refreshUI();
            }
        });
    }

    public void dataReset() {
        this.filteredDataToDataIndex.clear();
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ThreadsPanel.this.refreshUI();
                ThreadsPanel.this.updateSupportsSleepingState(ThreadsPanel.this.manager.supportsSleepingStateMonitoring());
            }
        });
    }

    public boolean fitsVisibleArea() {
        return !this.tableScroll.getVerticalScrollBar().isVisible();
    }

    public boolean hasView() {
        return !this.notificationPanel.isShowing();
    }

    public void profilingSessionFinished() {
        this.enableThreadsMonitoringButton.setEnabled(false);
        this.enableThreadsMonitoringLabel1.setVisible(false);
        this.enableThreadsMonitoringLabel2.setVisible(false);
        this.enableThreadsMonitoringButton.setVisible(false);
        this.enableThreadsMonitoringLabel3.setVisible(true);
    }

    public void profilingSessionStarted() {
        this.enableThreadsMonitoringButton.setEnabled(true);
        this.enableThreadsMonitoringLabel1.setVisible(true);
        this.enableThreadsMonitoringLabel2.setVisible(true);
        this.enableThreadsMonitoringButton.setVisible(true);
        this.enableThreadsMonitoringLabel3.setVisible(false);
    }

    public void removeThreadsMonitoringActionListener(ActionListener listener) {
        this.enableThreadsMonitoringButton.removeActionListener(listener);
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ThreadsPanel.this.table != null) {
                    ThreadsPanel.this.table.requestFocus();
                }
            }
        });
    }

    public void threadsMonitoringDisabled() {
        this.threadsMonitoringEnabled = false;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, ENABLE_THREADS_PROFILING);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(false);
    }

    public void threadsMonitoringEnabled() {
        this.threadsMonitoringEnabled = true;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, THREADS_TABLE);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(true);
    }

    boolean supportsSleepingState() {
        return this.supportsSleepingState;
    }

    private JTable createViewTable() {
        return new JExtendedTable(new ThreadsTableModel()){

            public void mouseMoved(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int column = this.columnAtPoint(event.getPoint());
                if (this.getColumnClass(column) != ThreadNameCellRenderer.class) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                if (row == this.lastRow && column == this.lastColumn) {
                    return;
                }
                this.lastRow = row;
                this.lastColumn = column;
                if (row < 0 || column < 0) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                Component cellRenderer = ((ThreadNameCellRenderer)this.getCellRenderer(row, column)).getTableCellRendererComponentPersistent(this, this.getValueAt(row, column), false, false, row, column);
                Rectangle cellRect = this.getCellRect(row, column, false);
                if (cellRenderer == null) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                int horizontalAlignment = ((ThreadNameCellRenderer)cellRenderer).getHorizontalAlignment();
                this.rendererRect = horizontalAlignment == 11 || horizontalAlignment == 4 ? new Rectangle(cellRect.x + cellRect.width - cellRenderer.getPreferredSize().width, cellRect.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height) : new Rectangle(cellRect.x, cellRect.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height);
                if (this.rendererRect.x >= cellRect.x && this.rendererRect.x + this.rendererRect.width <= cellRect.x + cellRect.width) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                while (this.cellTip.getComponentCount() > 0) {
                    this.cellTip.remove(0);
                }
                this.cellTip.add(cellRenderer, "Center");
                this.cellTip.setPreferredSize(new Dimension(this.rendererRect.width + 2, this.getRowHeight(row) + 2));
                CellTipManager.sharedInstance().setEnabled(true);
            }
        };
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.showOnlySelectedThreads = new JMenuItem(SELECTED_THREADS_ITEM);
        if (this.detailsCallback != null) {
            Font boldfont = popup.getFont().deriveFont(1);
            this.showThreadsDetails = new JMenuItem(THREAD_DETAILS_ITEM);
            this.showThreadsDetails.setFont(boldfont);
            popup.add(this.showThreadsDetails);
            popup.add(new JSeparator());
        }
        popup.add(this.showOnlySelectedThreads);
        return popup;
    }

    private void performDefaultAction() {
        int[] array = this.table.getSelectedRows();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)this.filteredDataToDataIndex.get(array[i]);
        }
        this.detailsCallback.showDetails(array);
    }

    private void refreshUI() {
        if (!this.isShowing()) {
            return;
        }
        this.updateFilteredData();
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        this.table.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void refreshViewData() {
        if (this.scaleToFit) {
            long dataLen = this.manager.getEndTime() - this.manager.getStartTime();
            int viewLen = this.table.getTableHeader().getHeaderRect((int)1).width;
            float currentResolution = (float)dataLen / (float)Math.max(viewLen - 20 - 20, 1);
            this.viewStart = this.manager.getStartTime() - (long)(currentResolution * 20.0f);
            this.viewEnd = this.manager.getEndTime() + (long)(currentResolution * 20.0f);
        } else {
            long rightMarginInTime = (long)(this.zoomResolutionPerPixel * 20.0f);
            long leftMarginInTime = (long)(this.zoomResolutionPerPixel * 20.0f);
            long widthInTime = (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
            if (this.viewStart == -1L) {
                this.viewStart = this.manager.getStartTime() - leftMarginInTime;
                this.viewEnd = this.viewStart + widthInTime;
            }
            if (this.trackingEnd) {
                this.viewEnd = this.manager.getEndTime() + rightMarginInTime;
                this.viewStart = this.viewEnd - widthInTime;
                if (this.viewStart < this.manager.getStartTime() - leftMarginInTime) {
                    this.viewStart = this.manager.getStartTime() - leftMarginInTime;
                    this.viewEnd = this.viewStart + widthInTime;
                }
            } else {
                if (this.viewStart < this.manager.getStartTime()) {
                    this.viewStart = this.manager.getStartTime() - rightMarginInTime;
                }
                this.viewEnd = this.viewStart + widthInTime;
            }
        }
    }

    private void updateFilteredData() {
        if (this.threadsSelectionCombo.getSelectedItem() == VIEW_THREADS_SELECTION) {
            return;
        }
        this.filteredDataToDataIndex.clear();
        for (int i = 0; i < this.manager.getThreadsCount(); ++i) {
            byte state;
            ThreadData threadData;
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_ALL)) {
                this.filteredDataToDataIndex.add(new Integer(i));
                continue;
            }
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_LIVE)) {
                threadData = this.manager.getThreadData(i);
                if (threadData.size() <= 0 || (state = threadData.getLastState()) == 0) continue;
                this.filteredDataToDataIndex.add(new Integer(i));
                continue;
            }
            if (!this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_FINISHED)) continue;
            threadData = this.manager.getThreadData(i);
            if (threadData.size() > 0) {
                state = threadData.getLastState();
                if (state != 0) continue;
                this.filteredDataToDataIndex.add(new Integer(i));
                continue;
            }
            this.filteredDataToDataIndex.add(new Integer(i));
        }
    }

    private void updateScrollbar() {
        this.internalScrollbarChange = true;
        if (this.scrollBar.isVisible() == this.scaleToFit) {
            this.scrollBar.setVisible(!this.scaleToFit);
        }
        if (!this.scaleToFit) {
            int rightMarginInTime = (int)(this.zoomResolutionPerPixel * 20.0f);
            int leftMarginInTime = (int)(this.zoomResolutionPerPixel * 20.0f);
            int value = (int)(this.viewStart - this.manager.getStartTime()) + leftMarginInTime;
            int extent = (int)(this.viewEnd - this.viewStart);
            int intMax = (int)(this.manager.getEndTime() - this.manager.getStartTime()) + rightMarginInTime;
            boolean shouldBeVisible = true;
            if (value == 0 && intMax - (value + extent) <= 0) {
                shouldBeVisible = false;
            }
            if (this.scrollBar.isVisible() != shouldBeVisible) {
                this.scrollBar.setVisible(shouldBeVisible);
            }
            if (shouldBeVisible) {
                this.scrollBar.setValues(value, extent, -leftMarginInTime, intMax);
                this.scrollBar.setBlockIncrement((int)((float)extent * 0.95f));
                this.scrollBar.setUnitIncrement(Math.max((int)(this.zoomResolutionPerPixel * 5.0f), 1));
            }
        }
        this.internalScrollbarChange = false;
    }

    private void updateSupportsSleepingState(boolean supportsSleepingState) {
        if (this.supportsSleepingState != supportsSleepingState) {
            this.supportsSleepingState = supportsSleepingState;
            this.sleepingLegend.setVisible(supportsSleepingState);
        }
    }

    private void updateZoomButtonsEnabledState() {
        if (!this.threadsMonitoringEnabled) {
            this.zoomInButton.setEnabled(false);
            this.zoomOutButton.setEnabled(false);
            this.scaleToFitButton.setEnabled(false);
        } else {
            if (this.scaleToFit) {
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
                int viewWidth = this.table.getTableHeader().getHeaderRect((int)1).width;
                this.zoomOutButton.setEnabled(this.zoomResolutionPerPixel * (float)viewWidth < 2.0f * (float)(this.manager.getEndTime() - this.manager.getStartTime()));
            }
            this.scaleToFitButton.setEnabled(true);
            this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        }
    }

    private class ThreadsTableModel
    extends AbstractTableModel {
        private ThreadsTableModel() {
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ThreadNameCellRenderer.class;
                }
                case 1: {
                    return ThreadStateCellRenderer.class;
                }
            }
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return THREADS_COLUMN_NAME;
                }
                case 1: {
                    return TIMELINE_COLUMN_NAME;
                }
            }
            return null;
        }

        public int getRowCount() {
            return ThreadsPanel.this.filteredDataToDataIndex.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return (Integer)ThreadsPanel.this.filteredDataToDataIndex.get(rowIndex);
                }
                case 1: {
                    return ThreadsPanel.this.getThreadData((Integer)ThreadsPanel.this.filteredDataToDataIndex.get(rowIndex));
                }
            }
            return null;
        }
    }

    class ThreadsScrollBar
    extends JScrollBar {
        public ThreadsScrollBar() {
            super(0);
        }

        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            return new Dimension(((ThreadsPanel)ThreadsPanel.this).table.getTableHeader().getHeaderRect((int)1).width, pref.height);
        }
    }

    public static interface ThreadsDetailsCallback {
        public void showDetails(int[] var1);
    }
}

